/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.documento.cda;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.domain.DocumentoItemDividaAtivaId;
import br.com.elotech.tributos.dto.acrescimo.AcrescimoCdaDTO;
import br.com.elotech.tributos.repository.documento.cda.DocumentoItemDividaAtivaRepositoryCustom;
import java.util.List;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class DocumentoItemDividaAtivaRepositoryImpl
implements DocumentoItemDividaAtivaRepositoryCustom {
    private static final String IDS_DIFERENTES_DE_ABERTO = "br/com/elotech/tributos/repository/find-ids-diferentes-de-aberto.sql";
    private static final String SQL_ACRESCIMOS_CDA_ITEM = "br/com/elotech/tributos/repository/find-acrescimos-cda-item.sql";
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public DocumentoItemDividaAtivaRepositoryImpl(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<DocumentoItemDividaAtivaId> findIdsDiferentesDeAberto(Long entidade, Long exercicio, Long documento) {
        String sql = FileUtils.readResourceAsString((String)IDS_DIFERENTES_DE_ABERTO);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("entidade", (Object)entidade);
        parameters.addValue("exercicio", (Object)exercicio);
        parameters.addValue("documento", (Object)documento);
        return this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(DocumentoItemDividaAtivaId.class));
    }

    public AcrescimoCdaDTO findAcrescimosCdaItem(Long entidade, Long exercicio, Long documento, Long sequenciaItem) {
        String sql = FileUtils.readResourceAsString((String)SQL_ACRESCIMOS_CDA_ITEM);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("entidade", (Object)entidade);
        parameters.addValue("exercicio", (Object)exercicio);
        parameters.addValue("documento", (Object)documento);
        parameters.addValue("sequenciaItem", (Object)sequenciaItem);
        return (AcrescimoCdaDTO)this.jdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(AcrescimoCdaDTO.class));
    }
}

