/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.repository.support.CrudRepository;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.pagamento.PagamentoLoteId;
import br.com.elotech.tributos.dto.integracaocontabil.SituacaoIntegracaoContabil;
import br.com.elotech.tributos.dto.pagamento.PagamentoLoteIntegracaoDTO;
import java.time.LocalDate;
import java.util.List;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface PagamentoLoteRepository
extends CrudRepository<PagamentoLote, PagamentoLoteId> {
    public boolean existsByArquivoHash(String var1);

    @Query(value="select p from PagamentoLote p  where p.id.entidade = :entidade and       p.id.exercicio = :exercicio and       p.dataMovimento in (:dias)")
    public List<PagamentoLote> findByDataMovimentacao(@Param(value="entidade") Long var1, @Param(value="exercicio") Long var2, @Param(value="dias") List<LocalDate> var3);

    @Query(value="select pagamentoLote from PagamentoLote pagamentoLote where not exists ( select 1                    from LoteIntegracaoContabil loteIntegracaoContabil                    where loteIntegracaoContabil.pagamentoLote = pagamentoLote                        and loteIntegracaoContabil.situacaoIntegracaoContabil <> :situacao) and pagamentoLote.dataMovimento = :data and pagamentoLote.contaBancaria.integraArrecadacao = true ")
    public List<PagamentoLote> findAllNotIntegradoByDataMovimentoAndSituacao(@Param(value="data") LocalDate var1, @Param(value="situacao") SituacaoIntegracaoContabil var2);

    @Query(value="select new br.com.elotech.tributos.dto.pagamento.PagamentoLoteIntegracaoDTO(pagamentoLote) from PagamentoLote pagamentoLote  where pagamentoLote.id.entidade = :entidade and       pagamentoLote.id.exercicio = :exercicio and       pagamentoLote.dataMovimento in (:dias)")
    public List<PagamentoLoteIntegracaoDTO> findPagamentoLoteToPagamentoLoteIntegracaoDTO(@Param(value="entidade") Long var1, @Param(value="exercicio") Long var2, @Param(value="dias") List<LocalDate> var3);
}

