/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.repository.support.CrudRepository;
import br.com.elotech.tributos.domain.ImobiliarioItbi;
import br.com.elotech.tributos.domain.TipoCadastro;
import java.util.List;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface ImobiliarioItbiRepository
extends CrudRepository<ImobiliarioItbi, Long> {
    @Query(value=" select coalesce(max(codigoItbi), 0) + 1  from tribimobiliarioitbi  where entidade = :entidade   AND exercicio = :exercicio ", nativeQuery=true)
    public Long findNextCodigoItbiByExercicio(@Param(value="entidade") Long var1, @Param(value="exercicio") Long var2);

    @Query(value=" select iddebito from tribimobiliarioitbi itbi inner join tribdebito deb on deb.entidade = itbi.entidade                         and deb.exercicio = itbi.exercicio                         and deb.tipocadastro = itbi.tipocadastro                         and deb.cadastrogeral = itbi.cadastrogeral                         and deb.guiarecolhimento = itbi.guiarecolhimento                         and deb.subdivida = itbi.subdivida where itbi.idsequencia = :idsequencia ", nativeQuery=true)
    public Long findIdDebitoById(@Param(value="idsequencia") Long var1);

    @Query(value=" select itbi.idsequencia    from tribimobiliarioitbi itbi   where itbi.idsequencia in (:ids)    and (          ( itbi.idparcelamento is null            and not exists (select 1                   from tribdebitoparcela tdp                   inner join tribsituacaoparcela tsp on tdp.situacaodebito = tsp.situacaoparcela                   inner join tribtiposituacaoparcela ttsp on tsp.tiposituacaoparcela = ttsp.tiposituacaoparcela                   where itbi.entidade         = tdp.entidade                     and itbi.exercicio        = tdp.exercicio                     and itbi.tipocadastro     = tdp.tipocadastro                     and itbi.cadastrogeral    = tdp.cadastrogeral                     and itbi.guiarecolhimento = tdp.guiarecolhimento                     and itbi.subdivida        = tdp.subdivida                     and ttsp.tiposituacaoparcela <> 2)            and exists (select 1                   from tribdebitoparcela tdp                   inner join tribsituacaoparcela tsp on tdp.situacaodebito = tsp.situacaoparcela                   inner join tribtiposituacaoparcela ttsp on tsp.tiposituacaoparcela = ttsp.tiposituacaoparcela                   where itbi.entidade         = tdp.entidade                     and itbi.exercicio        = tdp.exercicio                     and itbi.tipocadastro     = tdp.tipocadastro                     and itbi.cadastrogeral    = tdp.cadastrogeral                     and itbi.guiarecolhimento = tdp.guiarecolhimento                     and itbi.subdivida        = tdp.subdivida                     and ttsp.tiposituacaoparcela = 2))           or           ( itbi.idparcelamento is not null            and not exists (select 1                    from tribparcelamentodebito pd                   inner join tribdebito td on pd.iddebito = td.iddebito                   inner join tribdebitoparcela tdp on td.entidade         = tdp.entidade                                                   and td.exercicio        = tdp.exercicio                                                   and td.tipocadastro     = tdp.tipocadastro                                                   and td.cadastrogeral    = tdp.cadastrogeral                                                   and td.guiarecolhimento = tdp.guiarecolhimento                                                   and td.subdivida        = tdp.subdivida                   inner join tribsituacaoparcela tsp on tdp.situacaodebito = tsp.situacaoparcela                   inner join tribtiposituacaoparcela ttsp on tsp.tiposituacaoparcela = ttsp.tiposituacaoparcela                   where itbi.idparcelamento = pd.idparcelamento                     and ttsp.tiposituacaoparcela <> 2)              and exists (select 1                    from tribparcelamentodebito pd                   inner join tribdebito td on pd.iddebito = td.iddebito                   inner join tribdebitoparcela tdp on td.entidade         = tdp.entidade                                                   and td.exercicio        = tdp.exercicio                                                   and td.tipocadastro     = tdp.tipocadastro                                                   and td.cadastrogeral    = tdp.cadastrogeral                                                   and td.guiarecolhimento = tdp.guiarecolhimento                                                   and td.subdivida        = tdp.subdivida                   inner join tribsituacaoparcela tsp on tdp.situacaodebito = tsp.situacaoparcela                   inner join tribtiposituacaoparcela ttsp on tsp.tiposituacaoparcela = ttsp.tiposituacaoparcela                   where itbi.idparcelamento = pd.idparcelamento                     and ttsp.tiposituacaoparcela = 2))) ", nativeQuery=true)
    public List<Number> findIdItbiPagoById(@Param(value="ids") List<Number> var1);

    @Query(value="select ii from   ImobiliarioItbi ii   where  ii.entidade = :entidade   and    ii.exercicio = :exercicio  and    ii.tipoCadastro = :tipoCadastro   and    ii.cadastroGeral = :cadastroGeral   and    ii.guiaRecolhimento = :divida  and    ii.subDivida = :subDivida  and    ii.transfereAutomatico is true  and    ii.situacao = br.com.elotech.tributos.domain.TipoSituacaoImobiliarioItbi.AGUARDANDO_TRANSFERENCIA ")
    public ImobiliarioItbi findImobiliarioItbiByDebito(@Param(value="entidade") Long var1, @Param(value="exercicio") Long var2, @Param(value="tipoCadastro") TipoCadastro var3, @Param(value="cadastroGeral") Long var4, @Param(value="divida") Long var5, @Param(value="subDivida") Long var6);
}

