/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.tributos.dto.GuiaRecolhimentoFormaPagamentoDTO;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class GuiaRecolhimentoFormaPagamentoRepository {
    private final JdbcTemplate jdbcTemplate;

    public GuiaRecolhimentoFormaPagamentoRepository(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<GuiaRecolhimentoFormaPagamentoDTO> findFormaPagamentoIPTUWeb(Long entidade, Long exercicio, Long guiaRecolhimento, LocalDate dataReferencia) {
        String sql = "select fpag.exercicio,        fpag.entidade,        fpag.guiarecolhimento,        fpag.formapagamento,        fpag.vencimento,        fpag.validade,        fpag.modelobloqueto,        fpag.limiteemissao,        fpag.motivodesconto,        fpag.disponivelweb  from tribguiarecolhimentoformapag fpag inner join tribformapagamento fp on fp.formapagamento = fpag.formapagamento  where fpag.entidade  = ? and   fpag.exercicio = ? and   fpag.guiarecolhimento = ? and   fpag.disponivelweb = 'S' and   fp.tipoformapagamento = 'U' and   fpag.vencimento >= ? order by fpag.vencimento ";
        return this.jdbcTemplate.query(sql, new Object[]{entidade, exercicio, guiaRecolhimento, Date.valueOf(dataReferencia)}, (rs, rowNum) -> {
            GuiaRecolhimentoFormaPagamentoDTO guiaRecolhimentoFormaPagamento = new GuiaRecolhimentoFormaPagamentoDTO();
            guiaRecolhimentoFormaPagamento.setEntidade(Long.valueOf(rs.getLong("entidade")));
            guiaRecolhimentoFormaPagamento.setExercicio(Long.valueOf(rs.getLong("exercicio")));
            guiaRecolhimentoFormaPagamento.setGuiaRecolhimento(Long.valueOf(rs.getLong("guiarecolhimento")));
            guiaRecolhimentoFormaPagamento.setFormaPagamento(Long.valueOf(rs.getLong("formapagamento")));
            guiaRecolhimentoFormaPagamento.setVencimento(rs.getDate("vencimento"));
            guiaRecolhimentoFormaPagamento.setValidade(Integer.valueOf(rs.getInt("validade")));
            guiaRecolhimentoFormaPagamento.setModeloBloqueto(Integer.valueOf(rs.getInt("modelobloqueto")));
            guiaRecolhimentoFormaPagamento.setLimiteEmissao(rs.getDate("limiteemissao"));
            guiaRecolhimentoFormaPagamento.setMotivoDesconto(Integer.valueOf(rs.getInt("motivodesconto")));
            guiaRecolhimentoFormaPagamento.setDisponivelWeb(rs.getString("disponivelweb"));
            return guiaRecolhimentoFormaPagamento;
        });
    }
}

