/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.repository.support.CrudRepository;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.ModeloBoleto;
import br.com.elotech.tributos.repository.BoletoRepositoryCustom;
import java.time.LocalDate;
import java.util.Optional;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface BoletoRepository
extends CrudRepository<Bloqueto, Long>,
BoletoRepositoryCustom {
    public Bloqueto findByEntidadeAndExercicioBloquetoAndBloqueto(@Param(value="entidade") Long var1, @Param(value="exercicioBloqueto") Long var2, @Param(value="bloqueto") Long var3);

    @Query(value="select bloq from Bloqueto bloq where bloq.id.entidade = :entidade and bloq.id.exercicioBloqueto = :exercicioBloqueto and bloq.id.bloqueto = :bloqueto")
    public Bloqueto findByBloqueto(@Param(value="entidade") Long var1, @Param(value="exercicioBloqueto") Long var2, @Param(value="bloqueto") Long var3);

    public Bloqueto findByCodigoValidacao(String var1);

    @Query(value=" select formasPagamento.modeloBoleto  from Divida divida  inner join divida.formasPagamento formasPagamento  where divida.entidade = :entidade  and   divida.exercicio = :exercicio  and   divida.divida = :divida  and   formasPagamento.formaPagamento.id = :formaPagamento ")
    public Optional<ModeloBoleto> findModeloBoleto(@Param(value="entidade") Long var1, @Param(value="exercicio") Long var2, @Param(value="divida") Long var3, @Param(value="formaPagamento") Long var4);

    @Query(value="select count(a.idkey)  from TribBloqueto a where a.dataEmissao = :data", nativeQuery=true)
    public Long getQuantidadeBoletosGerados(@Param(value="data") LocalDate var1);

    public Optional<Bloqueto> findByNossoNumeroAndCadastroGeralExclusaoLogicaFalse(String var1);

    public Optional<Bloqueto> findByBloquetoAndExercicioBloquetoAndCadastroGeralExclusaoLogicaFalse(Long var1, Long var2);

    @Query(value="select bloq from Bloqueto bloq  join bloq.cadastroGeral cg  where (bloq.codigoBarras = :termo or concat(bloq.campo1, bloq.campo2, bloq.campo3, bloq.campo4, coalesce(bloq.campo5,'')) = :termo)  and cg.exclusaoLogica = false ")
    public Optional<Bloqueto> findByCodigoBarrasOuLinhaDigitavel(@Param(value="termo") String var1);
}

