/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.report.loader;

import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.repository.EntidadeRepository;
import br.com.elotech.tributos.service.ContextService;
import org.springframework.stereotype.Component;

@Component
public class HistoricoDebitoParamLoader {
    private static final String PARAM_NOME_ENTIDADE = "PNomeEntidade";
    private static final String PARAM_DESC_UF = "PDescUF";
    private static final String PARAM_EXERCICIO = "PExercicio";
    private static final String PARAM_CONTENCIOSO = "PContencioso";
    private static final String PARAM_DEBITO = "PDebito";
    private static final String PARAM_AUTO_INFRACAO = "PAutoInfracao";
    private static final String PARAM_MATCHER_FORMAT = "%s=%s%n";
    public final EntidadeRepository entidadeRepository;
    public final ContextService contextService;

    public HistoricoDebitoParamLoader(EntidadeRepository entidadeRepository, ContextService contextService) {
        this.entidadeRepository = entidadeRepository;
        this.contextService = contextService;
    }

    public String load() {
        Entidade entidadePrincipal = this.entidadeRepository.findByEntidadeprincipal();
        String unidadeFederacaoDescr = this.entidadeRepository.findDescricaoUfEntidadeprincipal();
        Long exercicio = this.contextService.getExercicioAtual();
        return String.format(PARAM_MATCHER_FORMAT, PARAM_NOME_ENTIDADE, entidadePrincipal.getNome()).concat(String.format("%s=Estado do %s%n", PARAM_DESC_UF, unidadeFederacaoDescr)).concat(String.format(PARAM_MATCHER_FORMAT, PARAM_EXERCICIO, exercicio)).concat(String.format(PARAM_MATCHER_FORMAT, PARAM_CONTENCIOSO, Character.valueOf('S'))).concat(String.format(PARAM_MATCHER_FORMAT, PARAM_DEBITO, Character.valueOf('S'))).concat(String.format(PARAM_MATCHER_FORMAT, PARAM_AUTO_INFRACAO, Character.valueOf('S')));
    }
}

