/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.parcelamento;

import br.com.elotech.tributos.dto.parcelamento.AiseDebitoParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.AiseParcelaReceitaParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelaParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoTributoDTO;
import br.com.elotech.tributos.dto.parcelamento.TributoParcelamentoDTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Collectors;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ParcelamentoHandler {
    private ParcelamentoHandler() {
    }

    public static List<ParcelaParcelamentoDTO> agruparPorParcela(List<AiseDebitoParcelamentoDTO> debitos) {
        ArrayList<ParcelaParcelamentoDTO> list = new ArrayList<ParcelaParcelamentoDTO>();
        Map<Long, List<AiseParcelaReceitaParcelamentoDTO>> listParcelaReceita = debitos.stream().map(AiseDebitoParcelamentoDTO::getParcelaReceita).flatMap(Collection::stream).collect(Collectors.groupingBy(AiseParcelaReceitaParcelamentoDTO::getParcela));
        listParcelaReceita.forEach((parcela, lista) -> {
            ParcelaParcelamentoDTO parcelaParcelamentoDTO = new ParcelaParcelamentoDTO();
            Optional parcelaReceita = lista.stream().findFirst();
            parcelaParcelamentoDTO.setParcela(parcela);
            parcelaParcelamentoDTO.setDataVencimento((LocalDate)parcelaReceita.map(AiseParcelaReceitaParcelamentoDTO::getDataVencimento).orElse(null));
            parcelaParcelamentoDTO.setValor(lista.stream().map(AiseParcelaReceitaParcelamentoDTO::getValor).reduce(BigDecimal.ZERO, BigDecimal::add));
            parcelaParcelamentoDTO.setValorJuros(lista.stream().map(AiseParcelaReceitaParcelamentoDTO::getValorJuros).reduce(BigDecimal.ZERO, BigDecimal::add));
            parcelaParcelamentoDTO.setValorMulta(lista.stream().map(AiseParcelaReceitaParcelamentoDTO::getValorMulta).reduce(BigDecimal.ZERO, BigDecimal::add));
            parcelaParcelamentoDTO.setValorCorrecao(lista.stream().map(AiseParcelaReceitaParcelamentoDTO::getValorCorrecao).reduce(BigDecimal.ZERO, BigDecimal::add));
            parcelaParcelamentoDTO.setValorDesconto(lista.stream().map(AiseParcelaReceitaParcelamentoDTO::getValorDesconto).reduce(BigDecimal.ZERO, BigDecimal::add));
            parcelaParcelamentoDTO.setParcelaReceita(ParcelamentoHandler.somarPorTributo((List)lista));
            list.add(parcelaParcelamentoDTO);
        });
        return list;
    }

    public static List<ParcelaParcelamentoDTO> agruparPorDebitoParcela(List<AiseDebitoParcelamentoDTO> debitos) {
        ArrayList<ParcelaParcelamentoDTO> list = new ArrayList<ParcelaParcelamentoDTO>();
        debitos.stream().forEach(d -> {
            Map<Long, List<AiseParcelaReceitaParcelamentoDTO>> listParcelaReceita = d.getParcelaReceita().stream().collect(Collectors.groupingBy(AiseParcelaReceitaParcelamentoDTO::getParcela));
            listParcelaReceita.forEach((parcela, lista) -> {
                ParcelaParcelamentoDTO parcelaParcelamentoDTO = new ParcelaParcelamentoDTO();
                Optional parcelaReceita = lista.stream().findFirst();
                parcelaParcelamentoDTO.setExercicio(d.getExercicio());
                parcelaParcelamentoDTO.setDivida(d.getGuiaRecolhimento());
                parcelaParcelamentoDTO.setSubDivida(d.getSubDivida());
                parcelaParcelamentoDTO.setParcela(parcela);
                parcelaParcelamentoDTO.setDataVencimento((LocalDate)parcelaReceita.map(AiseParcelaReceitaParcelamentoDTO::getDataVencimento).orElse(null));
                parcelaParcelamentoDTO.setValor(lista.stream().map(AiseParcelaReceitaParcelamentoDTO::getValor).reduce(BigDecimal.ZERO, BigDecimal::add));
                parcelaParcelamentoDTO.setValorJuros(lista.stream().map(AiseParcelaReceitaParcelamentoDTO::getValorJuros).reduce(BigDecimal.ZERO, BigDecimal::add));
                parcelaParcelamentoDTO.setValorMulta(lista.stream().map(AiseParcelaReceitaParcelamentoDTO::getValorMulta).reduce(BigDecimal.ZERO, BigDecimal::add));
                parcelaParcelamentoDTO.setValorCorrecao(lista.stream().map(AiseParcelaReceitaParcelamentoDTO::getValorCorrecao).reduce(BigDecimal.ZERO, BigDecimal::add));
                parcelaParcelamentoDTO.setValorDesconto(lista.stream().map(AiseParcelaReceitaParcelamentoDTO::getValorDesconto).reduce(BigDecimal.ZERO, BigDecimal::add));
                list.add(parcelaParcelamentoDTO);
            });
        });
        return list;
    }

    public static List<TributoParcelamentoDTO> agruparPorDebitoTributo(List<AiseDebitoParcelamentoDTO> debitos) {
        ArrayList<TributoParcelamentoDTO> list = new ArrayList<TributoParcelamentoDTO>();
        debitos.stream().forEach(d -> {
            Map<String, List<AiseParcelaReceitaParcelamentoDTO>> listParcelaTributo = d.getParcelaReceita().stream().collect(Collectors.groupingBy(AiseParcelaReceitaParcelamentoDTO::getReceita));
            listParcelaTributo.forEach((tributo, lista) -> {
                TributoParcelamentoDTO tributoParcelamentoDTO = new TributoParcelamentoDTO();
                tributoParcelamentoDTO.setExercicio(d.getExercicio());
                tributoParcelamentoDTO.setDivida(d.getGuiaRecolhimento());
                tributoParcelamentoDTO.setSubDivida(d.getSubDivida());
                tributoParcelamentoDTO.setTributo(tributo);
                tributoParcelamentoDTO.setTributoDescricao(((AiseParcelaReceitaParcelamentoDTO)lista.stream().findFirst().get()).getReceitaDescricao());
                tributoParcelamentoDTO.setValor(lista.stream().map(AiseParcelaReceitaParcelamentoDTO::getValor).reduce(BigDecimal.ZERO, BigDecimal::add));
                tributoParcelamentoDTO.setValorJuros(lista.stream().map(AiseParcelaReceitaParcelamentoDTO::getValorJuros).reduce(BigDecimal.ZERO, BigDecimal::add));
                tributoParcelamentoDTO.setValorMulta(lista.stream().map(AiseParcelaReceitaParcelamentoDTO::getValorMulta).reduce(BigDecimal.ZERO, BigDecimal::add));
                tributoParcelamentoDTO.setValorCorrecao(lista.stream().map(AiseParcelaReceitaParcelamentoDTO::getValorCorrecao).reduce(BigDecimal.ZERO, BigDecimal::add));
                tributoParcelamentoDTO.setValorDesconto(lista.stream().map(AiseParcelaReceitaParcelamentoDTO::getValorDesconto).reduce(BigDecimal.ZERO, BigDecimal::add));
                list.add(tributoParcelamentoDTO);
            });
        });
        return list;
    }

    private static List<ParcelamentoTributoDTO> somarPorTributo(List<AiseParcelaReceitaParcelamentoDTO> tributosAise) {
        return tributosAise.stream().map(ParcelamentoTributoDTO::from).collect(Collectors.groupingBy(ParcelamentoTributoDTO::getReceita, ParcelamentoHandler.somandoValor())).values().stream().map(Optional::get).collect(Collectors.toList());
    }

    public static List<ParcelamentoTributoDTO> agruparPorTributo(List<AiseDebitoParcelamentoDTO> debitos) {
        return ParcelamentoHandler.somarPorTributo(debitos.stream().map(AiseDebitoParcelamentoDTO::getParcelaReceita).flatMap(Collection::stream).collect(Collectors.toList()));
    }

    private static Collector<ParcelamentoTributoDTO, ?, Optional<ParcelamentoTributoDTO>> somandoValor() {
        return Collectors.reducing((accum, element) -> {
            accum.setValor(accum.getValor().add(element.getValor()));
            accum.setValorCorrecao(accum.getValorCorrecao().add(element.getValorCorrecao()));
            accum.setValorDesconto(accum.getValorDesconto().add(element.getValorDesconto()));
            accum.setValorMulta(accum.getValorMulta().add(element.getValorMulta()));
            accum.setValorJuros(accum.getValorJuros().add(element.getValorJuros()));
            return accum;
        });
    }
}

