/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaocontabil;

import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoTributo;
import br.com.elotech.tributos.dto.integracaocontabil.TipoMovimento;
import br.com.elotech.tributos.util.MultiValueFilter;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class FiltroDiarioArrecadacaoDTO {
    @NotNull
    @Caption(value="Data de Arrecada\u00e7\u00e3o")
    private LocalDate dataArrecadacao;
    private Pessoa pessoa;
    private TipoTributo tipoTributo;
    @Enumerated(value=EnumType.STRING)
    private TipoMovimento tipoMovimento;
    private Long tipoCadastro;
    private String cadastroGeral;
    private String exercicioDebito;
    private String divida;
    private String subdivida;

    private String addAndClause(String clause) {
        return " AND " + clause;
    }

    public String buildWhereClause() {
        StringBuilder where = new StringBuilder();
        if (Objects.nonNull(this.pessoa)) {
            where.append(this.addAndClause(String.format("pessoa.pessoa = %d", this.pessoa.getId())));
        }
        if (Objects.nonNull(this.tipoTributo)) {
            where.append(this.addAndClause(String.format("receita.tiporeceita = %d", this.tipoTributo.getId())));
        }
        if (Objects.nonNull(this.tipoMovimento)) {
            where.append(this.addAndClause(String.format("lotecontabil.tipolote = '%s'", this.tipoMovimento)));
        }
        if (Objects.nonNull(this.tipoCadastro)) {
            where.append(this.addAndClause(String.format("debito.tipocadastro = %d", this.tipoCadastro)));
        }
        if (StringUtils.isNotBlank((CharSequence)this.cadastroGeral)) {
            where.append(this.addAndClause(MultiValueFilter.generateFilters((String)this.cadastroGeral, (String)"debito.cadastrogeral")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.exercicioDebito)) {
            where.append(this.addAndClause(MultiValueFilter.generateFilters((String)this.exercicioDebito, (String)"debito.exercicio")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.divida)) {
            where.append(this.addAndClause(MultiValueFilter.generateFilters((String)this.divida, (String)"debito.guiarecolhimento")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.subdivida)) {
            where.append(this.addAndClause(MultiValueFilter.generateFilters((String)this.subdivida, (String)"debito.subdivida")));
        }
        return where.toString();
    }

    @Generated
    public FiltroDiarioArrecadacaoDTO() {
    }

    @Generated
    public LocalDate getDataArrecadacao() {
        return this.dataArrecadacao;
    }

    @Generated
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    @Generated
    public TipoTributo getTipoTributo() {
        return this.tipoTributo;
    }

    @Generated
    public TipoMovimento getTipoMovimento() {
        return this.tipoMovimento;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public String getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getExercicioDebito() {
        return this.exercicioDebito;
    }

    @Generated
    public String getDivida() {
        return this.divida;
    }

    @Generated
    public String getSubdivida() {
        return this.subdivida;
    }

    @Generated
    public void setDataArrecadacao(LocalDate dataArrecadacao) {
        this.dataArrecadacao = dataArrecadacao;
    }

    @Generated
    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setTipoTributo(TipoTributo tipoTributo) {
        this.tipoTributo = tipoTributo;
    }

    @Generated
    public void setTipoMovimento(TipoMovimento tipoMovimento) {
        this.tipoMovimento = tipoMovimento;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(String cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setExercicioDebito(String exercicioDebito) {
        this.exercicioDebito = exercicioDebito;
    }

    @Generated
    public void setDivida(String divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubdivida(String subdivida) {
        this.subdivida = subdivida;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiltroDiarioArrecadacaoDTO)) {
            return false;
        }
        FiltroDiarioArrecadacaoDTO other = (FiltroDiarioArrecadacaoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        LocalDate this$dataArrecadacao = this.getDataArrecadacao();
        LocalDate other$dataArrecadacao = other.getDataArrecadacao();
        if (this$dataArrecadacao == null ? other$dataArrecadacao != null : !((Object)this$dataArrecadacao).equals(other$dataArrecadacao)) {
            return false;
        }
        Pessoa this$pessoa = this.getPessoa();
        Pessoa other$pessoa = other.getPessoa();
        if (this$pessoa == null ? other$pessoa != null : !this$pessoa.equals(other$pessoa)) {
            return false;
        }
        TipoTributo this$tipoTributo = this.getTipoTributo();
        TipoTributo other$tipoTributo = other.getTipoTributo();
        if (this$tipoTributo == null ? other$tipoTributo != null : !this$tipoTributo.equals(other$tipoTributo)) {
            return false;
        }
        TipoMovimento this$tipoMovimento = this.getTipoMovimento();
        TipoMovimento other$tipoMovimento = other.getTipoMovimento();
        if (this$tipoMovimento == null ? other$tipoMovimento != null : !this$tipoMovimento.equals(other$tipoMovimento)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        String this$cadastroGeral = this.getCadastroGeral();
        String other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !this$cadastroGeral.equals(other$cadastroGeral)) {
            return false;
        }
        String this$exercicioDebito = this.getExercicioDebito();
        String other$exercicioDebito = other.getExercicioDebito();
        if (this$exercicioDebito == null ? other$exercicioDebito != null : !this$exercicioDebito.equals(other$exercicioDebito)) {
            return false;
        }
        String this$divida = this.getDivida();
        String other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !this$divida.equals(other$divida)) {
            return false;
        }
        String this$subdivida = this.getSubdivida();
        String other$subdivida = other.getSubdivida();
        return !(this$subdivida == null ? other$subdivida != null : !this$subdivida.equals(other$subdivida));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FiltroDiarioArrecadacaoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalDate $dataArrecadacao = this.getDataArrecadacao();
        result = result * 59 + ($dataArrecadacao == null ? 43 : ((Object)$dataArrecadacao).hashCode());
        Pessoa $pessoa = this.getPessoa();
        result = result * 59 + ($pessoa == null ? 43 : $pessoa.hashCode());
        TipoTributo $tipoTributo = this.getTipoTributo();
        result = result * 59 + ($tipoTributo == null ? 43 : $tipoTributo.hashCode());
        TipoMovimento $tipoMovimento = this.getTipoMovimento();
        result = result * 59 + ($tipoMovimento == null ? 43 : $tipoMovimento.hashCode());
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        String $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : $cadastroGeral.hashCode());
        String $exercicioDebito = this.getExercicioDebito();
        result = result * 59 + ($exercicioDebito == null ? 43 : $exercicioDebito.hashCode());
        String $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : $divida.hashCode());
        String $subdivida = this.getSubdivida();
        result = result * 59 + ($subdivida == null ? 43 : $subdivida.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FiltroDiarioArrecadacaoDTO(dataArrecadacao=" + this.getDataArrecadacao() + ", pessoa=" + this.getPessoa() + ", tipoTributo=" + this.getTipoTributo() + ", tipoMovimento=" + this.getTipoMovimento() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", exercicioDebito=" + this.getExercicioDebito() + ", divida=" + this.getDivida() + ", subdivida=" + this.getSubdivida() + ")";
    }
}

