/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.ConsultaDebitoTipoAgrupamento;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.SituacaoLegal;
import br.com.elotech.tributos.util.DateUtils;
import br.com.elotech.tributos.util.MultiValueFilter;
import java.time.LocalDate;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class FiltroConsultaDebitoDTO {
    private Pessoa pessoa;
    private TipoCadastro tipoCadastro;
    private String cadastroGeral;
    private String anoDebito;
    private String divida;
    private String subDivida;
    private LocalDate dataLancamento;
    private LocalDate dataVencimento;
    private Boolean noExercicio = Boolean.FALSE;
    private Boolean dividaAtiva = Boolean.FALSE;
    private Boolean juizo = Boolean.FALSE;
    private Long situacaoParcela;
    private Boolean somenteParcelasEmAberto;
    private Boolean calcularAcrescimos = Boolean.FALSE;
    private LocalDate dataReferencia;
    @NotNull
    private ConsultaDebitoTipoAgrupamento tipoAgrupamento;
    private static final String SITUACAO_LEGAL = "TDP.SITUACAOLEGAL = %d";

    private String addAND(String clausula) {
        return " AND " + clausula;
    }

    public String generateWhere() {
        StringBuilder where = new StringBuilder();
        if (Boolean.TRUE.equals(this.calcularAcrescimos) && Objects.isNull(this.dataReferencia)) {
            throw new EloValidationException("A data da refer\u00eancia \u00e9 obrigat\u00f3ria para calcular o acr\u00e9scimo.");
        }
        if (Objects.nonNull(this.pessoa)) {
            where.append(this.addAND(String.format("P.PESSOA = %d", this.pessoa.getId())));
        }
        if (Objects.nonNull(this.tipoCadastro)) {
            where.append(this.addAND(String.format("TD.TIPOCADASTRO = %d", this.tipoCadastro.getValue())));
        }
        if (StringUtils.isNotBlank((CharSequence)this.cadastroGeral)) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.cadastroGeral, (String)"TD.CADASTROGERAL")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.anoDebito)) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.anoDebito, (String)"TD.EXERCICIO")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.divida)) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.divida, (String)"TD.GUIARECOLHIMENTO")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.subDivida)) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.subDivida, (String)"TD.SUBDIVIDA")));
        }
        if (Objects.nonNull(this.dataLancamento)) {
            where.append(this.addAND(String.format("TD.DATALANCAMENTO = '%s'", DateUtils.localDateToString((LocalDate)this.dataLancamento))));
        }
        if (Objects.nonNull(this.dataVencimento)) {
            where.append(this.addAND(String.format("TDP.DATAVENCIMENTO = '%s'", DateUtils.localDateToString((LocalDate)this.dataVencimento))));
        }
        if (Objects.nonNull(this.situacaoParcela)) {
            where.append(this.addAND(String.format("TSP.SITUACAOPARCELA = %d", this.situacaoParcela)));
        }
        if (Boolean.TRUE.equals(this.somenteParcelasEmAberto)) {
            where.append(" AND TTSP.TIPO = 'A' ");
        }
        if (Boolean.TRUE.equals(this.noExercicio) || Boolean.TRUE.equals(this.dividaAtiva) || Boolean.TRUE.equals(this.juizo)) {
            where.append(this.buildFiltroSituacaoLegal());
        }
        return where.toString();
    }

    private String buildFiltroSituacaoLegal() {
        StringBuilder situacaoLegal = new StringBuilder();
        situacaoLegal.append("AND TDP.SITUACAOLEGAL IN (");
        if (Boolean.TRUE.equals(this.noExercicio)) {
            situacaoLegal.append(SituacaoLegal.NO_EXERCICIO.getValue().toString()).append(", ");
        }
        if (Boolean.TRUE.equals(this.dividaAtiva)) {
            situacaoLegal.append(SituacaoLegal.DIVIDA_ATIVA.getValue().toString()).append(", ");
        }
        if (Boolean.TRUE.equals(this.juizo)) {
            situacaoLegal.append(SituacaoLegal.JUIZO.getValue().toString());
        }
        if (situacaoLegal.toString().endsWith(", ")) {
            situacaoLegal.append(")");
            return situacaoLegal.toString().replace(", )", ")");
        }
        situacaoLegal.append(")");
        return situacaoLegal.toString();
    }

    @Generated
    public FiltroConsultaDebitoDTO() {
    }

    @Generated
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    @Generated
    public TipoCadastro getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public String getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getAnoDebito() {
        return this.anoDebito;
    }

    @Generated
    public String getDivida() {
        return this.divida;
    }

    @Generated
    public String getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public LocalDate getDataLancamento() {
        return this.dataLancamento;
    }

    @Generated
    public LocalDate getDataVencimento() {
        return this.dataVencimento;
    }

    @Generated
    public Boolean getNoExercicio() {
        return this.noExercicio;
    }

    @Generated
    public Boolean getDividaAtiva() {
        return this.dividaAtiva;
    }

    @Generated
    public Boolean getJuizo() {
        return this.juizo;
    }

    @Generated
    public Long getSituacaoParcela() {
        return this.situacaoParcela;
    }

    @Generated
    public Boolean getSomenteParcelasEmAberto() {
        return this.somenteParcelasEmAberto;
    }

    @Generated
    public Boolean getCalcularAcrescimos() {
        return this.calcularAcrescimos;
    }

    @Generated
    public LocalDate getDataReferencia() {
        return this.dataReferencia;
    }

    @Generated
    public ConsultaDebitoTipoAgrupamento getTipoAgrupamento() {
        return this.tipoAgrupamento;
    }

    @Generated
    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setTipoCadastro(TipoCadastro tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(String cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setAnoDebito(String anoDebito) {
        this.anoDebito = anoDebito;
    }

    @Generated
    public void setDivida(String divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(String subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setDataLancamento(LocalDate dataLancamento) {
        this.dataLancamento = dataLancamento;
    }

    @Generated
    public void setDataVencimento(LocalDate dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Generated
    public void setNoExercicio(Boolean noExercicio) {
        this.noExercicio = noExercicio;
    }

    @Generated
    public void setDividaAtiva(Boolean dividaAtiva) {
        this.dividaAtiva = dividaAtiva;
    }

    @Generated
    public void setJuizo(Boolean juizo) {
        this.juizo = juizo;
    }

    @Generated
    public void setSituacaoParcela(Long situacaoParcela) {
        this.situacaoParcela = situacaoParcela;
    }

    @Generated
    public void setSomenteParcelasEmAberto(Boolean somenteParcelasEmAberto) {
        this.somenteParcelasEmAberto = somenteParcelasEmAberto;
    }

    @Generated
    public void setCalcularAcrescimos(Boolean calcularAcrescimos) {
        this.calcularAcrescimos = calcularAcrescimos;
    }

    @Generated
    public void setDataReferencia(LocalDate dataReferencia) {
        this.dataReferencia = dataReferencia;
    }

    @Generated
    public void setTipoAgrupamento(ConsultaDebitoTipoAgrupamento tipoAgrupamento) {
        this.tipoAgrupamento = tipoAgrupamento;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiltroConsultaDebitoDTO)) {
            return false;
        }
        FiltroConsultaDebitoDTO other = (FiltroConsultaDebitoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Pessoa this$pessoa = this.getPessoa();
        Pessoa other$pessoa = other.getPessoa();
        if (this$pessoa == null ? other$pessoa != null : !this$pessoa.equals(other$pessoa)) {
            return false;
        }
        TipoCadastro this$tipoCadastro = this.getTipoCadastro();
        TipoCadastro other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !this$tipoCadastro.equals(other$tipoCadastro)) {
            return false;
        }
        String this$cadastroGeral = this.getCadastroGeral();
        String other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !this$cadastroGeral.equals(other$cadastroGeral)) {
            return false;
        }
        String this$anoDebito = this.getAnoDebito();
        String other$anoDebito = other.getAnoDebito();
        if (this$anoDebito == null ? other$anoDebito != null : !this$anoDebito.equals(other$anoDebito)) {
            return false;
        }
        String this$divida = this.getDivida();
        String other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !this$divida.equals(other$divida)) {
            return false;
        }
        String this$subDivida = this.getSubDivida();
        String other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !this$subDivida.equals(other$subDivida)) {
            return false;
        }
        LocalDate this$dataLancamento = this.getDataLancamento();
        LocalDate other$dataLancamento = other.getDataLancamento();
        if (this$dataLancamento == null ? other$dataLancamento != null : !((Object)this$dataLancamento).equals(other$dataLancamento)) {
            return false;
        }
        LocalDate this$dataVencimento = this.getDataVencimento();
        LocalDate other$dataVencimento = other.getDataVencimento();
        if (this$dataVencimento == null ? other$dataVencimento != null : !((Object)this$dataVencimento).equals(other$dataVencimento)) {
            return false;
        }
        Boolean this$noExercicio = this.getNoExercicio();
        Boolean other$noExercicio = other.getNoExercicio();
        if (this$noExercicio == null ? other$noExercicio != null : !((Object)this$noExercicio).equals(other$noExercicio)) {
            return false;
        }
        Boolean this$dividaAtiva = this.getDividaAtiva();
        Boolean other$dividaAtiva = other.getDividaAtiva();
        if (this$dividaAtiva == null ? other$dividaAtiva != null : !((Object)this$dividaAtiva).equals(other$dividaAtiva)) {
            return false;
        }
        Boolean this$juizo = this.getJuizo();
        Boolean other$juizo = other.getJuizo();
        if (this$juizo == null ? other$juizo != null : !((Object)this$juizo).equals(other$juizo)) {
            return false;
        }
        Long this$situacaoParcela = this.getSituacaoParcela();
        Long other$situacaoParcela = other.getSituacaoParcela();
        if (this$situacaoParcela == null ? other$situacaoParcela != null : !((Object)this$situacaoParcela).equals(other$situacaoParcela)) {
            return false;
        }
        Boolean this$somenteParcelasEmAberto = this.getSomenteParcelasEmAberto();
        Boolean other$somenteParcelasEmAberto = other.getSomenteParcelasEmAberto();
        if (this$somenteParcelasEmAberto == null ? other$somenteParcelasEmAberto != null : !((Object)this$somenteParcelasEmAberto).equals(other$somenteParcelasEmAberto)) {
            return false;
        }
        Boolean this$calcularAcrescimos = this.getCalcularAcrescimos();
        Boolean other$calcularAcrescimos = other.getCalcularAcrescimos();
        if (this$calcularAcrescimos == null ? other$calcularAcrescimos != null : !((Object)this$calcularAcrescimos).equals(other$calcularAcrescimos)) {
            return false;
        }
        LocalDate this$dataReferencia = this.getDataReferencia();
        LocalDate other$dataReferencia = other.getDataReferencia();
        if (this$dataReferencia == null ? other$dataReferencia != null : !((Object)this$dataReferencia).equals(other$dataReferencia)) {
            return false;
        }
        ConsultaDebitoTipoAgrupamento this$tipoAgrupamento = this.getTipoAgrupamento();
        ConsultaDebitoTipoAgrupamento other$tipoAgrupamento = other.getTipoAgrupamento();
        return !(this$tipoAgrupamento == null ? other$tipoAgrupamento != null : !this$tipoAgrupamento.equals(other$tipoAgrupamento));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FiltroConsultaDebitoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Pessoa $pessoa = this.getPessoa();
        result = result * 59 + ($pessoa == null ? 43 : $pessoa.hashCode());
        TipoCadastro $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : $tipoCadastro.hashCode());
        String $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : $cadastroGeral.hashCode());
        String $anoDebito = this.getAnoDebito();
        result = result * 59 + ($anoDebito == null ? 43 : $anoDebito.hashCode());
        String $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : $divida.hashCode());
        String $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : $subDivida.hashCode());
        LocalDate $dataLancamento = this.getDataLancamento();
        result = result * 59 + ($dataLancamento == null ? 43 : ((Object)$dataLancamento).hashCode());
        LocalDate $dataVencimento = this.getDataVencimento();
        result = result * 59 + ($dataVencimento == null ? 43 : ((Object)$dataVencimento).hashCode());
        Boolean $noExercicio = this.getNoExercicio();
        result = result * 59 + ($noExercicio == null ? 43 : ((Object)$noExercicio).hashCode());
        Boolean $dividaAtiva = this.getDividaAtiva();
        result = result * 59 + ($dividaAtiva == null ? 43 : ((Object)$dividaAtiva).hashCode());
        Boolean $juizo = this.getJuizo();
        result = result * 59 + ($juizo == null ? 43 : ((Object)$juizo).hashCode());
        Long $situacaoParcela = this.getSituacaoParcela();
        result = result * 59 + ($situacaoParcela == null ? 43 : ((Object)$situacaoParcela).hashCode());
        Boolean $somenteParcelasEmAberto = this.getSomenteParcelasEmAberto();
        result = result * 59 + ($somenteParcelasEmAberto == null ? 43 : ((Object)$somenteParcelasEmAberto).hashCode());
        Boolean $calcularAcrescimos = this.getCalcularAcrescimos();
        result = result * 59 + ($calcularAcrescimos == null ? 43 : ((Object)$calcularAcrescimos).hashCode());
        LocalDate $dataReferencia = this.getDataReferencia();
        result = result * 59 + ($dataReferencia == null ? 43 : ((Object)$dataReferencia).hashCode());
        ConsultaDebitoTipoAgrupamento $tipoAgrupamento = this.getTipoAgrupamento();
        result = result * 59 + ($tipoAgrupamento == null ? 43 : $tipoAgrupamento.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FiltroConsultaDebitoDTO(pessoa=" + this.getPessoa() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", anoDebito=" + this.getAnoDebito() + ", divida=" + this.getDivida() + ", subDivida=" + this.getSubDivida() + ", dataLancamento=" + this.getDataLancamento() + ", dataVencimento=" + this.getDataVencimento() + ", noExercicio=" + this.getNoExercicio() + ", dividaAtiva=" + this.getDividaAtiva() + ", juizo=" + this.getJuizo() + ", situacaoParcela=" + this.getSituacaoParcela() + ", somenteParcelasEmAberto=" + this.getSomenteParcelasEmAberto() + ", calcularAcrescimos=" + this.getCalcularAcrescimos() + ", dataReferencia=" + this.getDataReferencia() + ", tipoAgrupamento=" + this.getTipoAgrupamento() + ")";
    }
}

