/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.rural;

import br.com.elotech.audit.reader.DiffRevisionIgnoreProperties;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Distrito;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.Setor;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Optional;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.Facet;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;

@Indexed
@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="tribcadastrorural")
@PrimaryKeyJoinColumn(name="tribcadastrogeral_idkey")
public class CadastroRural
extends CadastroGeral {
    @Caption(value="N\u00famero Im\u00f3vel Receita")
    private Long numeroImovelReceita;
    @Caption(value="C\u00f3digo Incra")
    private String codigoIncra;
    @Caption(value="Nome")
    @Column(name="nome")
    @Field(analyzer=@Analyzer(definition="dividePalavrasNoEspacoEmBranco"))
    private String nomePropriedade;
    @Caption(value="\u00c1rea Total")
    private BigDecimal areaTotal = BigDecimal.ZERO;
    @Caption(value="\u00c1rea Total Constru\u00edda")
    private BigDecimal areaTotalConstruida = BigDecimal.ZERO;
    @Caption(value="\u00c1rea Arrendada")
    private BigDecimal areaArrendada = BigDecimal.ZERO;
    @Caption(value="\u00c1rea Cultivo")
    private BigDecimal areaCultivo = BigDecimal.ZERO;
    @Caption(value="\u00c1rea Pasto")
    private BigDecimal areaPasto = BigDecimal.ZERO;
    @Caption(value="Valor Terreno")
    private BigDecimal valorTerreno = BigDecimal.ZERO;
    @Caption(value="Quantidade Alqueires")
    @Column(name="qtdeAlqueires")
    private BigDecimal quantidadeAlqueires = BigDecimal.ZERO;
    @Caption(value="Lote")
    @Field(analyzer=@Analyzer(definition="consideraSomenteAlfaNumericos"))
    private String lote;
    @Caption(value="Matr\u00edcula")
    private String matricula;
    @Caption(value="Of\u00edcio")
    private Long oficio;
    @Caption(value="Origem Inscri\u00e7\u00e3o")
    private Long origemInscricao;
    @Caption(value="Condi\u00e7\u00e3o Pessoa Im\u00f3vel")
    private Long condicaoPessoaImovel;
    @Caption(value="Reside Im\u00f3vel")
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean resideImovel;
    @Caption(value="Data Aquisi\u00e7\u00e3o")
    private LocalDate dataAquisicao;
    @Caption(value="Data")
    private LocalDate data;
    @Caption(value="Endere\u00e7o")
    @Field(analyzer=@Analyzer(definition="dividePalavrasNoEspacoEmBrancoEPontuacao"))
    private String endereco;
    @Caption(value="Quantidade Hectares")
    @Column(name="qtdeHectares")
    private BigDecimal quantidadeHectares = BigDecimal.ZERO;
    @Caption(value="Distrito")
    @IndexedEmbedded
    @ManyToOne
    @JoinColumn(name="distrito")
    @JsonIgnoreProperties(value={"setores"})
    @DiffRevisionIgnoreProperties(value={"setores", "id"})
    private Distrito distrito;
    @Caption(value="Setor")
    @IndexedEmbedded
    @ManyToOne
    @JoinColumn(name="tribsetor_idkey")
    @JsonIgnoreProperties(value={"quadras"})
    @DiffRevisionIgnoreProperties(value={"id", "distrito"})
    private Setor setor;

    @JsonIgnore
    @Fields(value={@Field(analyzer=@Analyzer(definition="dividePalavrasNoEspacoEmBrancoEPontuacao")), @Field(name="logradouroDescricaoFacet", analyze=Analyze.NO)})
    @Facet(name="logradouroDescricaoFacet", forField="logradouroDescricaoFacet")
    public String getLogradouroDescricao() {
        return Optional.ofNullable(this.getLogradouro()).map(Logradouro::getDescricao).orElse("");
    }

    @JsonIgnore
    @Fields(value={@Field(analyzer=@Analyzer(definition="dividePalavrasNoEspacoEmBrancoEPontuacao")), @Field(name="bairroDescricaoFacet", analyze=Analyze.NO)})
    @Facet(name="bairroDescricaoFacet", forField="bairroDescricaoFacet")
    public String getBairroDescricao() {
        return Optional.ofNullable(this.getBairro()).map(Bairro::getDescricao).orElse("");
    }

    @Generated
    public CadastroRural() {
    }

    @Generated
    public Long getNumeroImovelReceita() {
        return this.numeroImovelReceita;
    }

    @Generated
    public String getCodigoIncra() {
        return this.codigoIncra;
    }

    @Generated
    public String getNomePropriedade() {
        return this.nomePropriedade;
    }

    @Generated
    public BigDecimal getAreaTotal() {
        return this.areaTotal;
    }

    @Generated
    public BigDecimal getAreaTotalConstruida() {
        return this.areaTotalConstruida;
    }

    @Generated
    public BigDecimal getAreaArrendada() {
        return this.areaArrendada;
    }

    @Generated
    public BigDecimal getAreaCultivo() {
        return this.areaCultivo;
    }

    @Generated
    public BigDecimal getAreaPasto() {
        return this.areaPasto;
    }

    @Generated
    public BigDecimal getValorTerreno() {
        return this.valorTerreno;
    }

    @Generated
    public BigDecimal getQuantidadeAlqueires() {
        return this.quantidadeAlqueires;
    }

    @Generated
    public String getLote() {
        return this.lote;
    }

    @Generated
    public String getMatricula() {
        return this.matricula;
    }

    @Generated
    public Long getOficio() {
        return this.oficio;
    }

    @Generated
    public Long getOrigemInscricao() {
        return this.origemInscricao;
    }

    @Generated
    public Long getCondicaoPessoaImovel() {
        return this.condicaoPessoaImovel;
    }

    @Generated
    public Boolean getResideImovel() {
        return this.resideImovel;
    }

    @Generated
    public LocalDate getDataAquisicao() {
        return this.dataAquisicao;
    }

    @Generated
    public LocalDate getData() {
        return this.data;
    }

    @Generated
    public String getEndereco() {
        return this.endereco;
    }

    @Generated
    public BigDecimal getQuantidadeHectares() {
        return this.quantidadeHectares;
    }

    @Generated
    public Distrito getDistrito() {
        return this.distrito;
    }

    @Generated
    public Setor getSetor() {
        return this.setor;
    }

    @Generated
    public void setNumeroImovelReceita(Long numeroImovelReceita) {
        this.numeroImovelReceita = numeroImovelReceita;
    }

    @Generated
    public void setCodigoIncra(String codigoIncra) {
        this.codigoIncra = codigoIncra;
    }

    @Generated
    public void setNomePropriedade(String nomePropriedade) {
        this.nomePropriedade = nomePropriedade;
    }

    @Generated
    public void setAreaTotal(BigDecimal areaTotal) {
        this.areaTotal = areaTotal;
    }

    @Generated
    public void setAreaTotalConstruida(BigDecimal areaTotalConstruida) {
        this.areaTotalConstruida = areaTotalConstruida;
    }

    @Generated
    public void setAreaArrendada(BigDecimal areaArrendada) {
        this.areaArrendada = areaArrendada;
    }

    @Generated
    public void setAreaCultivo(BigDecimal areaCultivo) {
        this.areaCultivo = areaCultivo;
    }

    @Generated
    public void setAreaPasto(BigDecimal areaPasto) {
        this.areaPasto = areaPasto;
    }

    @Generated
    public void setValorTerreno(BigDecimal valorTerreno) {
        this.valorTerreno = valorTerreno;
    }

    @Generated
    public void setQuantidadeAlqueires(BigDecimal quantidadeAlqueires) {
        this.quantidadeAlqueires = quantidadeAlqueires;
    }

    @Generated
    public void setLote(String lote) {
        this.lote = lote;
    }

    @Generated
    public void setMatricula(String matricula) {
        this.matricula = matricula;
    }

    @Generated
    public void setOficio(Long oficio) {
        this.oficio = oficio;
    }

    @Generated
    public void setOrigemInscricao(Long origemInscricao) {
        this.origemInscricao = origemInscricao;
    }

    @Generated
    public void setCondicaoPessoaImovel(Long condicaoPessoaImovel) {
        this.condicaoPessoaImovel = condicaoPessoaImovel;
    }

    @Generated
    public void setResideImovel(Boolean resideImovel) {
        this.resideImovel = resideImovel;
    }

    @Generated
    public void setDataAquisicao(LocalDate dataAquisicao) {
        this.dataAquisicao = dataAquisicao;
    }

    @Generated
    public void setData(LocalDate data) {
        this.data = data;
    }

    @Generated
    public void setEndereco(String endereco) {
        this.endereco = endereco;
    }

    @Generated
    public void setQuantidadeHectares(BigDecimal quantidadeHectares) {
        this.quantidadeHectares = quantidadeHectares;
    }

    @Generated
    public void setDistrito(Distrito distrito) {
        this.distrito = distrito;
    }

    @Generated
    public void setSetor(Setor setor) {
        this.setor = setor;
    }

    @Generated
    public String toString() {
        return "CadastroRural(super=" + super.toString() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroRural)) {
            return false;
        }
        CadastroRural other = (CadastroRural)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroRural;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

