/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.enumerable.EnumConverter;
import br.com.elotech.core.enumerable.EnumValues;
import br.com.elotech.core.utils.EnumUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum TipoCondominio implements EnumConverter<TipoCondominio, String>
{
    HORIZONTAL("H", "Horizontal"),
    VERTICAL("V", "Vertical"),
    OUTROS("O", "Outros");

    private final String codigo;
    private final String descricao;
    public static final EnumValues<TipoCondominio, String> ENUM_VALUES;

    private TipoCondominio(String codigo, String descricao) {
        this.codigo = codigo;
        this.descricao = descricao;
    }

    @JsonCreator
    public static TipoCondominio fromValue(String codigo) {
        return (TipoCondominio)ENUM_VALUES.getEnum((Object)codigo);
    }

    @JsonValue
    public String getValue() {
        return this.codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public Boolean isHorizontal() {
        return this.codigo.equals(TipoCondominio.HORIZONTAL.codigo);
    }

    public Boolean isVertical() {
        return this.codigo.equals(TipoCondominio.VERTICAL.codigo);
    }

    public Boolean isOutros() {
        return this.codigo.equals(TipoCondominio.OUTROS.codigo);
    }

    public Boolean isVerticalOrHorizontal() {
        return this.isVertical() != false || this.isHorizontal() != false;
    }

    static {
        ENUM_VALUES = EnumUtils.getEnumValuesMap(TipoCondominio.class);
    }
}

