/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.ContaBancaria;
import br.com.elotech.tributos.domain.ModeloArquivo;
import br.com.elotech.tributos.domain.TipoCodigoBarras;
import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="TRIBCONVENIO")
public class Convenio
implements EloEntity<Long>,
Serializable {
    @Id
    @EloSequence(sequenceName="SEQ_CONVENIO")
    private Long id;
    @NotNull(message="Entidade \u00e9 obrigat\u00f3ria")
    private @NotNull(message="Entidade \u00e9 obrigat\u00f3ria") Long entidade;
    @EloSequence(sequenceName="S05CONVENIO_#{entidade}")
    private Long convenio;
    @NotNull(message="Tipo de codigo de barras \u00e9 obrigat\u00f3rio")
    private @NotNull(message="Tipo de codigo de barras \u00e9 obrigat\u00f3rio") TipoCodigoBarras tipoCodigoBarras;
    @Length(max=50)
    @NotNull(message="Descri\u00e7\u00e3o \u00e9 obrigat\u00f3ria")
    private @Length(max=50) @NotNull(message="Descri\u00e7\u00e3o \u00e9 obrigat\u00f3ria") String descricao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(column=@JoinColumn(name="contabancaria", referencedColumnName="contabancaria"))})
    @NotNull(message="Conta banc\u00e1ria \u00e9 obrigat\u00f3ria")
    private @NotNull(message="Conta banc\u00e1ria \u00e9 obrigat\u00f3ria") ContaBancaria contaBancaria;
    private Long diaRepasse;
    @Length(max=10)
    private @Length(max=10) String carteira;
    @Length(max=20)
    private @Length(max=20) String numeroConvenio;
    @Length(max=20)
    private @Length(max=20) String codigoCedente;
    private Long sequenciaArquivoEnvio;
    private Long sequenciaArquivoRetorno;
    @Length(max=2)
    private @Length(max=2) String modulo = ModuloEnum.MODULO_TRIBUTARIO.getValue();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="modulo", referencedColumnName="modulo")), @JoinColumnOrFormula(column=@JoinColumn(name="modeloarquivoenvio", referencedColumnName="modeloarquivo"))})
    private ModeloArquivo modeloArquivoEnvio;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="modulo", referencedColumnName="modulo")), @JoinColumnOrFormula(column=@JoinColumn(name="modeloarquivoretorno", referencedColumnName="modeloarquivo"))})
    private ModeloArquivo modeloArquivoRetorno;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="banco")
    @NotNull(message="Banco \u00e9 obrigat\u00f3rio")
    private @NotNull(message="Banco \u00e9 obrigat\u00f3rio") Banco banco;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean debitoAutomatico;
    @Length(max=150)
    private @Length(max=150) String nomeArquivo;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean loteManual;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean validaBloquetoLoteManual;
    @NotNull(message="Diferen\u00e7a m\u00e1xima (valor) \u00e9 obrigat\u00f3rio")
    private @NotNull(message="Diferen\u00e7a m\u00e1xima (valor) \u00e9 obrigat\u00f3rio") BigDecimal maximaDiferencaValor;
    @NotNull(message="Diferen\u00e7a m\u00e1xima (percentual) \u00e9 obrigat\u00f3rio")
    private @NotNull(message="Diferen\u00e7a m\u00e1xima (percentual) \u00e9 obrigat\u00f3rio") BigDecimal maximaDiferencaPercentual;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean buscaCodigoBarrasExterno;
    @Length(max=2)
    private @Length(max=2) String codigoPosto;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean geraArquivoRetorno;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean registraBoletoOnline;
    @NotNull(message="Desconto m\u00e1ximo permitido \u00e9 obrigat\u00f3rio")
    private @NotNull(message="Desconto m\u00e1ximo permitido \u00e9 obrigat\u00f3rio") BigDecimal descontoMaximoPermitido;

    @Generated
    public Convenio() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getConvenio() {
        return this.convenio;
    }

    @Generated
    public TipoCodigoBarras getTipoCodigoBarras() {
        return this.tipoCodigoBarras;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public ContaBancaria getContaBancaria() {
        return this.contaBancaria;
    }

    @Generated
    public Long getDiaRepasse() {
        return this.diaRepasse;
    }

    @Generated
    public String getCarteira() {
        return this.carteira;
    }

    @Generated
    public String getNumeroConvenio() {
        return this.numeroConvenio;
    }

    @Generated
    public String getCodigoCedente() {
        return this.codigoCedente;
    }

    @Generated
    public Long getSequenciaArquivoEnvio() {
        return this.sequenciaArquivoEnvio;
    }

    @Generated
    public Long getSequenciaArquivoRetorno() {
        return this.sequenciaArquivoRetorno;
    }

    @Generated
    public String getModulo() {
        return this.modulo;
    }

    @Generated
    public ModeloArquivo getModeloArquivoEnvio() {
        return this.modeloArquivoEnvio;
    }

    @Generated
    public ModeloArquivo getModeloArquivoRetorno() {
        return this.modeloArquivoRetorno;
    }

    @Generated
    public Banco getBanco() {
        return this.banco;
    }

    @Generated
    public Boolean getDebitoAutomatico() {
        return this.debitoAutomatico;
    }

    @Generated
    public String getNomeArquivo() {
        return this.nomeArquivo;
    }

    @Generated
    public Boolean getLoteManual() {
        return this.loteManual;
    }

    @Generated
    public Boolean getValidaBloquetoLoteManual() {
        return this.validaBloquetoLoteManual;
    }

    @Generated
    public BigDecimal getMaximaDiferencaValor() {
        return this.maximaDiferencaValor;
    }

    @Generated
    public BigDecimal getMaximaDiferencaPercentual() {
        return this.maximaDiferencaPercentual;
    }

    @Generated
    public Boolean getBuscaCodigoBarrasExterno() {
        return this.buscaCodigoBarrasExterno;
    }

    @Generated
    public String getCodigoPosto() {
        return this.codigoPosto;
    }

    @Generated
    public Boolean getGeraArquivoRetorno() {
        return this.geraArquivoRetorno;
    }

    @Generated
    public Boolean getRegistraBoletoOnline() {
        return this.registraBoletoOnline;
    }

    @Generated
    public BigDecimal getDescontoMaximoPermitido() {
        return this.descontoMaximoPermitido;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setConvenio(Long convenio) {
        this.convenio = convenio;
    }

    @Generated
    public void setTipoCodigoBarras(TipoCodigoBarras tipoCodigoBarras) {
        this.tipoCodigoBarras = tipoCodigoBarras;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setContaBancaria(ContaBancaria contaBancaria) {
        this.contaBancaria = contaBancaria;
    }

    @Generated
    public void setDiaRepasse(Long diaRepasse) {
        this.diaRepasse = diaRepasse;
    }

    @Generated
    public void setCarteira(String carteira) {
        this.carteira = carteira;
    }

    @Generated
    public void setNumeroConvenio(String numeroConvenio) {
        this.numeroConvenio = numeroConvenio;
    }

    @Generated
    public void setCodigoCedente(String codigoCedente) {
        this.codigoCedente = codigoCedente;
    }

    @Generated
    public void setSequenciaArquivoEnvio(Long sequenciaArquivoEnvio) {
        this.sequenciaArquivoEnvio = sequenciaArquivoEnvio;
    }

    @Generated
    public void setSequenciaArquivoRetorno(Long sequenciaArquivoRetorno) {
        this.sequenciaArquivoRetorno = sequenciaArquivoRetorno;
    }

    @Generated
    public void setModulo(String modulo) {
        this.modulo = modulo;
    }

    @Generated
    public void setModeloArquivoEnvio(ModeloArquivo modeloArquivoEnvio) {
        this.modeloArquivoEnvio = modeloArquivoEnvio;
    }

    @Generated
    public void setModeloArquivoRetorno(ModeloArquivo modeloArquivoRetorno) {
        this.modeloArquivoRetorno = modeloArquivoRetorno;
    }

    @Generated
    public void setBanco(Banco banco) {
        this.banco = banco;
    }

    @Generated
    public void setDebitoAutomatico(Boolean debitoAutomatico) {
        this.debitoAutomatico = debitoAutomatico;
    }

    @Generated
    public void setNomeArquivo(String nomeArquivo) {
        this.nomeArquivo = nomeArquivo;
    }

    @Generated
    public void setLoteManual(Boolean loteManual) {
        this.loteManual = loteManual;
    }

    @Generated
    public void setValidaBloquetoLoteManual(Boolean validaBloquetoLoteManual) {
        this.validaBloquetoLoteManual = validaBloquetoLoteManual;
    }

    @Generated
    public void setMaximaDiferencaValor(BigDecimal maximaDiferencaValor) {
        this.maximaDiferencaValor = maximaDiferencaValor;
    }

    @Generated
    public void setMaximaDiferencaPercentual(BigDecimal maximaDiferencaPercentual) {
        this.maximaDiferencaPercentual = maximaDiferencaPercentual;
    }

    @Generated
    public void setBuscaCodigoBarrasExterno(Boolean buscaCodigoBarrasExterno) {
        this.buscaCodigoBarrasExterno = buscaCodigoBarrasExterno;
    }

    @Generated
    public void setCodigoPosto(String codigoPosto) {
        this.codigoPosto = codigoPosto;
    }

    @Generated
    public void setGeraArquivoRetorno(Boolean geraArquivoRetorno) {
        this.geraArquivoRetorno = geraArquivoRetorno;
    }

    @Generated
    public void setRegistraBoletoOnline(Boolean registraBoletoOnline) {
        this.registraBoletoOnline = registraBoletoOnline;
    }

    @Generated
    public void setDescontoMaximoPermitido(BigDecimal descontoMaximoPermitido) {
        this.descontoMaximoPermitido = descontoMaximoPermitido;
    }

    @Generated
    public String toString() {
        return "Convenio(id=" + this.getId() + ", entidade=" + this.getEntidade() + ", convenio=" + this.getConvenio() + ", tipoCodigoBarras=" + this.getTipoCodigoBarras() + ", descricao=" + this.getDescricao() + ", contaBancaria=" + this.getContaBancaria() + ", diaRepasse=" + this.getDiaRepasse() + ", carteira=" + this.getCarteira() + ", numeroConvenio=" + this.getNumeroConvenio() + ", codigoCedente=" + this.getCodigoCedente() + ", sequenciaArquivoEnvio=" + this.getSequenciaArquivoEnvio() + ", sequenciaArquivoRetorno=" + this.getSequenciaArquivoRetorno() + ", modulo=" + this.getModulo() + ", modeloArquivoEnvio=" + this.getModeloArquivoEnvio() + ", modeloArquivoRetorno=" + this.getModeloArquivoRetorno() + ", banco=" + this.getBanco() + ", debitoAutomatico=" + this.getDebitoAutomatico() + ", nomeArquivo=" + this.getNomeArquivo() + ", loteManual=" + this.getLoteManual() + ", validaBloquetoLoteManual=" + this.getValidaBloquetoLoteManual() + ", maximaDiferencaValor=" + this.getMaximaDiferencaValor() + ", maximaDiferencaPercentual=" + this.getMaximaDiferencaPercentual() + ", buscaCodigoBarrasExterno=" + this.getBuscaCodigoBarrasExterno() + ", codigoPosto=" + this.getCodigoPosto() + ", geraArquivoRetorno=" + this.getGeraArquivoRetorno() + ", registraBoletoOnline=" + this.getRegistraBoletoOnline() + ", descontoMaximoPermitido=" + this.getDescontoMaximoPermitido() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Convenio)) {
            return false;
        }
        Convenio other = (Convenio)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Convenio;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

