/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.service;

import br.com.elotech.arquivos.client.ArquivoClient;
import br.com.elotech.arquivos.domain.Arquivo;
import br.com.elotech.arquivos.domain.request.ArquivoDownloadRequest;
import br.com.elotech.arquivos.domain.request.ArquivoNovoRequest;
import br.com.elotech.arquivos.domain.support.ContentType;
import br.com.elotech.arquivos.domain.support.Tenant;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.common.dto.EntidadeInfo;
import br.com.elotech.core.common.service.EntidadeService;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.ReadOnlyService;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.tributos.calculo.domain.Calculo;
import br.com.elotech.tributos.calculo.domain.CalculoGeracaoLote;
import br.com.elotech.tributos.calculo.domain.CalculoLoteImpressao;
import br.com.elotech.tributos.calculo.domain.SituacaoCalculo;
import br.com.elotech.tributos.calculo.dto.ArquivoGraficaBoletoDTO;
import br.com.elotech.tributos.calculo.dto.ArquivoGraficaDTO;
import br.com.elotech.tributos.calculo.dto.CalculoLoteImpressaoDTO;
import br.com.elotech.tributos.calculo.dto.LoteItemDTO;
import br.com.elotech.tributos.calculo.repository.ArquivoGraficaRepository;
import br.com.elotech.tributos.calculo.repository.CalculoLoteImpressaoRepository;
import br.com.elotech.tributos.calculo.service.ArquivoGrafica;
import br.com.elotech.tributos.calculo.service.CalculoLoteImpressaoItemService;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.inscricaocadastral.ConfiguracaoInscricaoCadastral;
import br.com.elotech.tributos.service.ConfiguracaoInscricaoCadastralService;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class CalculoLoteImpressaoService
extends ReadOnlyService<CalculoLoteImpressao, Long> {
    private final CalculoLoteImpressaoItemService calculoLoteImpressaoItemService;
    private final CalculoLoteImpressaoRepository calculoLoteImpressaoRepository;
    private final ArquivoClient arquivoClient;
    private final EntidadeService entidadeService;
    private final ArquivoGraficaRepository arquivoGraficaRepository;
    private final ConfiguracaoInscricaoCadastralService configuracaoInscricaoCadastralService;

    public CalculoLoteImpressaoService(CalculoLoteImpressaoItemService calculoLoteImpressaoItemService, CalculoLoteImpressaoRepository calculoLoteImpressaoRepository, ArquivoClient arquivoClient, EntidadeService entidadeService, ArquivoGraficaRepository arquivoGraficaRepository, ConfiguracaoInscricaoCadastralService configuracaoInscricaoCadastralService) {
        this.calculoLoteImpressaoItemService = calculoLoteImpressaoItemService;
        this.calculoLoteImpressaoRepository = calculoLoteImpressaoRepository;
        this.arquivoClient = arquivoClient;
        this.entidadeService = entidadeService;
        this.arquivoGraficaRepository = arquivoGraficaRepository;
        this.configuracaoInscricaoCadastralService = configuracaoInscricaoCadastralService;
    }

    public Page<CalculoLoteImpressaoDTO> findbyCalculoId(Long idCalculo, String search, Pageable pageable) {
        String idClause = String.format("calculoGeracaoLote.calculo.id==%d", idCalculo);
        String searchWithIdClause = StringUtils.isBlank((CharSequence)search) ? idClause : String.format("(%s) and (%s)", idClause, search);
        return this.findByRsql(searchWithIdClause, pageable).map(CalculoLoteImpressaoDTO::of);
    }

    public List<CalculoLoteImpressao> createLoteImpressao(CalculoGeracaoLote calculoGeracaoLote, Map<String, List<LoteItemDTO>> lotes) {
        ArrayList<CalculoLoteImpressao> loteImpressaoList = new ArrayList<CalculoLoteImpressao>();
        AtomicLong ordem = new AtomicLong();
        lotes.forEach((lote, loteItens) -> {
            int quantidadeMaximaPorLote = Objects.nonNull(calculoGeracaoLote.getQuantidadePorLote()) && calculoGeracaoLote.getQuantidadePorLote() > 0L ? calculoGeracaoLote.getQuantidadePorLote().intValue() : loteItens.size();
            List partitions = Lists.partition(loteItens.stream().filter(Objects::nonNull).collect(Collectors.toList()), (int)quantidadeMaximaPorLote);
            AtomicLong parte = new AtomicLong();
            partitions.forEach(lotesPartition -> {
                CalculoLoteImpressao loteImpressao = new CalculoLoteImpressao();
                ordem.incrementAndGet();
                loteImpressao.setCalculoGeracaoLote(calculoGeracaoLote);
                loteImpressao.setDescricao(lote);
                loteImpressao.setOrdem(Long.valueOf(ordem.get()));
                loteImpressao.setQuantidadeItens(Long.valueOf(lotesPartition.size()));
                if (partitions.size() > 1) {
                    loteImpressao.setDescricao(String.format("%s - Parte %d", loteImpressao.getDescricao(), parte.incrementAndGet()));
                }
                CalculoLoteImpressao calculoLoteImpressao = (CalculoLoteImpressao)this.calculoLoteImpressaoRepository.save((Object)loteImpressao);
                loteImpressaoList.add(loteImpressao);
                this.calculoLoteImpressaoItemService.createLoteImpressaoItem(calculoLoteImpressao, lotesPartition);
            });
        });
        return loteImpressaoList;
    }

    public ArquivoGraficaDTO gerarArquivoGrafica(Long id) {
        CalculoLoteImpressao calculoLoteImpressao = (CalculoLoteImpressao)this.calculoLoteImpressaoRepository.findById((Object)id).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi encontrado lote de impress\u00e3o com id %d.", id)));
        Calculo calculo = calculoLoteImpressao.getCalculoGeracaoLote().getCalculo();
        if (Arrays.asList(SituacaoCalculo.CARNE_GERADO, SituacaoCalculo.ARQUIVO_GERADO).contains(calculo.getSituacao())) {
            if (Objects.isNull(calculoLoteImpressao.getIdArquivoGrafica())) {
                Arquivo arquivo = this.uploadArquivoGrafica(calculoLoteImpressao);
                calculoLoteImpressao.setIdArquivoGrafica(arquivo.getId());
                calculoLoteImpressao.setDataGeracaoArquivo(arquivo.getDataCriacao().toLocalDate());
                if (this.calculoLoteImpressaoRepository.todosLotesDoCalculoPossuemArquivoGerado(calculo.getId())) {
                    calculo.setSituacao(SituacaoCalculo.ARQUIVO_GERADO);
                }
                this.calculoLoteImpressaoRepository.save((Object)calculoLoteImpressao);
            }
            return new ArquivoGraficaDTO(calculoLoteImpressao.getDataGeracaoArquivo(), this.getUrlArquivoGrafica(calculoLoteImpressao.getIdArquivoGrafica()), calculo.getSituacao());
        }
        throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel gerar arquivo da gr\u00e1fica para c\u00e1lculo com situa\u00e7\u00e3o %s.", calculo.getSituacao().getDescricao()));
    }

    private Arquivo uploadArquivoGrafica(CalculoLoteImpressao calculoLoteImpressao) {
        String nomeArquivo = String.format("ElotechOxyArquivoGrafica%s", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmm")));
        EntidadeInfo entidadePrincipal = this.entidadeService.findEntidadePrincipal();
        ConfiguracaoInscricaoCadastral configuracao = this.configuracaoInscricaoCadastralService.getConfiguracao();
        List debitos = this.arquivoGraficaRepository.loadItens(calculoLoteImpressao);
        Map<Long, List<ArquivoGraficaBoletoDTO>> boletos = this.arquivoGraficaRepository.loadBoletos(calculoLoteImpressao.getId()).stream().collect(Collectors.groupingBy(ArquivoGraficaBoletoDTO::getIdItemLoteImpressao));
        ArquivoGrafica arquivoGrafica = new ArquivoGrafica(nomeArquivo);
        arquivoGrafica.gerarSegmentoA(calculoLoteImpressao, entidadePrincipal.getDescricao());
        debitos.forEach(item -> {
            arquivoGrafica.gerarSegmentoC(item, configuracao);
            arquivoGrafica.gerarSegmentoD(item);
            if (TipoCadastro.IMOBILIARIO.getValue().equals(item.getTipoCadastro())) {
                arquivoGrafica.gerarSegmentoE(item);
                arquivoGrafica.gerarSegmentoF(item);
                if (Objects.nonNull(item.getCodigoPessoaCompromissario())) {
                    arquivoGrafica.gerarSegmentoJ(item);
                }
            }
            arquivoGrafica.gerarSegmentoN(item);
            arquivoGrafica.gerarSegmentoO((List)boletos.get(item.getIdItemLoteImpressao()));
            if (!item.getCamposVariaveis().isEmpty()) {
                arquivoGrafica.gerarSegmentoQ(item.getCamposVariaveis());
            }
        });
        arquivoGrafica.gerarSegmentoZ(debitos.size());
        arquivoGrafica.finalizaGeracaoArquivo();
        ArquivoNovoRequest arquivoNovoRequest = ArquivoNovoRequest.builder((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (Modulo)Modulo.OXY_TRIBUTOS).fileName(nomeArquivo).content((InputStream)new ByteArrayInputStream(arquivoGrafica.getOutStream().toByteArray())).contentType(ContentType.APPLICATION_ZIP).build();
        return this.arquivoClient.criarArquivo(arquivoNovoRequest);
    }

    private String getUrlArquivoGrafica(UUID idArquivo) {
        ArquivoDownloadRequest arquivoDownloadRequest = ArquivoDownloadRequest.create((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (String)idArquivo.toString());
        return this.arquivoClient.gerarUrlParaGet(arquivoDownloadRequest).getUrlAssinada();
    }
}

