/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.calculo.domain.ArquivoGraficaConfig;
import br.com.elotech.tributos.calculo.domain.ArquivoGraficaConfigCampo;
import br.com.elotech.tributos.calculo.domain.ArquivoGraficaConfigImpressaoResposta;
import br.com.elotech.tributos.calculo.domain.CalculoLoteImpressao;
import br.com.elotech.tributos.calculo.dto.ArquivoGraficaBoletoDTO;
import br.com.elotech.tributos.calculo.dto.ArquivoGraficaItemDTO;
import br.com.elotech.tributos.calculo.repository.ArquivoGraficaConfigRepository;
import br.com.elotech.tributos.calculo.repository.ArquivoGraficaRepository;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.camposdinamicos.TipoCampo;
import br.com.elotech.tributos.exception.PaginationException;
import br.com.elotech.tributos.service.ParametroGeralService;
import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.support.DatabaseType;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.stereotype.Repository;

@Repository
public class ArquivoGraficaRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArquivoGraficaRepository.class);
    private static final String LOAD_ITENS = "br/com/elotech/tributos/calculo/repository/load-debitos-arquivo-grafica.sql";
    private static final String LOAD_BOLETOS = "br/com/elotech/tributos/calculo/repository/load-boletos-arquivo-grafica.sql";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private final ParametroGeralService parametroGeralService;
    private final ArquivoGraficaConfigRepository arquivoGraficaConfigRepository;

    public ArquivoGraficaRepository(NamedParameterJdbcTemplate namedParameterJdbcTemplate, ParametroGeralService parametroGeralService, ArquivoGraficaConfigRepository arquivoGraficaConfigRepository) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
        this.parametroGeralService = parametroGeralService;
        this.arquivoGraficaConfigRepository = arquivoGraficaConfigRepository;
    }

    public List<ArquivoGraficaItemDTO> loadItens(CalculoLoteImpressao calculoLoteImpressao) {
        List arquivoGraficaConfigCampos = Optional.ofNullable(this.arquivoGraficaConfigRepository.findByTipoDivida(calculoLoteImpressao.getCalculoGeracaoLote().getCalculo().getTipoDivida())).map(ArquivoGraficaConfig::getCampos).orElseGet(ArrayList::new);
        String sql = String.format(FileUtils.readResourceAsString((String)LOAD_ITENS), this.getSelectReceitasCarneByDbType(), this.getSelectCamposVariaveis(arquivoGraficaConfigCampos));
        Boolean utilizaTestadaGenerica = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.UTILIZA_TESTADA_GENERICA);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("idcalculoloteimpressao", (Object)calculoLoteImpressao.getId());
        parameters.addValue("utilizatestadagenerica", (Object)SimNao.fromBoolean((Boolean)utilizaTestadaGenerica));
        Stopwatch stopwatch = Stopwatch.createStarted();
        List itens = this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(ArquivoGraficaItemDTO.class));
        stopwatch.stop();
        LOGGER.debug("Carregando {} itens para arquivo da  gr\u00e1fica - {} m {} s {} ms - {} ns", new Object[]{itens.size(), stopwatch.elapsed(TimeUnit.MINUTES), stopwatch.elapsed(TimeUnit.SECONDS), stopwatch.elapsed(TimeUnit.MILLISECONDS), stopwatch.elapsed(TimeUnit.NANOSECONDS)});
        return itens;
    }

    private String getSelectCamposVariaveis(List<ArquivoGraficaConfigCampo> camposVariaveis) {
        if (camposVariaveis.isEmpty()) {
            return "";
        }
        return camposVariaveis.stream().sorted(Comparator.comparing(ArquivoGraficaConfigCampo::getOrdem)).map(campoVariavel -> {
            StringBuilder query = new StringBuilder(", \n ( \n");
            query.append(this.getSelectStatement(campoVariavel));
            query.append(String.format(") || '##' || '%d' as campoVariavel", campoVariavel.getTamanho()));
            return query.toString();
        }).collect(Collectors.joining());
    }

    private String getSelectStatement(ArquivoGraficaConfigCampo campoVariavel) {
        if (Objects.nonNull(campoVariavel.getIdCampoDinamico())) {
            if (TipoCampo.MULTIPLA_ESCOLHA.equals((Object)campoVariavel.getTipocampo())) {
                return String.format(" select %s \n        from %s r  \n        join alternativa alt on r.idalternativa = alt.id \n       where r.idcampo = %d \n         and r.referencia = cg.idkey ", this.getSelectFieldMultiplaEscolha(campoVariavel.getTipoImpressaoResposta()), campoVariavel.getTabela(), campoVariavel.getIdCampoDinamico());
            }
            return String.format("select r.valor \n       from %s r \n      where r.idcampo = %d \n        and r.referencia = cg.idkey ", campoVariavel.getTabela(), campoVariavel.getIdCampoDinamico());
        }
        return String.format("%s.%s", this.getAliasOrTabela(campoVariavel.getTabela()), campoVariavel.getCampo());
    }

    private String getSelectFieldMultiplaEscolha(ArquivoGraficaConfigImpressaoResposta tipoImpressao) {
        switch (1.$SwitchMap$br$com$elotech$tributos$calculo$domain$ArquivoGraficaConfigImpressaoResposta[tipoImpressao.ordinal()]) {
            case 1: {
                return "alt.codigo";
            }
            case 2: {
                return "alt.descricao";
            }
            case 3: {
                return "alt.codigo || '-' || alt.descricao";
            }
        }
        throw new EloValidationException("Tipo Impress\u00e3o inv\u00e1lido");
    }

    private String getSelectReceitasCarneByDbType() {
        if (DatabaseType.POSTGRES.equals((Object)this.getDatabaseType())) {
            return " select string_agg(tr.receita || '##' || tdr.valorreceita || '##' || tr.descricao || '##' || tr.apelido, '###')\n  from tribdebitoreceita tdr \n  join tribreceita tr \n    on tr.receita = tdr.receita \n   and tr.exercicio = tdr.exercicio \n   and tr.entidade = tdr.entidade \n where tdr.entidade         = d.entidade \n   and tdr.exercicio        = d.exercicio \n   and tdr.tipocadastro     = d.tipocadastro\n   and tdr.cadastrogeral    = d.cadastrogeral \n   and tdr.guiarecolhimento = d.guiarecolhimento \n   and tdr.subdivida        = d.subdivida";
        }
        return " select listagg(tr.receita || '##' || tdr.valorreceita || '##' || tr.descricao || '##' || tr.apelido, '###')\nwithin group(order by tr.receita desc) \n  from tribdebitoreceita tdr \n  join tribreceita tr \n    on tr.receita = tdr.receita \n   and tr.exercicio = tdr.exercicio \n   and tr.entidade = tdr.entidade \n where tdr.entidade         = d.entidade \n   and tdr.exercicio        = d.exercicio \n   and tdr.tipocadastro     = d.tipocadastro\n   and tdr.cadastrogeral    = d.cadastrogeral \n   and tdr.guiarecolhimento = d.guiarecolhimento \n   and tdr.subdivida        = d.subdivida";
    }

    private String getSelectReceitasBoletoByDbType() {
        if (DatabaseType.POSTGRES.equals((Object)this.getDatabaseType())) {
            return " select string_agg(x.receita || '##' || x.valor || '##' || x.descricao || '##' || x.apelido, '###') \n  from ( select tr.receita, sum(tdpr.valor) as valor, tr.descricao, tr.apelido \n           from tribbloquetodebito tbd \n           join tribdebitoparcelareceita tdpr on tbd.iddebitoparcelareceita = tdpr.iddebitoparcelareceita \n           join tribreceita tr on tdpr.entidade = tr.entidade \n                              and tdpr.exercicio = tr.exercicio  \n                              and tdpr.receita = tr.receita  \n          where tbd.entidade = tb.entidade \n            and tbd.exerciciobloqueto = tb.exerciciobloqueto \n            and tbd.bloqueto = tb.bloqueto \n          group by tr.receita, tr.descricao, tr.apelido) x";
        }
        if (DatabaseType.ORACLE.equals((Object)this.getDatabaseType())) {
            return " select listagg(tr.receita || '##' || sum(tdpr.valor) || '##' || tr.descricao || '##' || tr.apelido, '###') \nwithin group(order by tr.receita desc) \n  from tribbloquetodebito tbd \n  join tribdebitoparcelareceita tdpr on tbd.iddebitoparcelareceita = tdpr.iddebitoparcelareceita \n  join tribreceita tr on tdpr.entidade = tr.entidade \n                     and tdpr.exercicio = tr.exercicio \n                     and tdpr.receita = tr.receita \n where tbd.entidade = tb.entidade \n   and tbd.exerciciobloqueto = tb.exerciciobloqueto \n   and tbd.bloqueto = tb.bloqueto \n group by tr.receita, tr.descricao, tr.apelido";
        }
        return " select listagg(tr.receita || '##' || tdpr.valor || '##' || tr.descricao || '##' || tr.apelido, '###') \nwithin group(order by tr.receita desc) \n  from tribbloquetodebito tbd \n  join tribdebitoparcelareceita tdpr on tbd.iddebitoparcelareceita = tdpr.iddebitoparcelareceita \n  join tribreceita tr on tdpr.entidade = tr.entidade \n                     and tdpr.exercicio = tr.exercicio \n                     and tdpr.receita = tr.receita \n where tbd.entidade = tb.entidade \n   and tbd.exerciciobloqueto = tb.exerciciobloqueto \n   and tbd.bloqueto = tb.bloqueto \n group by tr.receita, tr.descricao, tr.apelido";
    }

    private DatabaseType getDatabaseType() {
        DatabaseType databaseType;
        try {
            databaseType = DatabaseType.fromMetaData((DataSource)Objects.requireNonNull(this.namedParameterJdbcTemplate.getJdbcTemplate().getDataSource()));
        }
        catch (MetaDataAccessException e) {
            throw new PaginationException("Erro ao extrair os metadados do banco", (Throwable)e);
        }
        if (!Arrays.asList(DatabaseType.ORACLE, DatabaseType.POSTGRES, DatabaseType.H2).contains(databaseType)) {
            throw new EloValidationException("Gera\u00e7\u00e3o do arquivo para gr\u00e1fica n\u00e3o implementado para este tipo de banco de dados.");
        }
        return databaseType;
    }

    public List<ArquivoGraficaBoletoDTO> loadBoletos(Long idLoteImpressao) {
        String sql = String.format(FileUtils.readResourceAsString((String)LOAD_BOLETOS), this.getSelectReceitasBoletoByDbType());
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("idcalculoloteimpressao", (Object)idLoteImpressao);
        Stopwatch stopwatch = Stopwatch.createStarted();
        List boletos = this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(ArquivoGraficaBoletoDTO.class));
        stopwatch.stop();
        LOGGER.debug("Carregando {} boletos para arquivo da  gr\u00e1fica - {} m {} s {} ms - {} ns", new Object[]{boletos.size(), stopwatch.elapsed(TimeUnit.MINUTES), stopwatch.elapsed(TimeUnit.SECONDS), stopwatch.elapsed(TimeUnit.MILLISECONDS), stopwatch.elapsed(TimeUnit.NANOSECONDS)});
        return boletos;
    }

    private String getAliasOrTabela(String tabela) {
        if (tabela.equals("cidade")) {
            return "cid";
        }
        if (tabela.equals("tribcadastrogeral")) {
            return "cg";
        }
        if (tabela.equals("tribcadastroimobiliario")) {
            return "ci";
        }
        if (tabela.equals("tribcadastromobiliario")) {
            return "cm";
        }
        return tabela;
    }
}

