Select distinct a.TipoCadastro,
                a.CadastroGeral,
                a.idKey as idCadastro,
                a.cnpj_cpf as cpfCnpj,
                case when a.tipopessoa = 'J' 
                     then 'Jurídica'
                     else 'Física'
                end as tipoPessoa,
                a.nome,
                a.pessoa,
                a.VinculoDescricao,
                a.tipovinculo,
                a.principal,
                coalesce(sitimob.descricao, sitmob.descricao, 'OK') as situacao
  from (Select distinct a.TipoCadastro,
                        a.CadastroGeral,
                        a.idKey,
                        b.cnpj_cpf,
                        b.tipopessoa,
                        b.nome,
                        b.pessoa,
                        case when a.Tipocadastro = 1
                             then tv.Descricao
                             else 'PROPRIETARIO'
                        end as VinculoDescricao,
                        tv.tipovinculo,
                        case when tb.principal = 'S' 
                     		then 1
                     		else 0
                		end as principal
          from tribCadastroGeral a
         inner join tribViewProprietario tb on a.TipoCadastro = tb.TipoCadastro
                                           and a.CadastroGeral = tb.CadastroGeral
          left outer join pessoa b on ((tb.pessoa = b.pessoa and a.TipoCadastro = 1) or
                                      (a.pessoa = b.pessoa and a.TipoCadastro in (:tiposCadastroExcetoImobiliario)))
          left outer join tribVinculo tv on tb.Vinculo = tv.Vinculo
         Where a.ExclusaoLogica = 'N'
           and not exists
         (select 1
                  from tribViewProprietario tb2
                 inner join tribvinculo tv2 on (tv2.vinculo = tb2.vinculo)
                 where tb2.tipocadastro = tb.tipocadastro
                   and tb2.cadastrogeral = tb.cadastrogeral
                   and tb2.pessoa = tb.pessoa
                   and tv2.tipovinculo = 5)
           and a.tipocadastro in (:tiposCadastro)
           :filtroRastreamento
        union
        Select distinct a.TipoCadastro,
                        a.CadastroGeral,
                        a.idKey,
                        b.cnpj_cpf,
                        b.tipopessoa,
                        b.nome,
                        b.pessoa,
                        cast('PROPRIETARIO' as varchar(20)) as VinculoDescricao,
                        cast(0 as numeric) as tipovinculo,
                        cast(1 as numeric) as principal
          from tribCadastroGeral a
          left outer join pessoa b on (a.pessoa = b.pessoa and a.TipoCadastro in (:tiposCadastroExcetoImobiliario))
         Where a.ExclusaoLogica = 'N'
           and not exists (select 1
                  from tribViewProprietario tb
                 where tb.tipocadastro = a.tipocadastro
                   and tb.cadastrogeral = a.cadastrogeral)
           and a.tipocadastro in (:tiposCadastro)
           :filtroRastreamento
        ) a
 left outer join tribmobiliariosituacao mobsit
  on a.tipocadastro = mobsit.tipocadastro
  and a.cadastrogeral = mobsit.cadastrogeral
  and mobsit.atual = 'S'
 left outer join tribsituacaomobiliario sitmob
  on sitmob.situacaomobiliario = mobsit.situacaomobiliario
 left outer join tribimobiliariosituacao imobsit
  on a.tipocadastro = imobsit.tipocadastro
  and a.cadastrogeral = imobsit.cadastrogeral
  and imobsit.atual = 'S'
 left outer join tribsituacaoimobiliario sitimob
  on sitimob.situacaoimobiliario = imobsit.situacaoimobiliario
