select a.TipoCadastro,
       a.CadastroGeral,
       a.idKey as idCadastro,
       b.cnpj_cpf as cpfCnpj,
       case when b.tipopessoa = 'J' 
            then 'Jurídica'
            else 'Física'
       end as tipoPessoa,
       b.nome,
       b.pessoa,
       tv.tipovinculo,
       tv.descricao as VinculoDescricao,
       cast(0 as numeric) as principal,
       'OK' as situacao
  from tribcadastrogeral a
  left outer join tribproprietario prop on (prop.tipocadastro = a.tipocadastro and
                                        prop.cadastrogeral = a.cadastrogeral)
  left outer join pessoa b on (prop.pessoa = b.pessoa)
  left outer join tribvinculo tv on (prop.vinculo = tv.vinculo) 
 Where tv.tipovinculo = 5
 and a.exclusaologica = 'N'