SELECT debito.iddebito AS id,
	debitoParcela.ENTIDADE,
	debitoParcela.EXERCICIO,
	debitoParcela.TIPOCADASTRO,
	debitoParcela.CADASTROGERAL,
	pessoa.nome as nomeCadastro,
	debitoParcela.GUIARECOLHIMENTO AS DIVIDA,
	guiaRecolhimento.descricao AS dividaDescricao,
	debitoParcela.SUBDIVIDA,
	debitoParcela.PARCELA,
	debitoParcela.SITUACAOLEGAL,
	debitoParcela.LIVRO as numeroLivro,
	debitoParcela.EXERCICIOLIVRO as exercicioLivroId,
	debitoParcela.NUMEROFOLHA,
	debitoParcela.NUMEROINSCRICAO,
	debitoParcela.DATADIVIDAATIVA,
	debitoParcela.DATADISTRIBUICAO,
	debitoParcela.NUMERODISTRIBUICAO,
	debitoParcela.IDCARTORIO,
	debitoParcela.SITUACAODEBITO,
	situacaoParcela.DESCRICAO situacaoDebitoDescricao,
	debitoParcela.DATAVENCIMENTO,
	debitoParcela.DATASITUACAO,
	situacaoParcela.TIPOSITUACAOPARCELA,
	situacaoParcela.SIGLA AS SiglaSituacaoParcela,
	tipoSituacaoParcela.TIPO AS TipoSituacaoParcelaDesc,
	debitoParcela.MESREFERENCIA,
	debitoParcela.ANOREFERENCIA,
	debitoParcela.DataAjuizamento,
	debitoParcela.ProcessoJudicial,
	debitoParcela.IDProtesto,
	sum(debitoParcelaReceita.VALOR) AS valorParcela
FROM TRIBDEBITO debito
LEFT OUTER JOIN tribDebitoParcela debitoParcela ON
	debito.ENTIDADE = debitoParcela.ENTIDADE
	AND debito.EXERCICIO = debitoParcela.EXERCICIO
	AND debito.TIPOCADASTRO = debitoParcela.TIPOCADASTRO
	AND debito.CADASTROGERAL = debitoParcela.CADASTROGERAL
	AND debito.GUIARECOLHIMENTO = debitoParcela.GUIARECOLHIMENTO
	AND debito.SUBDIVIDA = debitoParcela.SUBDIVIDA
LEFT OUTER JOIN tribDebitoParcelaReceita debitoParcelaReceita ON
	debito.ENTIDADE = debitoParcelaReceita.ENTIDADE
	AND debito.EXERCICIO = debitoParcelaReceita.EXERCICIO
	AND debito.TIPOCADASTRO = debitoParcelaReceita.TIPOCADASTRO
	AND debito.CADASTROGERAL = debitoParcelaReceita.CADASTROGERAL
	AND debito.GUIARECOLHIMENTO = debitoParcelaReceita.GUIARECOLHIMENTO
	AND debito.SUBDIVIDA = debitoParcelaReceita.SUBDIVIDA
	AND debitoParcela.PARCELA = debitoParcelaReceita.PARCELA
LEFT OUTER JOIN tribSituacaoParcela situacaoParcela ON
	debitoParcela.SITUACAODEBITO = situacaoParcela.SITUACAOPARCELA
LEFT OUTER JOIN tribTipoSituacaoParcela tipoSituacaoParcela ON
	tipoSituacaoParcela.TIPOSITUACAOPARCELA = situacaoParcela.TIPOSITUACAOPARCELA
LEFT OUTER JOIN tribCadastroGeral cadastroGeral ON
    debito.tipoCadastro = cadastroGeral.tipoCadastro
    AND debito.cadastroGeral = cadastroGeral.cadastroGeral
LEFT OUTER JOIN pessoa ON
    cadastroGeral.pessoa = pessoa.pessoa
LEFT OUTER JOIN tribGuiaRecolhimento guiaRecolhimento ON
    debito.exercicio = guiaRecolhimento.exercicio
    AND debito.guiaRecolhimento = guiaRecolhimento.guiaRecolhimento
WHERE
	debito.IDDEBITO = :id
	AND debitoParcela.parcela = :parcela
GROUP BY debito.IDDEBITO,
	debitoParcela.ENTIDADE,
	debitoParcela.EXERCICIO,
	debitoParcela.TIPOCADASTRO,
	debitoParcela.CADASTROGERAL,
	pessoa.nome,
	debitoParcela.GUIARECOLHIMENTO,
	guiaRecolhimento.descricao,
	debitoParcela.SUBDIVIDA,
	debitoParcela.PARCELA,
	debitoParcela.SITUACAOLEGAL,
	debitoParcela.LIVRO,
	debitoParcela.EXERCICIOLIVRO,
	debitoParcela.NUMEROFOLHA,
	debitoParcela.NUMEROINSCRICAO,
	debitoParcela.DATADIVIDAATIVA,
	debitoParcela.DATADISTRIBUICAO,
	debitoParcela.NUMERODISTRIBUICAO,
	debitoParcela.IDCARTORIO,
	debitoParcela.SITUACAODEBITO,
	situacaoParcela.DESCRICAO,
	debitoParcela.DATAVENCIMENTO,
	debitoParcela.DATASITUACAO,
	situacaoParcela.TIPOSITUACAOPARCELA,
	situacaoParcela.SIGLA,
	tipoSituacaoParcela.TIPO,
	debitoParcela.MESREFERENCIA,
	debitoParcela.ANOREFERENCIA,
	debitoParcela.DataAjuizamento,
	debitoParcela.ProcessoJudicial,
	debitoParcela.IDProtesto
ORDER BY debitoParcela.entidade,
    debitoParcela.exercicio,
    debitoParcela.guiarecolhimento,
    debitoParcela.subdivida,
    debitoParcela.parcela