SELECT
	debito.IDDEBITO AS id,
	debitoReceita.IDDEBITORECEITA as idDebitoTributo,
	debitoReceitaIsencao.IDDEBITORECEITAISENCAO as idDebitoTributoIsencao,
	debitoReceita.ENTIDADE,
	debitoReceita.EXERCICIO,
	debitoReceita.TIPOCADASTRO,
	debitoReceita.CADASTROGERAL,
	debitoReceita.GUIARECOLHIMENTO AS DIVIDA,
	debitoReceita.SUBDIVIDA,
	debitoReceita.RECEITA AS TRIBUTO,
	guiaRecolhimentoReceita.ORDEM,
	debitoReceita.VALORRECEITA AS valorTributo,
	debitoReceita.VALORDESCONTO,
	debitoReceita.VALORBASECALCULO,
	debitoReceita.VALORRENUNCIA,
	receita.Descricao AS descTributo,
	debitoReceitaIsencao.VALORISENCAO,
	debitoReceitaIsencao.ISENCAO,
	isencao.DESCRICAO AS descIsencao
FROM tribdebito debito
LEFT OUTER JOIN tribDebitoReceita debitoReceita ON
	debito.ENTIDADE = debitoReceita.ENTIDADE
	AND debito.EXERCICIO = debitoReceita.EXERCICIO
	AND debito.TIPOCADASTRO = debitoReceita.TIPOCADASTRO
	AND debito.CADASTROGERAL = debitoReceita.CADASTROGERAL
	AND debito.GUIARECOLHIMENTO = debitoReceita.GUIARECOLHIMENTO
	AND debito.SUBDIVIDA = debitoReceita.SUBDIVIDA
LEFT OUTER JOIN tribReceita receita ON
	debitoReceita.Entidade = receita.Entidade
	AND debitoReceita.Exercicio = receita.Exercicio
	AND debitoReceita.Receita = receita.Receita
LEFT OUTER JOIN tribGuiaRecolhimentoReceita guiaRecolhimentoReceita ON
	guiaRecolhimentoReceita.entidade = debitoReceita.entidade
	AND guiaRecolhimentoReceita.exercicio = debitoReceita.exercicio
	AND guiaRecolhimentoReceita.receita = debitoReceita.receita
	AND guiaRecolhimentoReceita.guiarecolhimento = debitoReceita.guiarecolhimento
LEFT OUTER JOIN tribDebitoReceitaIsencao debitoReceitaIsencao ON
	debitoReceita.ENTIDADE = debitoReceitaIsencao.ENTIDADE
	AND debitoReceita.EXERCICIO = debitoReceitaIsencao.EXERCICIO
	AND debitoReceita.TIPOCADASTRO = debitoReceitaIsencao.TIPOCADASTRO
	AND debitoReceita.CADASTROGERAL = debitoReceitaIsencao.CADASTROGERAL
	AND debitoReceita.GUIARECOLHIMENTO = debitoReceitaIsencao.GUIARECOLHIMENTO
	AND debitoReceita.SUBDIVIDA = debitoReceitaIsencao.SUBDIVIDA
	AND debitoReceita.RECEITA = debitoReceitaIsencao.RECEITA
LEFT OUTER JOIN tribIsencao isencao ON
	debitoReceitaIsencao.ISENCAO = isencao.ISENCAO
WHERE debito.IDDEBITO = :id
ORDER BY guiaRecolhimentoReceita.Ordem,
	debitoReceita.ORDEM,
	debitoReceita.RECEITA