 Select tdp.ExercicioLivro,
        tdp.livro,
        tdp.NumeroInscricao,
        tdp.NumeroFolha,
        coalesce(liv.Sequencia, 0) Sequencia,
        tdp.Exercicio ExercicioDebito,
        tdp.TipoCadastro,
        tdp.CadastroGeral,
        tdp.GuiaRecolhimento as divida,
        tdp.SubDivida,
        tdp.Parcela,
        tdp.DataLancamento,
        tdp.DataVencimento,
        tdp.SituacaoDebito,
        tdp.SituacaoLegal,
        tsp.TipoSituacaoParcela,
        td.DataPrimeiraParcela,
        td.DataCorrecao,
        td.DataCorrecaoIGPM,
        td.FormaCorrecao,
        case when coalesce(td.Reparcelado, 'N') = 'N' then 0 else 1 end as Reparcelado,
        case when coalesce(td.Parcelado, 'N') = 'N' then 0 else 1 end as Parcelado,
        tdpr.Receita as tributo,
        cg.Pessoa,
        p.Nome,
        p.CNPJ_CPf,
        p.TipoPessoa,
        tdpr.Valor,
        0.00 as ValorJuros,
        0.00 as ValorMulta,
        0.00 as ValorCorrecao,
        td.IdDebito,
        case when coalesce(tgr.CDAIndividual, 'N') = 'N' then 0 else 1 end as CDAIndividual,
        tgr.Descricao as DescricaoGuia,
        tgr.IDKEY as idDivida,
        tdpr.idDebitoParcelaReceita as idDebitoParcelaTributo,
        cg.idkey as idCadastroGeral
 from tribDebitoParcelaReceita tdpr
   left join tribDebitoParcela tdp
     on tdpr.entidade = tdp.entidade
    and tdpr.Exercicio = tdp.Exercicio
    and tdpr.TipoCadastro = tdp.TipoCadastro
    and tdpr.CadastroGeral = tdp.CadastroGeral
    and tdpr.GuiaRecolhimento = tdp.GuiaRecolhimento
    and tdpr.SubDivida = tdp.SubDivida
    and tdpr.Parcela = tdp.Parcela
   left join tribDebito td
     on tdpr.entidade = td.entidade
    and tdpr.Exercicio = td.Exercicio
    and tdpr.TipoCadastro = td.TipoCadastro
    and tdpr.CadastroGeral = td.CadastroGeral
    and tdpr.GuiaRecolhimento = td.GuiaRecolhimento
    and tdpr.SubDivida = td.SubDivida
   left join TribSituacaoParcela tsp
     on tsp.SituacaoParcela = tdp.SituacaoDebito
   left join tribtiposituacaoparcela ttsp
     on (tsp.tiposituacaoparcela = ttsp.tiposituacaoparcela)
   left join tribCadastroGeral cg
     on td.TipoCadastro = cg.TipoCadastro
    and td.CadastroGeral = cg.CadastroGeral
   left join TribLivroParcelaReceita livr
     on tdpr.IDDebitoParcelaReceita = livr.IDDebitoParcelaReceita
   left join TribLivroRegistro liv
     on livr.Entidade = liv.Entidade
    and livr.Exercicio = liv.Exercicio
    and livr.Livro = liv.Livro
    and livr.sequencia = liv.Sequencia
   left join TribGuiaRecolhimento tgr
     on td.Entidade = tgr.Entidade
    and td.Exercicio = tgr.Exercicio
    and td.GuiaRecolhimento = tgr.GuiaRecolhimento
   left join Pessoa p
     on cg.Pessoa = p.Pessoa
 where td.Entidade = :entidade
   and ttsp.tipo = 'A'
   and tdp.Livro is not null
   and cg.exclusaologica = 'N'
   and coalesce(livr.estornado, 'N') = 'N'
   and not exists (select 1
                     from tribdocumentoitemdividaativa tdida
                    inner join tribdocumento td
                       on td.tipodocumento = tdida.tipodocumento
                      and td.documento = tdida.documento
                      and td.entidade = tdida.entidade
                      and td.exercicio = tdida.exercicio
                    inner join tribsituacaodocumento tsd
                       on tsd.idsituacaodocumento = td.situacao
                    where tdida.entidade = tdpr.entidade
                      and tdida.exerciciodebito = tdpr.exercicio
                      and tdida.tipocadastro = tdpr.tipocadastro
                      and tdida.cadastrogeral = tdpr.cadastrogeral
                      and tdida.guiarecolhimento = tdpr.guiarecolhimento
                      and tdida.subdivida = tdpr.subdivida
                      and tdida.parcela = tdpr.parcela
                      and tdida.receita = tdpr.receita
                      and tsd.cancelamento = 'N')
    $[FILTROS]
 Order by td.TipoCadastro,
           td.CadastroGeral,
           tgr.CdAIndividual,
           td.Exercicio,
           td.GuiaRecolhimento,
           td.SubDivida,
           tdp.Parcela