
 select 
        deb.entidade,
        deb.exercicio,
        deb.tipocadastro,
        deb.cadastrogeral,
        deb.guiarecolhimento,
        deb.subdivida,
        deb.iddebito,
        rec.valor,
        rec.valorjuros,
        rec.valormulta,
        rec.valorcorrecao,
        rec.valordesconto,
        case
           when fp.tipoformapagamento = 'U'
             then fpag.vencimento
             else cast(null as date)
        end as vencimento,
        fp.formapagamento,
        fp.tipoformapagamento,
        rec.receita,
        coalesce(frec.desconto, 0) as desconto,
        coalesce(frec.descontojuros, 0) as descontojuros,
        coalesce(frec.descontomulta, 0) as descontomulta,
        coalesce(frec.descontocorrecao, 0) as descontocorrecao,
        guia.descricao as descricaoGuia,
        fp.descricao as descricaoFormaPagamento,
        fp.ordememissao
 from tribdebito deb
 inner join tribcadastrogeral cg
         on deb.tipocadastro     = cg.tipocadastro
        and deb.cadastrogeral    = cg.cadastrogeral
 inner join tribdebitoparcela par
         on deb.entidade         = par.entidade
        and deb.exercicio        = par.exercicio
        and deb.tipocadastro     = par.tipocadastro
        and deb.cadastrogeral    = par.cadastrogeral
        and deb.guiarecolhimento = par.guiarecolhimento
        and deb.subdivida        = par.subdivida
 inner join tribsituacaoparcela sit
         on sit.situacaoparcela     = par.situacaodebito
 inner join tribdebitoparcelareceita rec
         on par.entidade         = rec.entidade
        and par.exercicio        = rec.exercicio
        and par.tipocadastro     = rec.tipocadastro
        and par.cadastrogeral    = rec.cadastrogeral
        and par.guiarecolhimento = rec.guiarecolhimento
        and par.subdivida        = rec.subdivida
        and par.parcela          = rec.parcela
 inner join tribguiarecolhimento guia
         on deb.entidade         = guia.entidade
        and deb.exercicio        = guia.exercicio
        and deb.guiarecolhimento = guia.guiarecolhimento
 inner join tribguiarecolhimentoformapag fpag
         on deb.entidade         = fpag.entidade
        and deb.exercicio        = fpag.exercicio
        and deb.guiarecolhimento = fpag.guiarecolhimento
 inner join tribformapagamento fp
         on fp.formapagamento = fpag.formapagamento
 left outer join tribguiaformapagreceita frec
         on fpag.entidade          = frec.entidade
         and fpag.exercicio        = frec.exercicio
         and fpag.guiarecolhimento = frec.guiarecolhimento
         and fpag.formapagamento   = frec.formapagamento
         and rec.receita           = frec.receita
 where deb.entidade           = :entidade
 and   deb.exercicio          = :exercicio
 and   deb.tipocadastro       = :tipoCadastro
 and   deb.cadastrogeral      = :cadastroGeral
 and   deb.constituido        = 'S'
 and   fpag.disponivelweb     = 'S'
 and   fpag.vencimento       >= :dataVencimento
 and   sit.tiposituacaoparcela = 1
 and   cg.exclusaologica      = 'N'
 and
 ( (fp.tipoformapagamento <> 'U' AND EXISTS(select 1
                   from tribdebitoparcela parsub
                   inner join tribsituacaoparcela sitsub
                      on sitsub.situacaoparcela     = parsub.situacaodebito
                   inner join tribtiposituacaoparcela tipsub on sitsub.tiposituacaoparcela = tipsub.tiposituacaoparcela
                   where parsub.entidade            = deb.entidade
                   and   parsub.exercicio           = deb.exercicio
                   and   parsub.tipocadastro        = deb.tipocadastro
                   and   parsub.cadastrogeral       = deb.cadastrogeral
                   and   parsub.guiarecolhimento    = deb.guiarecolhimento
                   and   parsub.subdivida           = deb.subdivida
                   and   parsub.datavencimento     >= :dataVencimento
                   and   tipsub.tipo = 'A'))
 or
   (fp.tipoformapagamento = 'U'
    and not exists (select 1
                   from tribdebitoparcela parsub
                   inner join tribsituacaoparcela sitsub
                      on sitsub.situacaoparcela     = parsub.situacaodebito
                   inner join tribtiposituacaoparcela tipsub on sitsub.tiposituacaoparcela = tipsub.tiposituacaoparcela
                   where parsub.entidade            = deb.entidade
                   and   parsub.exercicio           = deb.exercicio
                   and   parsub.tipocadastro        = deb.tipocadastro
                   and   parsub.cadastrogeral       = deb.cadastrogeral
                   and   parsub.guiarecolhimento    = deb.guiarecolhimento
                   and   parsub.subdivida           = deb.subdivida
                   and   tipsub.tipo <> 'A')
 ))