SELECT CADASTRO.IDKEY AS IDCADASTRO,
       ENDERECO.PESSOANOME AS PESSOANOME,
       ENDERECO.TIPOCADASTRO AS TIPOCADASTRO,
       ENDERECO.CADASTROGERAL AS CADASTROGERAL,
       ENDERECO.CEP,
       ENDERECO.NUMERO,
       ENDERECO.CIDADE,
       ENDERECO.UNIDADEFEDERACAO AS UNIDADEFEDERACAO,
       ENDERECO.QUADRA,
       ENDERECO.LOTE,
       ENDERECO.BAIRRO,
       ENDERECO.LOGRADOURO,
       ENDERECO.TIPOLOGRADOURO AS TIPOLOGRADOURO,
       ENDERECO.SETOR,
       ENDERECO.ENDERECOCOMPLETO AS ENDERECOCOMPLETO,
       PESSOA.CNPJ_CPF AS CNPJCPF,
       COALESCE(
           (SELECT 1
            FROM TRIBCADASTROGERAL GERAL
            WHERE GERAL.TIPOCADASTRO = ENDERECO.TIPOCADASTRO
              AND GERAL.CADASTROGERAL = ENDERECO.CADASTROGERAL
              AND EXISTS(SELECT 1
                         FROM TRIBDEBITO DEB
                         INNER JOIN TRIBCADASTROGERAL CG ON DEB.CADASTROGERAL = CG.CADASTROGERAL
                         INNER JOIN TRIBDEBITOPARCELA PAR ON DEB.ENTIDADE = PAR.ENTIDADE
                                                         AND DEB.EXERCICIO = PAR.EXERCICIO
                                                         AND DEB.TIPOCADASTRO = PAR.TIPOCADASTRO
                                                         AND DEB.CADASTROGERAL = PAR.CADASTROGERAL
                                                         AND DEB.GUIARECOLHIMENTO = PAR.GUIARECOLHIMENTO
                                                         AND DEB.SUBDIVIDA = PAR.SUBDIVIDA
                         INNER JOIN TRIBSITUACAOPARCELA SIT ON PAR.SITUACAODEBITO = SIT.SITUACAOPARCELA
                         INNER JOIN TRIBTIPOSITUACAOPARCELA TIP ON SIT.SITUACAOPARCELA = TIP.TIPOSITUACAOPARCELA
                         WHERE DEB.TIPOCADASTRO = GERAL.TIPOCADASTRO
                           AND DEB.CADASTROGERAL = GERAL.CADASTROGERAL
                           AND DEB.CONSTITUIDO = 'S'
                           AND TIP.TIPOSITUACAOPARCELA = 1
                           AND PAR.DATAVENCIMENTO < CURRENT_DATE)), 0
        ) AS VENCIDO
FROM ENDERECOCADASTROGERAL ENDERECO
LEFT OUTER JOIN TRIBCADASTROGERAL CADASTRO ON CADASTRO.CADASTROGERAL = ENDERECO.CADASTROGERAL
                                          AND CADASTRO.TIPOCADASTRO = ENDERECO.TIPOCADASTRO
LEFT OUTER JOIN PESSOA ON CADASTRO.PESSOA = PESSOA.PESSOA
WHERE CADASTRO.EXCLUSAOLOGICA = 'N'
      $[FILTROS]
