select cg.idkey as id,
       ende.pessoanome as pessoanome,
       ende.tipocadastro as tipocadastro,
       tc.descricao as tipocadastrodescricao,
       ende.cadastrogeral as cadastrogeral,
       ende.cep,
       ende.numero,
       ende.cidade,
       ende.unidadefederacao as unidadefederacao,
       ende.quadra,
       ende.lote,
       ende.bairro,
       ende.logradouro,
       ende.tipologradouro as tipologradouro,
       ende.setor,
       ende.enderecocompleto as enderecocompleto,
       pessoaCadastro.cnpj_cpf as cnpjcpf,
       case when pessoaCadastro.cnpj_cpf = :cpfCnpj
            then pessoaCadastro.pessoa
            else pessoaProprietario.pessoa
       end as codigoPessoa,
       coalesce((select 1
                  from tribcadastrogeral geral
                 where geral.tipocadastro = ende.tipocadastro
                   and geral.cadastrogeral = ende.cadastrogeral
                   and exists (select 1
                                 from tribdebito deb
                                inner join tribcadastrogeral cg on deb.cadastrogeral = cg.cadastrogeral
                                inner join tribdebitoparcela par on deb.entidade = par.entidade
                                                         and deb.exercicio = par.exercicio
                                                         and deb.tipocadastro = par.tipocadastro
                                                         and deb.cadastrogeral = par.cadastrogeral
                                                         and deb.guiarecolhimento = par.guiarecolhimento
                                                         and deb.subdivida = par.subdivida
                                inner join tribsituacaoparcela sit on par.situacaodebito = sit.situacaoparcela
                                inner join tribtiposituacaoparcela tip on sit.situacaoparcela = tip.tiposituacaoparcela
                                where deb.tipocadastro = geral.tipocadastro
                                  and deb.cadastrogeral = geral.cadastrogeral
                                  and deb.constituido = 'S'
                                  and tip.tiposituacaoparcela = 1
                                  and par.datavencimento < current_date)), 0) as vencido
  from tribproprietario p
 inner join tribcadastrogeral cg on cg.idkey = p.tribcadastrogeral_idkey
 inner join tribtipocadastro tc on tc.tipocadastro = cg.tipocadastro
 left outer join enderecocadastrogeral ende on cg.cadastrogeral = ende.cadastrogeral
                                           and cg.tipocadastro = ende.tipocadastro
 left outer join pessoa pessoaProprietario on pessoaProprietario.pessoa = p.pessoa
 inner join pessoa pessoaCadastro on pessoaCadastro.pessoa = cg.pessoa
 where cg.exclusaologica = 'N'
   and (pessoaCadastro.cnpj_cpf = :cpfCnpj or pessoaProprietario.cnpj_cpf = :cpfCnpj)
 order by cg.tipocadastro, cg.cadastrogeral
