SELECT TCSP.PESSOA,
       0 AS RESPONSAVEL,
       P.CNPJ_CPF AS CNPJCPF, P.NOME
FROM TRIBCONTRATOSOCIALPESSOA TCSP
JOIN PESSOA P ON P.PESSOA = TCSP.PESSOA
JOIN TRIBCADASTROGERAL CG ON TCSP.CADASTROGERAL = CG.CADASTROGERAL
  			             AND TCSP.TIPOCADASTRO = CG.TIPOCADASTRO
WHERE TCSP.TIPOCADASTRO = :tipoCadastro
  AND TCSP.CADASTROGERAL = :cadastroGeral
  AND CG.PESSOA <> TCSP.PESSOA
  AND CG.EXCLUSAOLOGICA = 'N'
UNION
SELECT TCG.PESSOA,
       1 AS RESPONSAVEL,
       P.CNPJ_CPF AS CNPJCPF, P.NOME
FROM TRIBCADASTROMOBILIARIO TCM
LEFT JOIN TRIBCADASTROGERAL TCG ON (TCG.TIPOCADASTRO = TCM.TIPOCADASTRO
                               AND TCG.CADASTROGERAL = TCM.CADASTROGERAL)
JOIN PESSOA P ON P.PESSOA = TCG.PESSOA
WHERE TCM.TIPOCADASTRO = :tipoCadastro
  AND TCM.CADASTROGERAL = :cadastroGeral
  AND TCG.EXCLUSAOLOGICA = 'N'