/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.validator;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.validation.CustomValidator;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioSegmento;
import br.com.elotech.tributos.service.ParametroGeralService;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
public class ImobiliarioSegmentoValidator
implements CustomValidator<CadastroImobiliario> {
    private final ParametroGeralService parametroGeralService;

    public ImobiliarioSegmentoValidator(ParametroGeralService parametroGeralService) {
        this.parametroGeralService = parametroGeralService;
    }

    public boolean supports(Class<?> clazz) {
        return CadastroImobiliario.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        CadastroImobiliario cadastroImobiliario = (CadastroImobiliario)target;
        this.validaBoletinsDoSegmentoImobiliario(errors, cadastroImobiliario.getCadastroImobiliarioSegmentos());
        if (cadastroImobiliario.getTipoImovel().isPredial().booleanValue()) {
            this.validaTipoImovelPredial(errors, cadastroImobiliario);
        } else if (cadastroImobiliario.getTipoImovel().isTerritorial().booleanValue()) {
            this.validaTipoImovelTerritorial(errors, cadastroImobiliario);
        }
    }

    private void validaBoletinsDoSegmentoImobiliario(Errors errors, List<CadastroImobiliarioSegmento> segmentos) {
        if (this.validaSegmentoImobiliario()) {
            segmentos.stream().filter(segmento -> segmento.getBoletinsImobiliarioSegmento().isEmpty()).forEachOrdered(segmento -> this.validaSegmentoSemBoletim(segmento, errors));
        }
    }

    private void validaSegmentoSemBoletim(CadastroImobiliarioSegmento segmento, Errors errors) {
        errors.reject("Segmento sem respostas", "\u00c9 necess\u00e1rio cadastrar as respostas para o segmento " + segmento.getIdSegmentoImobiliario());
    }

    private void validaTipoImovelPredial(Errors errors, CadastroImobiliario cadastroImobiliario) {
        if (this.utilizaSituacaoSegmentoImob() && !this.existsSegmentoLancaImpostoTrue(cadastroImobiliario)) {
            errors.reject("Segmento Lan\u00e7a False", "Para tipo im\u00f3vel predial \u00e9 necess\u00e1rio possuir pelo menos 1 segmento com status Lan\u00e7a.");
            return;
        }
        if (cadastroImobiliario.getCadastroImobiliarioSegmentos().isEmpty()) {
            errors.reject("Segmento not found", "\u00c9 necess\u00e1rio cadastrar o(s) segmento(s) do terreno.");
        }
    }

    private void validaTipoImovelTerritorial(Errors errors, CadastroImobiliario cadastroImobiliario) {
        if (this.utilizaSituacaoSegmentoImob() && this.existsSegmentoLancaImpostoTrue(cadastroImobiliario)) {
            errors.reject("Segmento Lan\u00e7a Imposto Territorial", "Para tipo im\u00f3vel territorial \u00e9 necess\u00e1rio n\u00e3o possuir segmentos, ou o status deles ser igual \u00e1 N\u00e3o Lan\u00e7a.");
            return;
        }
        if (!cadastroImobiliario.getCadastroImobiliarioSegmentos().isEmpty()) {
            errors.reject("Segmento Null", "N\u00e3o \u00e9 poss\u00edvel modificar para territorial pois o cadastro possui segmentos.");
        }
    }

    private boolean existsSegmentoLancaImpostoTrue(CadastroImobiliario cadastroImobiliario) {
        return cadastroImobiliario.getCadastroImobiliarioSegmentos().stream().anyMatch(segmento -> segmento.getSituacaoSegmento().getLancaImposto());
    }

    private boolean utilizaSituacaoSegmentoImob() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.UTILIZA_SITUACAO_SEGMENTO_IMOB, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    private boolean validaSegmentoImobiliario() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.VALIDA_SEGMENTO_IMOBILIARIO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }
}

