/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.validator;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.validation.CustomValidator;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.SituacaoCondominio;
import br.com.elotech.tributos.domain.TipoCondominio;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioTestada;
import br.com.elotech.tributos.service.ParametroGeralService;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
public class CondominioValidator
implements CustomValidator<CadastroImobiliario> {
    private static final String MSG_SITUACAO_DESMEMBRADO = "Quando o condom\u00ednio for do tipo Horizontal ou Vertical, o valor 'Usado para c\u00e1lculo' dos logradouros s\u00f3 pode receber sim em apenas um logradouro.";
    private static final String MSG_SITUACAO_NAO_DESMEMBRADO = "Quando o condom\u00ednio n\u00e3o for desmembrado ou o tipo for Outros, o valor de 'Usado para c\u00e1lculo' dos logradouros s\u00f3 pode receber sim.";
    private final ParametroGeralService parametroGeralService;

    public CondominioValidator(ParametroGeralService parametroGeralService) {
        this.parametroGeralService = parametroGeralService;
    }

    public boolean supports(Class<?> clazz) {
        return CadastroImobiliario.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        if (this.validaCondominio()) {
            CadastroImobiliario cadastroImobiliario = (CadastroImobiliario)target;
            TipoCondominio tipoCondominio = cadastroImobiliario.getCondominio().getTipoCondominio();
            SituacaoCondominio situacaoCondominio = cadastroImobiliario.getCondominio().getSituacaoCondominio();
            if (this.existsTestadaUtilizaParaCalculoFalse(cadastroImobiliario.getCadastroImobiliarioTestadas())) {
                this.validaSituacaoCondominioNaoDesmembrado(tipoCondominio, situacaoCondominio, errors);
            }
            if (this.existisManyTestadasUtilizaParaCalculoTrue(cadastroImobiliario.getCadastroImobiliarioTestadas())) {
                this.validaSituacaoCondominioDesmembrado(tipoCondominio, situacaoCondominio, errors);
            }
        }
    }

    private boolean existisManyTestadasUtilizaParaCalculoTrue(List<CadastroImobiliarioTestada> testadas) {
        return testadas.stream().filter(testada -> testada.getUtilizaParaCalculo().equals(true)).count() > 1L;
    }

    private boolean existsTestadaUtilizaParaCalculoFalse(List<CadastroImobiliarioTestada> testadas) {
        return testadas.stream().anyMatch(testada -> testada.getUtilizaParaCalculo() == false);
    }

    private void validaSituacaoCondominioNaoDesmembrado(TipoCondominio tipo, SituacaoCondominio situacao, Errors errors) {
        if (situacao.isNaoDesmembrado().booleanValue() || tipo.isOutros().booleanValue()) {
            errors.reject("Situa\u00e7\u00e3o Condom\u00ednio N\u00e3o Desmembrado", MSG_SITUACAO_NAO_DESMEMBRADO);
        }
    }

    private void validaSituacaoCondominioDesmembrado(TipoCondominio tipoCondominio, SituacaoCondominio situacao, Errors errors) {
        if (situacao.isDesmembrado().booleanValue() && tipoCondominio.isVerticalOrHorizontal().booleanValue()) {
            errors.reject("Situa\u00e7\u00e3o Condom\u00ednio Desmembrado", MSG_SITUACAO_DESMEMBRADO);
        }
    }

    private boolean validaCondominio() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.VALIDA_CONDOMINIO_CADASTRO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }
}

