/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.validator;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.validation.CustomValidator;
import br.com.elotech.tributos.domain.CadastroGeralIsencao;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.service.ParametroGeralService;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
public class CadastroGeralIsencaoValidator
implements CustomValidator<CadastroImobiliario> {
    private static final long ISENCAO_PADRAO = 0L;
    private final ParametroGeralService parametroGeralService;

    public CadastroGeralIsencaoValidator(ParametroGeralService parametroGeralService) {
        this.parametroGeralService = parametroGeralService;
    }

    public boolean supports(Class<?> clazz) {
        return CadastroImobiliario.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        if (this.validaIsencaoImobiliario().booleanValue()) {
            CadastroImobiliario cadastroImobiliario = (CadastroImobiliario)target;
            List isencoes = cadastroImobiliario.getCadastroGeralIsencoes();
            if (isencoes.isEmpty()) {
                errors.reject("Isen\u00e7\u00f5es empty", "\u00c9 necess\u00e1rio informar ao menos uma isen\u00e7\u00e3o.");
            } else if (this.containIsencaoPadraoOnList(isencoes)) {
                errors.reject("Isen\u00e7\u00f5es contain padr\u00e3o", "Retire a isen\u00e7\u00e3o padr\u00e3o do Cadastro Imobili\u00e1rio.");
            }
        }
    }

    private boolean containIsencaoPadraoOnList(List<CadastroGeralIsencao> isencoes) {
        return !isencoes.isEmpty() && isencoes.stream().anyMatch(isencao -> isencao.getIsencao().getId().equals(0L));
    }

    private Boolean validaIsencaoImobiliario() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.VALIDA_ISENCAO_IMOBILIARIO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }
}

