/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.validator;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.validation.CustomValidator;
import br.com.elotech.tributos.domain.Modelo;
import br.com.elotech.tributos.domain.ModeloCampo;
import br.com.elotech.tributos.domain.ModeloGrupo;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.imobiliario.BoletimImobiliarioTerreno;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.repository.ModeloRespostaRepository;
import br.com.elotech.tributos.service.ParametroGeralService;
import java.util.Objects;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
public class BoletimImobiliarioTerrenoValidator
implements CustomValidator<CadastroImobiliario> {
    private final ModeloRespostaRepository modeloRespostaRepository;
    private final ParametroGeralService parametroGeralService;

    public BoletimImobiliarioTerrenoValidator(ParametroGeralService parametroGeralService, ModeloRespostaRepository modeloRespostaRepository) {
        this.parametroGeralService = parametroGeralService;
        this.modeloRespostaRepository = modeloRespostaRepository;
    }

    public boolean supports(Class<?> clazz) {
        return CadastroImobiliario.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        CadastroImobiliario cadastroImobiliario = (CadastroImobiliario)target;
        if (this.paramsAreaCondominioTrue(cadastroImobiliario) && Objects.nonNull(cadastroImobiliario.getCondominio()) && this.valorAreasDiferentes(cadastroImobiliario)) {
            errors.reject("\u00c1reas diferentes", "A soma de \u00c1rea Privativa e \u00c1rea Comum deve ser igual ao valor informado como \u00c1rea \u00datil");
        }
    }

    private boolean validaParametrosAreaCondominio(BoletimImobiliarioTerreno terreno) {
        Modelo modelo = this.modeloRespostaRepository.findModelo(terreno.getModeloResposta().getId());
        ModeloGrupo modeloGrupo = this.modeloRespostaRepository.findModeloGrupo(terreno.getModeloResposta().getId());
        ModeloCampo modeloCampo = this.modeloRespostaRepository.findModeloCampo(terreno.getModeloResposta().getId());
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.VALIDA_AREA_CONDOMINIO, ModuloEnum.MODULO_TRIBUTARIO.getValue()) != false && this.parametroGeralService.getParamValueAsLong(ParametroGeralEnum.VALIDA_AREA_CONDOMINIO_MODELO, ModuloEnum.MODULO_TRIBUTARIO.getValue()) == modelo.getId() && this.parametroGeralService.getParamValueAsLong(ParametroGeralEnum.VALIDA_AREA_CONDOMINIO_GRUPO, ModuloEnum.MODULO_TRIBUTARIO.getValue()) == modeloGrupo.getModeloGrupo() && this.parametroGeralService.getParamValueAsLong(ParametroGeralEnum.VALIDA_AREA_CONDOMINIO_CAMPO, ModuloEnum.MODULO_TRIBUTARIO.getValue()) == modeloCampo.getModeloCampo() && this.parametroGeralService.getParamValueAsLong(ParametroGeralEnum.VALIDA_AREA_CONDOMINIO_RESPOSTA, ModuloEnum.MODULO_TRIBUTARIO.getValue()) == terreno.getModeloResposta().getModeloResposta();
    }

    private boolean paramsAreaCondominioTrue(CadastroImobiliario cadastroImobiliario) {
        return cadastroImobiliario.getBoletinsImobiliarioTerreno().stream().anyMatch(arg_0 -> this.validaParametrosAreaCondominio(arg_0));
    }

    private boolean valorAreasDiferentes(CadastroImobiliario cadastroImobiliario) {
        return !cadastroImobiliario.getAreaPrivativa().add(cadastroImobiliario.getAreaComum()).equals(cadastroImobiliario.getAreaUtilLote());
    }
}

