/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.util;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class RsqlOperatorValueDTO {
    private String operator;
    private String value;

    public static Optional<RsqlOperatorValueDTO> from(String rsql, String field) {
        Pattern pattern = Pattern.compile(field + "(==|!=)(\\w*)");
        Matcher matcher = pattern.matcher(rsql);
        if (matcher.find()) {
            RsqlOperatorValueDTO dto = new RsqlOperatorValueDTO();
            dto.setOperator(matcher.group(1));
            dto.setValue(matcher.group(2));
            return Optional.of(dto);
        }
        return Optional.empty();
    }

    public String getOperadorSql() {
        if (StringUtils.isBlank((CharSequence)this.operator)) {
            return null;
        }
        return "==".equals(this.operator) ? "=" : "<>";
    }

    @Generated
    public RsqlOperatorValueDTO() {
    }

    @Generated
    public String getOperator() {
        return this.operator;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public void setOperator(String operator) {
        this.operator = operator;
    }

    @Generated
    public void setValue(String value) {
        this.value = value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RsqlOperatorValueDTO)) {
            return false;
        }
        RsqlOperatorValueDTO other = (RsqlOperatorValueDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$operator = this.getOperator();
        String other$operator = other.getOperator();
        if (this$operator == null ? other$operator != null : !this$operator.equals(other$operator)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RsqlOperatorValueDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $operator = this.getOperator();
        result = result * 59 + ($operator == null ? 43 : $operator.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RsqlOperatorValueDTO(operator=" + this.getOperator() + ", value=" + this.getValue() + ")";
    }
}

