/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.ws.rest;

import br.com.elotech.tributos.config.TributosProperties;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ws.AiseLoginService;
import br.com.elotech.tributos.ws.domain.LoginEnvioRest;
import br.com.elotech.tributos.ws.domain.LoginRespostaRest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
@CacheConfig(cacheNames={"loginRest"})
public class AiseLoginServiceRest
implements AiseLoginService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AiseLoginServiceRest.class);
    private final RestTemplate restTemplate;
    private final TributosProperties tributosProperties;

    public AiseLoginServiceRest(RestTemplate restTemplate, TributosProperties tributosProperties) {
        this.restTemplate = restTemplate;
        this.tributosProperties = tributosProperties;
    }

    @Cacheable(key="#root.methodName")
    public LoginRespostaRest login() {
        LOGGER.info("Efetuando login no webservice do Delphi");
        LoginEnvioRest loginEnvio = new LoginEnvioRest(this.tributosProperties.getAise().getUsername(), this.tributosProperties.getAise().getPassword());
        return (LoginRespostaRest)this.restTemplate.postForObject(this.tributosProperties.getAise().getBaseUrl() + "/datasnap/rest/tauth/login", (Object)loginEnvio, LoginRespostaRest.class, new Object[0]);
    }

    @Cacheable(key="#root.methodName")
    public HttpHeaders getHttpAuthorizationHeaders() {
        LoginRespostaRest loginResposta = this.login();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + loginResposta.getIdToken());
        headers.set("usuario-aise", SecurityUtils.getUserAise());
        return headers;
    }
}

