/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.ws.rest;

import br.com.elotech.tributos.config.HttpEntityFactory;
import br.com.elotech.tributos.config.TributosProperties;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.ValoresAvaliacaoImobiliarioDTO;
import br.com.elotech.tributos.params.ImobiliarioSegmentoParams;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.exception.CadastroNaoEncontradoException;
import br.com.elotech.tributos.service.ws.AiseImobiliarioAvaliacaoService;
import br.com.elotech.tributos.service.ws.rest.AiseLoginServiceRest;
import br.com.elotech.tributos.ws.domain.LoginRespostaRest;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class AiseImobiliarioAvaliacaoServiceRest
implements AiseImobiliarioAvaliacaoService {
    private final AiseLoginServiceRest aiseLoginServiceRest;
    private final CadastroGeralService cadastroGeralService;
    private final RestTemplate restTemplate;
    private final TributosProperties tributosProperties;

    public AiseImobiliarioAvaliacaoServiceRest(AiseLoginServiceRest aiseLoginServiceRest, CadastroGeralService cadastroGeralService, RestTemplate restTemplate, TributosProperties tributosProperties) {
        this.aiseLoginServiceRest = aiseLoginServiceRest;
        this.cadastroGeralService = cadastroGeralService;
        this.restTemplate = restTemplate;
        this.tributosProperties = tributosProperties;
    }

    public ValoresAvaliacaoImobiliarioDTO calcularValoresAvaliacao(Long tipoCadastro, Long cadastroGeral) {
        return this.cadastroGeralService.findByTipoCadastroAndCadastroGeral(TipoCadastro.fromValue((Long)tipoCadastro), cadastroGeral).map(cadastro -> this.getValoresItbiAise(tipoCadastro, cadastroGeral)).orElseThrow(() -> new CadastroNaoEncontradoException(TipoCadastro.fromValue((Long)tipoCadastro), cadastroGeral));
    }

    private ValoresAvaliacaoImobiliarioDTO getValoresItbiAise(Long tipoCadastro, Long cadastroGeral) {
        LoginRespostaRest loginResposta = this.aiseLoginServiceRest.login();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + loginResposta.getIdToken());
        return (ValoresAvaliacaoImobiliarioDTO)this.restTemplate.exchange(String.format("%s/datasnap/rest/timobiliario/calcularvaloresavaliacao/%d/%d", this.tributosProperties.getAise().getBaseUrl(), tipoCadastro, cadastroGeral), HttpMethod.GET, HttpEntityFactory.createHttpEntity((Object)"", (HttpHeaders)headers), ValoresAvaliacaoImobiliarioDTO.class, new Object[0]).getBody();
    }

    public ValoresAvaliacaoImobiliarioDTO calcularValoresSegmento(ImobiliarioSegmentoParams segmento) {
        LoginRespostaRest loginResposta = this.aiseLoginServiceRest.login();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + loginResposta.getIdToken());
        return (ValoresAvaliacaoImobiliarioDTO)this.restTemplate.exchange(String.format("%s/datasnap/rest/timobiliario/calcularvaloressegmento", this.tributosProperties.getAise().getBaseUrl()), HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)segmento, (HttpHeaders)headers), ValoresAvaliacaoImobiliarioDTO.class, new Object[0]).getBody();
    }
}

