/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.ws.rest;

import br.com.elotech.tributos.config.HttpEntityFactory;
import br.com.elotech.tributos.config.TributosProperties;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DividaFormaPagamento;
import br.com.elotech.tributos.dto.DebitoBloquetoMobileDTO;
import br.com.elotech.tributos.dto.DebitoDTO;
import br.com.elotech.tributos.dto.GeraBoletoCotaUnicaDTO;
import br.com.elotech.tributos.dto.GeraBoletoPorFormaPagamentoDTO;
import br.com.elotech.tributos.exception.GeraBloquetoException;
import br.com.elotech.tributos.repository.BoletoRepository;
import br.com.elotech.tributos.repository.DebitoRepository;
import br.com.elotech.tributos.service.AiseBloquetoService;
import br.com.elotech.tributos.service.exception.DebitoNotFoundException;
import br.com.elotech.tributos.service.exception.DividaFormaPagamentoException;
import br.com.elotech.tributos.service.mobile.DebitoMobileService;
import br.com.elotech.tributos.service.ws.AisePdfService;
import br.com.elotech.tributos.service.ws.rest.AiseLoginServiceRest;
import br.com.elotech.tributos.ws.domain.LoginRespostaRest;
import br.com.elotech.tributos.ws.mapper.AiseWSMapper;
import br.com.elotech.tributos.ws.rest.dto.BloquetoDTO;
import br.com.elotech.tributos.ws.rest.dto.DebitoItbiDTO;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class AiseBloquetoServiceRest
implements AiseBloquetoService {
    private final RestTemplate restTemplate;
    private final AiseLoginServiceRest aiseLoginServiceRest;
    private final AiseWSMapper aiseWSMapper;
    private final DebitoMobileService debitoMobileService;
    private final AisePdfService aisePdfService;
    private final BoletoRepository bloquetoRepository;
    private final String urlGeracaoBoleto;
    private final String urlGeracaoBoletoCotaUnica;
    private final DebitoRepository debitoRepository;

    public AiseBloquetoServiceRest(RestTemplate restTemplate, AiseLoginServiceRest aiseLoginServiceRest, TributosProperties tributosProperties, AiseWSMapper aiseWSMapper, DebitoMobileService debitoMobileService, AisePdfService aisePdfService, BoletoRepository bloquetoRepository, DebitoRepository debitoRepository) {
        this.restTemplate = restTemplate;
        this.aiseLoginServiceRest = aiseLoginServiceRest;
        this.aiseWSMapper = aiseWSMapper;
        this.debitoMobileService = debitoMobileService;
        this.aisePdfService = aisePdfService;
        this.bloquetoRepository = bloquetoRepository;
        this.debitoRepository = debitoRepository;
        this.urlGeracaoBoleto = tributosProperties.getAise().getBaseUrl() + "/datasnap/rest/tbloquetos/gerar/";
        this.urlGeracaoBoletoCotaUnica = tributosProperties.getAise().getBaseUrl() + "/datasnap/rest/tbloquetos/gerarBloquetoCotaUnica/";
    }

    public BloquetoDTO geraBloqueto(List<DebitoDTO> debitosMarcados) {
        String debitosDelphi;
        LoginRespostaRest loginResposta = this.aiseLoginServiceRest.login();
        HttpHeaders headers = this.getHttpHeaders(loginResposta);
        try {
            debitosDelphi = this.aiseWSMapper.toEnvioRest(debitosMarcados);
        }
        catch (JsonProcessingException e) {
            throw new GeraBloquetoException(HttpStatus.BAD_REQUEST, "Erro ao gerar boleto", (Exception)((Object)e));
        }
        ResponseEntity response = this.geraDebitoAise(headers, debitosDelphi);
        BloquetoDTO bloquetoDTO = (BloquetoDTO)response.getBody();
        bloquetoDTO.setUrlImpressao(this.getUrlImpressao(bloquetoDTO.getBloqueto()));
        return bloquetoDTO;
    }

    private String getUrlImpressao(Long bloqueto) {
        return this.aisePdfService.fetchBloqueto(bloqueto);
    }

    public BloquetoDTO geraBloquetoPorListaDebito(List<DebitoBloquetoMobileDTO> debitosSelecionados) {
        String debitosDelphi;
        LoginRespostaRest loginResposta = this.aiseLoginServiceRest.login();
        HttpHeaders headers = this.getHttpHeaders(loginResposta);
        List debitos = this.debitoMobileService.getDebitoBloquetoPorListaDebito(debitosSelecionados);
        try {
            debitosDelphi = this.aiseWSMapper.toEnvioRest(debitos);
        }
        catch (JsonProcessingException e) {
            throw new GeraBloquetoException(HttpStatus.BAD_REQUEST, "Erro ao gerar boleto por lista", (Exception)((Object)e));
        }
        ResponseEntity response = this.restTemplate.exchange(this.urlGeracaoBoleto, HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)debitosDelphi, (HttpHeaders)headers), BloquetoDTO.class, new Object[0]);
        BloquetoDTO bloquetoDTO = (BloquetoDTO)response.getBody();
        bloquetoDTO.setUrlImpressao(this.getUrlImpressao(bloquetoDTO.getBloqueto()));
        Bloqueto bloqueto = this.bloquetoRepository.findByBloqueto(bloquetoDTO.getEntidade(), bloquetoDTO.getExercicioBloqueto(), bloquetoDTO.getBloqueto());
        bloquetoDTO.setId(bloqueto.getId());
        bloquetoDTO.setCodigoValidacao(bloqueto.getCodigoValidacao());
        return bloquetoDTO;
    }

    private HttpHeaders getHttpHeaders(LoginRespostaRest loginResposta) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + loginResposta.getIdToken());
        return headers;
    }

    public BloquetoDTO geraBloquetoPorDataPagamento(List<DebitoDTO> debitosMarcados, LocalDate dataPagamento) {
        String debitosDelphi;
        LoginRespostaRest loginResposta = this.aiseLoginServiceRest.login();
        HttpHeaders headers = this.getHttpHeaders(loginResposta);
        try {
            debitosDelphi = this.aiseWSMapper.toEnvioRest(debitosMarcados, dataPagamento);
        }
        catch (JsonProcessingException e) {
            throw new GeraBloquetoException(HttpStatus.BAD_REQUEST, "Erro ao gerar boleto por data de pagamento", (Exception)((Object)e));
        }
        ResponseEntity response = this.geraDebitoAise(headers, debitosDelphi);
        BloquetoDTO bloquetoDTO = (BloquetoDTO)response.getBody();
        bloquetoDTO.setUrlImpressao(this.getUrlImpressao(bloquetoDTO.getBloqueto()));
        return bloquetoDTO;
    }

    private ResponseEntity<BloquetoDTO> geraDebitoAise(HttpHeaders headers, String debitosDelphi) {
        return this.restTemplate.exchange(this.urlGeracaoBoleto, HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)debitosDelphi, (HttpHeaders)headers), BloquetoDTO.class, new Object[0]);
    }

    public BloquetoDTO geraBloquetoItbi(DebitoItbiDTO debitoItbi) {
        String debitosDelphi;
        LoginRespostaRest loginResposta = this.aiseLoginServiceRest.login();
        HttpHeaders headers = this.getHttpHeaders(loginResposta);
        DebitoBloquetoMobileDTO debitoBloqueto = new DebitoBloquetoMobileDTO();
        debitoBloqueto.setIdDebito(debitoItbi.getIdDebito());
        debitoBloqueto.setParcelas(Arrays.asList(1));
        List debitos = this.debitoMobileService.getDebitoBloquetoPorIdDebito(debitoBloqueto);
        try {
            debitosDelphi = this.aiseWSMapper.toEnvioRest(debitos, debitoItbi.getUsuario());
        }
        catch (JsonProcessingException e) {
            throw new GeraBloquetoException(HttpStatus.BAD_REQUEST, "Erro ao gerar boleto ITBI", (Exception)((Object)e));
        }
        BloquetoDTO bloquetoDTO = (BloquetoDTO)this.restTemplate.exchange(this.urlGeracaoBoleto, HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)debitosDelphi, (HttpHeaders)headers), BloquetoDTO.class, new Object[0]).getBody();
        Bloqueto bloqueto = this.bloquetoRepository.findByBloqueto(bloquetoDTO.getEntidade(), bloquetoDTO.getExercicioBloqueto(), bloquetoDTO.getBloqueto());
        bloquetoDTO.setUrlImpressao(this.aisePdfService.fetchBloquetoItbi(bloquetoDTO.getBloqueto(), debitoItbi.getIdSequencia(), debitoItbi.getTipoRelatorioBloqueto().getTipo(), debitoItbi.getRelatorioBloqueto()));
        bloquetoDTO.setId(bloqueto.getId());
        bloquetoDTO.setCodigoValidacao(bloqueto.getCodigoValidacao());
        return bloquetoDTO;
    }

    public BloquetoDTO geraBoletoPorFormaPagamento(GeraBoletoPorFormaPagamentoDTO boletoCotaFormaPagamentoDTO) {
        GeraBoletoCotaUnicaDTO geraBoletoCotaUnicaDTO = this.criaRequisicaoBoletoCotaUnica(boletoCotaFormaPagamentoDTO);
        LoginRespostaRest loginResposta = this.aiseLoginServiceRest.login();
        HttpHeaders headers = this.getHttpHeaders(loginResposta);
        ResponseEntity response = this.restTemplate.exchange(this.urlGeracaoBoletoCotaUnica, HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)geraBoletoCotaUnicaDTO, (HttpHeaders)headers), BloquetoDTO.class, new Object[0]);
        BloquetoDTO bloquetoDTO = (BloquetoDTO)response.getBody();
        bloquetoDTO.setUrlImpressao(this.getUrlImpressao(bloquetoDTO.getBloqueto()));
        return bloquetoDTO;
    }

    private GeraBoletoCotaUnicaDTO criaRequisicaoBoletoCotaUnica(GeraBoletoPorFormaPagamentoDTO boletoCotaFormaPagamentoDTO) {
        Debito debito = (Debito)this.debitoRepository.findOne((Object)boletoCotaFormaPagamentoDTO.getIdDebito());
        if (Objects.isNull(debito)) {
            throw new DebitoNotFoundException(boletoCotaFormaPagamentoDTO.getIdDebito());
        }
        DividaFormaPagamento dividaFormaPagamento = debito.getDivida().getFormasPagamento().stream().filter(formaPagamento -> formaPagamento.getFormaPagamento().getId().equals(boletoCotaFormaPagamentoDTO.getFormaPagamento())).findFirst().orElseThrow(() -> new DividaFormaPagamentoException(debito.getDivida().getId(), boletoCotaFormaPagamentoDTO.getFormaPagamento()));
        if (Objects.isNull(dividaFormaPagamento)) {
            throw new DividaFormaPagamentoException(debito.getDivida().getDivida(), boletoCotaFormaPagamentoDTO.getFormaPagamento());
        }
        GeraBoletoCotaUnicaDTO geraBoletoCotaUnicaDTO = new GeraBoletoCotaUnicaDTO();
        geraBoletoCotaUnicaDTO.setEntidade(debito.getEntidade());
        geraBoletoCotaUnicaDTO.setExercicioDebito(debito.getExercicio());
        geraBoletoCotaUnicaDTO.setTipoCadastro(debito.getCadastroGeral().getTipoCadastro().getValue());
        geraBoletoCotaUnicaDTO.setCadastroGeral(debito.getCadastroGeral().getCadastroGeral());
        geraBoletoCotaUnicaDTO.setDivida(debito.getDivida().getDivida());
        geraBoletoCotaUnicaDTO.setSubDivida(debito.getSubDivida());
        geraBoletoCotaUnicaDTO.setFormaPagamento(boletoCotaFormaPagamentoDTO.getFormaPagamento());
        geraBoletoCotaUnicaDTO.setDataVencimento(dividaFormaPagamento.getVencimento());
        return geraBoletoCotaUnicaDTO;
    }
}

