/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.cancelamento;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.service.support.ReadOnlyService;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.DebitoTributo;
import br.com.elotech.tributos.domain.LivroParcelaTributo;
import br.com.elotech.tributos.domain.MotivoDeducao;
import br.com.elotech.tributos.domain.TipoDeducao;
import br.com.elotech.tributos.domain.TipoDeducaoEnum;
import br.com.elotech.tributos.domain.TipoEventoSituacaoParcelaEnum;
import br.com.elotech.tributos.domain.cancelamento.CancelamentoDebito;
import br.com.elotech.tributos.domain.cancelamento.CancelamentoDebitoItem;
import br.com.elotech.tributos.domain.cancelamento.CancelamentoDebitoPk;
import br.com.elotech.tributos.dto.CancelamentoDebitoTributoDTO;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.cancelamento.CancelamentoParcelasFormDTO;
import br.com.elotech.tributos.dto.cancelamento.CancelamentoTributosFormDTO;
import br.com.elotech.tributos.repository.cancelamento.CancelamentoDebitoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.DebitoObservacaoService;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.DebitoParcelaTributoService;
import br.com.elotech.tributos.service.DebitoTributoService;
import br.com.elotech.tributos.service.SituacaoParcelaService;
import br.com.elotech.tributos.service.ValidaCancelamentoDebitoService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CancelamentoDebitoService
extends ReadOnlyService<CancelamentoDebito, CancelamentoDebitoPk> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CancelamentoDebitoService.class);
    private final CancelamentoDebitoRepository cancelamentoDebitoRepository;
    private final SituacaoParcelaService situacaoParcelaService;
    private final DebitoParcelaTributoService debitoParcelasTributoService;
    private final DebitoTributoService debitoTributoService;
    private final DebitoParcelaService debitoParcelaService;
    private final DebitoObservacaoService debitoObservacaoService;
    private final ValidaCancelamentoDebitoService validaCancelamentoDebitoService;

    public CancelamentoDebitoService(CancelamentoDebitoRepository cancelamentoDebitoRepository, SituacaoParcelaService situacaoParcelaService, DebitoParcelaTributoService debitoParcelasTributoService, DebitoTributoService debitoTributoService, DebitoParcelaService debitoParcelaService, DebitoObservacaoService debitoObservacaoService, ValidaCancelamentoDebitoService validaCancelamentoDebitoService) {
        this.cancelamentoDebitoRepository = cancelamentoDebitoRepository;
        this.situacaoParcelaService = situacaoParcelaService;
        this.debitoParcelasTributoService = debitoParcelasTributoService;
        this.debitoTributoService = debitoTributoService;
        this.debitoParcelaService = debitoParcelaService;
        this.debitoObservacaoService = debitoObservacaoService;
        this.validaCancelamentoDebitoService = validaCancelamentoDebitoService;
    }

    @Transactional
    public CancelamentoDebito cancelamentoDebitoPorParcela(CancelamentoParcelasFormDTO form) {
        CancelamentoTributosFormDTO cancelamentoTributosFormDTO = CancelamentoTributosFormDTO.from((CancelamentoParcelasFormDTO)form);
        form.getParcelas().forEach(parcelaForm -> this.debitoParcelaService.findByDebitoParcela(parcelaForm.getEntidade(), parcelaForm.getExercicio(), parcelaForm.getTipoCadastro(), parcelaForm.getCadastroGeral(), parcelaForm.getDivida(), parcelaForm.getSubDivida(), parcelaForm.getParcela()).ifPresent(debitoParcela -> debitoParcela.getTributosValorMaiorQueZero().forEach(tributo -> cancelamentoTributosFormDTO.getParcelas().add(CancelamentoDebitoTributoDTO.from((DebitoParcelaTributo)tributo)))));
        return this.cancelamentoDebitoPorTributo(cancelamentoTributosFormDTO);
    }

    private void updateValoresDebito(CancelamentoDebitoTributoDTO tributo, DebitoParcelaTributo debitoParcelaTributo) {
        this.updateDebitoReceita(tributo);
        this.updateDebitoParcelaTributo(tributo, debitoParcelaTributo);
    }

    private void updateDebitoReceita(CancelamentoDebitoTributoDTO tributo) {
        DebitoTributo debitoTributo = (DebitoTributo)this.debitoTributoService.findOne((Serializable)tributo.toEntityDebitoTributo().getId());
        debitoTributo.setValorRenuncia(debitoTributo.getValorRenuncia().add(tributo.getValorCancelamento()));
        this.debitoTributoService.save((EloEntity)debitoTributo, null);
        LOGGER.info("D\u00e9bito tributo com valor ren\u00fancia, atualizado. {}", (Object)debitoTributo);
    }

    private void updateDebitoParcelaTributo(CancelamentoDebitoTributoDTO tributo, DebitoParcelaTributo debitoParcelaTributo) {
        debitoParcelaTributo.setValor(debitoParcelaTributo.getValor().subtract(tributo.getValorCancelamento()));
        this.debitoParcelasTributoService.save((EloEntity)debitoParcelaTributo, null);
        LOGGER.info("D\u00e9bito parcela com situa\u00e7\u00e3o Cancelado salvo. {}", (Object)debitoParcelaTributo);
    }

    @Transactional
    public CancelamentoDebito cancelamentoDebitoPorTributo(CancelamentoTributosFormDTO form) {
        form.setUsuario(SecurityUtils.getUserAise());
        CancelamentoDebito cancelamentoDebito = form.toEntity();
        this.validaCancelamentoDebitoService.validaCancelamento(form);
        form.getParcelas().stream().map(tributo -> {
            DebitoParcelaTributo debitoParcelaTributo = (DebitoParcelaTributo)this.debitoParcelasTributoService.findOne((Serializable)tributo.getId());
            CancelamentoDebitoItem cancelamentoDebitoItem = tributo.toEntity(cancelamentoDebito, debitoParcelaTributo);
            cancelamentoDebitoItem.setValor(tributo.getValorCancelamento());
            if (form.getPorTributo().booleanValue()) {
                this.updateValoresDebito(tributo, debitoParcelaTributo);
            }
            return cancelamentoDebitoItem;
        }).forEach(cancelamentoDebito.getItens()::add);
        Map debitoParcelas = form.getItensCanceladosByParcelas();
        debitoParcelas.forEach((debitoParcelaId, cancelamentosDebitoTributoDTO) -> this.debitoParcelaService.findById(debitoParcelaId).ifPresent(debitoParcela -> {
            if (!form.getPorTributo().booleanValue() || debitoParcela.getValorTotal().compareTo(BigDecimal.ZERO) == 0) {
                this.updateSituacaoDebito(debitoParcela, form.getTipoDeducao());
            }
        }));
        this.cancelamentoDebitoRepository.save((Object)cancelamentoDebito);
        this.addObservacaoCancelamento(cancelamentoDebito, form);
        return cancelamentoDebito;
    }

    private void updateSituacaoDebito(DebitoParcela debitoParcela, TipoDeducao tipoDeducao) {
        TipoEventoSituacaoParcelaEnum eventoBaixa = TipoDeducaoEnum.fromValue((Long)tipoDeducao.getId()).getEventoBaixa();
        debitoParcela.setSituacaoDebito(this.situacaoParcelaService.getNovaSituacaoParcela(eventoBaixa, debitoParcela.getSituacaoDebito()));
        this.debitoParcelaService.save((EloEntity)debitoParcela, null);
    }

    private void addObservacaoCancelamento(CancelamentoDebito cancelamentoDebito, CancelamentoTributosFormDTO form) {
        Map debitos = CancelamentoDebitoTributoDTO.getItensCanceladosByDebitos((List)form.getParcelas());
        debitos.forEach((debitoIdDTO, listaCancelamentoDebitoTributoDTO) -> {
            String parcelas = listaCancelamentoDebitoTributoDTO.stream().map(CancelamentoDebitoTributoDTO::getParcela).distinct().sorted().map(Object::toString).collect(Collectors.joining(","));
            this.debitoObservacaoService.save(debitoIdDTO, String.format("Cancelamento de d\u00e9bito n\u00famero %d/%d. Parcela(s) %s.", cancelamentoDebito.getId().getId(), cancelamentoDebito.getId().getExercicio(), parcelas));
        });
    }

    @Transactional
    public void cancelamentoDebitoEnglobado(LivroParcelaTributo livroParcelaTributo, DebitoIdDTO idDebito, MotivoDeducao motivoDeducao) {
        CancelamentoDebitoTributoDTO cancelamentoTributoDTO = new CancelamentoDebitoTributoDTO();
        cancelamentoTributoDTO.setId(livroParcelaTributo.getId().getDebitoParcelaTributo().getId());
        cancelamentoTributoDTO.setIdDebito(idDebito.getIdDebito());
        cancelamentoTributoDTO.setEntidade(idDebito.getEntidade());
        cancelamentoTributoDTO.setExercicio(idDebito.getExercicio());
        cancelamentoTributoDTO.setTipoCadastro(idDebito.getTipoCadastro());
        cancelamentoTributoDTO.setCadastroGeral(idDebito.getCadastroGeral());
        cancelamentoTributoDTO.setDivida(idDebito.getDivida());
        cancelamentoTributoDTO.setSubDivida(idDebito.getSubDivida());
        cancelamentoTributoDTO.setParcela(Long.valueOf(1L));
        cancelamentoTributoDTO.setTributo(livroParcelaTributo.getId().getDebitoParcelaTributo().getTributo());
        cancelamentoTributoDTO.setValorCancelamento(livroParcelaTributo.getValor().add(livroParcelaTributo.getValorJuros()).add(livroParcelaTributo.getValorCorrecao()).add(livroParcelaTributo.getValorMulta()));
        cancelamentoTributoDTO.setSituacaoLegal(livroParcelaTributo.getSituacaoLegal());
        CancelamentoTributosFormDTO form = new CancelamentoTributosFormDTO();
        form.setEntidade(idDebito.getEntidade());
        form.setExercicio(idDebito.getExercicio());
        form.setUsuario(SecurityUtils.getUserAise());
        form.setDataCancelamento(LocalDate.now());
        form.setMotivoCancelamento(motivoDeducao);
        form.setSituacaoLegal(Long.valueOf(livroParcelaTributo.getSituacaoLegal().getValue().longValue()));
        form.setTipoDeducao(motivoDeducao.getTipoDeducao());
        form.getParcelas().add(cancelamentoTributoDTO);
        form.setPorTributo(Boolean.TRUE);
        CancelamentoDebito cancelamentoDebito = form.toEntity();
        this.validaCancelamentoDebitoService.validaCancelamento(form);
        this.debitoParcelasTributoService.findByDebitoParcelaDebitoIdAndTributo(cancelamentoTributoDTO.getIdDebito(), cancelamentoTributoDTO.getTributo()).stream().map(debitoParcelaTributo -> (DebitoParcelaTributo)this.debitoParcelasTributoService.findOne((Serializable)debitoParcelaTributo.getId())).map(debitoParcelaTributo -> {
            CancelamentoDebitoItem cancelamentoDebitoItem = cancelamentoTributoDTO.toEntity(cancelamentoDebito, debitoParcelaTributo);
            cancelamentoDebitoItem.setValor(cancelamentoTributoDTO.getValorCancelamento());
            cancelamentoDebitoItem.setMotivoDesconto(motivoDeducao);
            return cancelamentoDebitoItem;
        }).forEach(cancelamentoDebito.getItens()::add);
        this.cancelamentoDebitoRepository.save((Object)cancelamentoDebito);
        this.addObservacaoCancelamento(cancelamentoDebito, form);
    }
}

