/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.ExercicioMesId;
import br.com.elotech.tributos.domain.MovimentacaoDiariaId;
import br.com.elotech.tributos.domain.exerciciomes.ExercicioMes;
import br.com.elotech.tributos.domain.exerciciomes.SituacaoExercicioMes;
import br.com.elotech.tributos.domain.movimentacaodiaria.MovimentacaoDiaria;
import br.com.elotech.tributos.domain.movimentacaodiaria.SituacaoMovimentacaoDiaria;
import br.com.elotech.tributos.service.ExercicioMesService;
import br.com.elotech.tributos.service.MovimentacaoDiariaService;
import br.com.elotech.tributos.util.DateUtils;
import java.io.Serializable;
import java.time.LocalDate;
import org.springframework.stereotype.Service;

@Service
public class ValidaDataMovimentacaoService {
    private final ExercicioMesService exercicioMesService;
    private final MovimentacaoDiariaService movimentacaoDiariaService;

    public ValidaDataMovimentacaoService(ExercicioMesService exercicioMesService, MovimentacaoDiariaService movimentacaoDiariaService) {
        this.exercicioMesService = exercicioMesService;
        this.movimentacaoDiariaService = movimentacaoDiariaService;
    }

    public void verificaMesFechadoTributacao(ExercicioMesId exercicioMesId) {
        ExercicioMes exercicioMes = (ExercicioMes)this.exercicioMesService.findById((Serializable)exercicioMesId).orElseThrow(() -> new EloValidationException(String.format("M\u00eas %s n\u00e3o encontrado no exercicio %s", exercicioMesId.getMes(), exercicioMesId.getExercicio())));
        if (!SituacaoExercicioMes.ABERTO.equals((Object)exercicioMes.getSituacao())) {
            throw new EloValidationException(String.format("O m\u00eas %s j\u00e1 foi fechado pela tributa\u00e7\u00e3o. N\u00e3o ser\u00e1 poss\u00edvel realizar a opera\u00e7\u00e3o sem antes re-abrir o m\u00eas.", exercicioMesId.getMes()));
        }
    }

    public void verificaMovimentacaoDiaria(MovimentacaoDiariaId movimentacaoDiariaId) {
        MovimentacaoDiaria movimentacaoDiaria = (MovimentacaoDiaria)this.movimentacaoDiariaService.findById((Serializable)movimentacaoDiariaId).orElseThrow(() -> new EloValidationException(String.format("Movimenta\u00e7\u00e3o da data %s n\u00e3o encontrado", DateUtils.localDateToStringFormatoBrasileiro((LocalDate)movimentacaoDiariaId.getData()))));
        if (SituacaoMovimentacaoDiaria.CONTABILIDADE.equals((Object)movimentacaoDiaria.getSituacao())) {
            throw new EloValidationException(String.format("A movimenta\u00e7\u00e3o da data %s j\u00e1 foi fechada pela contabilidade. N\u00e3o ser\u00e1 poss\u00edvel realizar a opera\u00e7\u00e3o sem antes estornar a integra\u00e7\u00e3o.", DateUtils.localDateToStringFormatoBrasileiro((LocalDate)movimentacaoDiariaId.getData())));
        }
        if (SituacaoMovimentacaoDiaria.TRIBUTACAO.equals((Object)movimentacaoDiaria.getSituacao())) {
            throw new EloValidationException(String.format("A movimenta\u00e7\u00e3o da data %s j\u00e1 foi fechada pela tributa\u00e7\u00e3o. N\u00e3o ser\u00e1 poss\u00edvel realizar a opera\u00e7\u00e3o sem antes fazer uma re-abertura.", DateUtils.localDateToStringFormatoBrasileiro((LocalDate)movimentacaoDiariaId.getData())));
        }
    }

    public void validaMesEDia(Long entidade, LocalDate data) {
        ExercicioMesId exercicioMesId = new ExercicioMesId();
        exercicioMesId.setEntidade(entidade);
        exercicioMesId.setExercicio(Long.valueOf(data.getYear()));
        exercicioMesId.setMes(Long.valueOf(data.getMonthValue()));
        this.verificaMesFechadoTributacao(exercicioMesId);
        MovimentacaoDiariaId movimentacaoDiariaId = new MovimentacaoDiariaId();
        movimentacaoDiariaId.setData(data);
        movimentacaoDiariaId.setEntidade(entidade);
        this.verificaMovimentacaoDiaria(movimentacaoDiariaId);
    }
}

