/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.DividaTributo;
import br.com.elotech.tributos.domain.OrigemEmissao;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.TipoBloqueto;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoDivida;
import br.com.elotech.tributos.domain.TipoOperacaoDebito;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalhe;
import br.com.elotech.tributos.domain.tipomensagem.TipoMensagem;
import br.com.elotech.tributos.domain.tipomensagem.TipoMensagemEnum;
import br.com.elotech.tributos.dto.BaixaAutomaticaCadastroDTO;
import br.com.elotech.tributos.dto.DebitoManualIssDTO;
import br.com.elotech.tributos.dto.DebitoManualObservacaoDTO;
import br.com.elotech.tributos.dto.DebitoManualParcelaDTO;
import br.com.elotech.tributos.dto.DebitoParcelaDTO;
import br.com.elotech.tributos.dto.GeraBoletoDTO;
import br.com.elotech.tributos.service.BaixaAutomaticaDetalheService;
import br.com.elotech.tributos.service.DividaService;
import br.com.elotech.tributos.service.GeraBoletoService;
import br.com.elotech.tributos.service.GeraDebitoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.TipoMensagemService;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.EntityManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ProcessaPagamentoLoteSuperSimplesService {
    private final BaixaAutomaticaDetalheService baixaAutomaticaDetalheService;
    private final ParametroGeralService parametroGeralService;
    private final DividaService dividaService;
    private final TipoMensagemService tipoMensagemService;
    private final GeraDebitoService geraDebitoService;
    private final GeraBoletoService geraBoletoService;
    private final EntityManager entityManager;

    public ProcessaPagamentoLoteSuperSimplesService(BaixaAutomaticaDetalheService baixaAutomaticaDetalheService, ParametroGeralService parametroGeralService, DividaService dividaService, TipoMensagemService tipoMensagemService, GeraDebitoService geraDebitoService, GeraBoletoService geraBoletoService, EntityManager entityManager) {
        this.baixaAutomaticaDetalheService = baixaAutomaticaDetalheService;
        this.parametroGeralService = parametroGeralService;
        this.dividaService = dividaService;
        this.tipoMensagemService = tipoMensagemService;
        this.geraDebitoService = geraDebitoService;
        this.geraBoletoService = geraBoletoService;
        this.entityManager = entityManager;
    }

    public BaixaAutomaticaDetalhe verificarLoteSequenciaSuperSimples(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe) {
        BaixaAutomaticaCadastroDTO cadastro = this.baixaAutomaticaDetalheService.findCadastroSuperSimples(baixaAutomaticaDetalhe.getNossoNumero());
        if (Objects.isNull(cadastro)) {
            TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.CADASTRO_MOBILIARIO_NAO_ENCONTRADO);
            baixaAutomaticaDetalhe.setSituacao(tipoMensagem.getClassificacao());
            baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
            baixaAutomaticaDetalhe.setMensagem(TipoMensagemEnum.CADASTRO_MOBILIARIO_NAO_ENCONTRADO.getDescricao());
            return baixaAutomaticaDetalhe;
        }
        Long dividaId = this.getParametroGuiaIss(TipoCadastro.fromValue((Long)cadastro.getTipoCadastro()));
        if (Objects.isNull(dividaId)) {
            TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.GUIA_NAO_ENCONTRADA);
            baixaAutomaticaDetalhe.setSituacao(tipoMensagem.getClassificacao());
            baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
            if (TipoCadastro.MOBILIARIO.getValue().equals(cadastro.getTipoCadastro())) {
                baixaAutomaticaDetalhe.setMensagem("N\u00e3o h\u00e1 parametriza\u00e7\u00e3o da D\u00edvida do ISS Super Simples - Estabelecido");
            } else if (TipoCadastro.AVULSO.getValue().equals(cadastro.getTipoCadastro())) {
                baixaAutomaticaDetalhe.setMensagem("N\u00e3o h\u00e1 parametriza\u00e7\u00e3o da D\u00edvida do ISS Super Simples - N\u00e3o Estabelecido");
            } else {
                baixaAutomaticaDetalhe.setMensagem(TipoMensagemEnum.GUIA_NAO_ENCONTRADA.getDescricao());
            }
            return baixaAutomaticaDetalhe;
        }
        if (!this.getDividaTributo(dividaId, baixaAutomaticaDetalhe).isPresent()) {
            TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.RECEITA_PADRAO_NAO_ENCONTRADA);
            baixaAutomaticaDetalhe.setSituacao(tipoMensagem.getClassificacao());
            baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
            baixaAutomaticaDetalhe.setMensagem(TipoMensagemEnum.RECEITA_PADRAO_NAO_ENCONTRADA.getDescricao());
            return baixaAutomaticaDetalhe;
        }
        TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.BOLETO_VALIDADO);
        baixaAutomaticaDetalhe.setSituacao(tipoMensagem.getClassificacao());
        baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
        baixaAutomaticaDetalhe.setMensagem(String.format("D\u00edvida %d validada com sucesso", dividaId));
        return baixaAutomaticaDetalhe;
    }

    public void gerarDebitoEBoleto(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe) {
        Optional debitoGerado = this.geraDebitoSuperSimples(baixaAutomaticaDetalhe);
        debitoGerado.ifPresent(debito -> {
            this.entityManager.flush();
            DebitoParcelaDTO debitoParcelaDTO = new DebitoParcelaDTO();
            debitoParcelaDTO.setIdDebito(debito.getId());
            debitoParcelaDTO.setParcela(debito.getNumeroParcela());
            GeraBoletoDTO geraBoletoDTO = new GeraBoletoDTO();
            geraBoletoDTO.setOrigemEmissao(OrigemEmissao.AISE);
            geraBoletoDTO.setTipoBoleto(TipoBloqueto.PARCELADO);
            geraBoletoDTO.setDebitos(Collections.singletonList(debitoParcelaDTO));
            Bloqueto boleto = (Bloqueto)this.geraBoletoService.geraBoletoSuperSimples(geraBoletoDTO).stream().findFirst().orElseThrow(() -> new IllegalStateException("Erro ao gerar boleto"));
            boleto.setUtilizaValorBloqueto(Boolean.TRUE);
            this.atualizaBaixaAutomaticaDetalhe(baixaAutomaticaDetalhe, debito, boleto);
        });
    }

    private void atualizaBaixaAutomaticaDetalhe(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe, Debito debitoGerado, Bloqueto boleto) {
        if (debitoGerado.getParcelas().size() == 1) {
            baixaAutomaticaDetalhe.setTipoOperacao(TipoOperacaoDebito.DEBITO_GERADO);
        } else {
            baixaAutomaticaDetalhe.setTipoOperacao(TipoOperacaoDebito.PARCELA_GERADA);
        }
        baixaAutomaticaDetalhe.setIdDebitoOperacao(debitoGerado.getId());
        baixaAutomaticaDetalhe.setParcelaOperacao(Long.valueOf(debitoGerado.getParcelas().size()));
        baixaAutomaticaDetalhe.setBoleto(boleto);
        baixaAutomaticaDetalhe.setValor(boleto.getValorBloqueto());
    }

    private Optional<Debito> geraDebitoSuperSimples(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe) {
        Long subDividaIssHomologado = 100L;
        BaixaAutomaticaCadastroDTO cadastro = this.baixaAutomaticaDetalheService.findCadastroSuperSimples(baixaAutomaticaDetalhe.getNossoNumero());
        Long dividaId = this.getParametroGuiaIss(TipoCadastro.fromValue((Long)cadastro.getTipoCadastro()));
        Optional dividaTributo = this.getDividaTributo(dividaId, baixaAutomaticaDetalhe);
        Long novaSubDivida = baixaAutomaticaDetalhe.getMesMovimento();
        DebitoManualIssDTO debitoManualIssDTO = new DebitoManualIssDTO();
        if (dividaTributo.isPresent()) {
            if (TipoDivida.ISS_HOMOLOGADO.equals((Object)((DividaTributo)dividaTributo.get()).getDivida().getTipoDivida())) {
                novaSubDivida = novaSubDivida + subDividaIssHomologado;
            }
            debitoManualIssDTO.setTributo((DividaTributo)dividaTributo.get());
        }
        debitoManualIssDTO.setBaixaAutomatica(Boolean.TRUE);
        debitoManualIssDTO.setExercicio(baixaAutomaticaDetalhe.getAnoMovimento());
        debitoManualIssDTO.setTipoCadastro(TipoCadastro.fromValue((Long)cadastro.getTipoCadastro()));
        debitoManualIssDTO.setCadastroGeral(cadastro.getCadastroGeral());
        debitoManualIssDTO.setDivida(dividaId);
        debitoManualIssDTO.setSubDivida(novaSubDivida);
        debitoManualIssDTO.setDataLancamento(baixaAutomaticaDetalhe.getDataPagamento());
        debitoManualIssDTO.setProgram("Baixa Autom\u00e1tica");
        DebitoManualObservacaoDTO debitoManualObservacaoDTO = DebitoManualObservacaoDTO.of((String)String.format("D\u00e9bito gerado pela baixa autom\u00e1tica de lote %d/%d sequencia %d", baixaAutomaticaDetalhe.getId().getLote(), baixaAutomaticaDetalhe.getId().getExercicio(), baixaAutomaticaDetalhe.getId().getSequenciaArquivo()));
        debitoManualIssDTO.getObservacoes().add(debitoManualObservacaoDTO);
        DebitoManualParcelaDTO debitoManualParcelaDTO = new DebitoManualParcelaDTO();
        debitoManualParcelaDTO.setDataVencimento(baixaAutomaticaDetalhe.getDataVencimento());
        debitoManualParcelaDTO.setValor(baixaAutomaticaDetalhe.getValorPago());
        debitoManualParcelaDTO.setDataSituacao(baixaAutomaticaDetalhe.getDataPagamento());
        debitoManualParcelaDTO.setMesReferencia(baixaAutomaticaDetalhe.getMesMovimento());
        debitoManualIssDTO.getParcelas().add(debitoManualParcelaDTO);
        return this.geraDebitoService.geraDebitoManualIss(debitoManualIssDTO).stream().findFirst();
    }

    private Long getParametroGuiaIss(TipoCadastro tipoCadastro) {
        if (TipoCadastro.MOBILIARIO.equals((Object)tipoCadastro)) {
            return this.parametroGeralService.getParamValueAsLong(ParametroGeralEnum.GUIA_ISS_SIMPLES_ESTABELECIDO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        }
        if (TipoCadastro.AVULSO.equals((Object)tipoCadastro)) {
            return this.parametroGeralService.getParamValueAsLong(ParametroGeralEnum.GUIA_ISS_SIMPLES_NAO_ESTABELECIDO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        }
        return null;
    }

    private Optional<DividaTributo> getDividaTributo(Long dividaId, BaixaAutomaticaDetalhe baixaAutomaticaDetalhe) {
        Long entidade = baixaAutomaticaDetalhe.getId().getEntidade();
        Long exercicio = baixaAutomaticaDetalhe.getAnoMovimento();
        Divida divida = (Divida)this.dividaService.findByEntidadeAndExercicioAndDivida(entidade, exercicio, dividaId).orElseThrow(() -> new EloValidationException(String.format("D\u00edvida %d n\u00e3o encontrada no exerc\u00edcio %d para entidade %d", dividaId, exercicio, entidade)));
        return divida.getTributos().stream().filter(DividaTributo::getReceitaPadrao).findFirst();
    }
}

