/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.BoletoDebito;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.Pagamento;
import br.com.elotech.tributos.domain.PagamentoBoleto;
import br.com.elotech.tributos.domain.PagamentoDebito;
import br.com.elotech.tributos.domain.PagamentoId;
import br.com.elotech.tributos.domain.TipoArquivoRetornoPagamento;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalhe;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalheId;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.tipomensagem.TipoMensagem;
import br.com.elotech.tributos.domain.tipomensagem.TipoMensagemEnum;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.DebitoParcelaPagamentoDTO;
import br.com.elotech.tributos.dto.FiltroPagamentoDTO;
import br.com.elotech.tributos.dto.pagamento.PagamentoDTO;
import br.com.elotech.tributos.dto.pagamento.PagamentoResumoDTO;
import br.com.elotech.tributos.repository.PagamentoRepository;
import br.com.elotech.tributos.service.BaixaAutomaticaDetalheService;
import br.com.elotech.tributos.service.BloquetoService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.PagamentoDebitoService;
import br.com.elotech.tributos.service.PagamentoService;
import br.com.elotech.tributos.service.ProcessaPagamentoLoteSiafiService;
import br.com.elotech.tributos.service.ProcessaPagamentoLoteSuperSimplesService;
import br.com.elotech.tributos.service.TipoMensagemService;
import br.com.elotech.tributos.util.UsuarioUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PagamentoService
extends CrudService<Pagamento, PagamentoId> {
    private final PagamentoRepository pagamentoRepository;
    private final ContextService contextService;
    private final DebitoParcelaService debitoParcelaService;
    private final PagamentoDebitoService pagamentoDebitoService;
    private final ProcessaPagamentoLoteSuperSimplesService processaPagamentoLoteSuperSimplesService;
    private final ProcessaPagamentoLoteSiafiService processaPagamentoLoteSiafiService;
    private final BloquetoService bloquetoService;
    private final TipoMensagemService tipoMensagemService;
    private final BaixaAutomaticaDetalheService baixaAutomaticaDetalheService;

    public PagamentoService(PagamentoRepository repository, ContextService contextService, DebitoParcelaService debitoParcelaService, PagamentoDebitoService pagamentoDebitoService, ProcessaPagamentoLoteSuperSimplesService processaPagamentoLoteSuperSimplesService, ProcessaPagamentoLoteSiafiService processaPagamentoLoteSiafiService, BloquetoService bloquetoService, TipoMensagemService tipoMensagemService, BaixaAutomaticaDetalheService baixaAutomaticaDetalheService) {
        this.pagamentoRepository = repository;
        this.contextService = contextService;
        this.debitoParcelaService = debitoParcelaService;
        this.pagamentoDebitoService = pagamentoDebitoService;
        this.processaPagamentoLoteSuperSimplesService = processaPagamentoLoteSuperSimplesService;
        this.processaPagamentoLoteSiafiService = processaPagamentoLoteSiafiService;
        this.bloquetoService = bloquetoService;
        this.tipoMensagemService = tipoMensagemService;
        this.baixaAutomaticaDetalheService = baixaAutomaticaDetalheService;
    }

    public Page<PagamentoDTO> searchPagamentoDTO(FiltroPagamentoDTO filtroPagamentoDTO, Pageable pageable) {
        return this.pagamentoRepository.findPagamentosDTO(this.contextService.getEntidadePrincipal(), filtroPagamentoDTO, pageable);
    }

    public List<Pagamento> searchPagamentos(FiltroPagamentoDTO filtroPagamentoDTO) {
        return this.pagamentoRepository.findPagamentos(this.contextService.getEntidadePrincipal(), filtroPagamentoDTO);
    }

    public PagamentoResumoDTO getPagamentoById(Long entidade, Long exercicioPagamento, Long pagamento) {
        PagamentoId id = PagamentoId.of((Long)entidade, (Long)exercicioPagamento, (Long)pagamento);
        Pagamento pagamentoEntity = (Pagamento)this.findById((Serializable)id).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o pagamento %d/%d", exercicioPagamento, pagamento)));
        return PagamentoResumoDTO.of((Pagamento)pagamentoEntity);
    }

    public List<DebitoParcelaPagamentoDTO> loadDebitoParcelaPagamento(Debito debito, Long parcela) {
        return this.pagamentoRepository.loadDebitoParcelaPagamento(debito, parcela);
    }

    public List<Pagamento> findAllById(List<PagamentoId> ids) {
        return this.pagamentoRepository.findAllById(ids);
    }

    public Boolean existePagamentoNaoEstornadoParaMesmaParcelaTributo(Pagamento pagamento, DebitoParcelaTributo debitoParcelaTributo) {
        return this.pagamentoRepository.existePagamentoNaoEstornadoParaMesmaParcelaTributo(pagamento, debitoParcelaTributo);
    }

    public Pagamento geraPagamento(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe) {
        Pagamento pagamentoSalvo = this.createPagamento(baixaAutomaticaDetalhe);
        PagamentoBoleto pagamentoBoleto = pagamentoSalvo.getPagamentoBoleto();
        this.pagarParcelas(pagamentoBoleto.getPagamentosDebito());
        pagamentoBoleto.getBoleto().setPago(Boolean.TRUE);
        return (Pagamento)this.pagamentoRepository.save((Object)pagamentoSalvo);
    }

    private BaixaAutomaticaDetalhe geraPagamentoNormal(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe) {
        baixaAutomaticaDetalhe.setPagamento(this.geraPagamento(baixaAutomaticaDetalhe));
        TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.PAGO_COM_SUCESSO);
        baixaAutomaticaDetalhe.setSituacao(tipoMensagem.getClassificacao());
        baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
        baixaAutomaticaDetalhe.setMensagemPagoComSucesso(baixaAutomaticaDetalhe.getBoleto(), baixaAutomaticaDetalhe.getPagamento());
        return (BaixaAutomaticaDetalhe)this.baixaAutomaticaDetalheService.save((EloEntity)baixaAutomaticaDetalhe, null);
    }

    public Pagamento geraPagamentoBaixaManual(PagamentoLote pagamentoLote, Bloqueto boleto) {
        Pagamento pagamentoSalvo = this.createPagamentoBaixaManual(pagamentoLote, boleto);
        PagamentoBoleto pagamentoBoleto = pagamentoSalvo.getPagamentoBoleto();
        this.pagarParcelas(pagamentoBoleto.getPagamentosDebito());
        pagamentoBoleto.getBoleto().setPago(Boolean.TRUE);
        return (Pagamento)this.pagamentoRepository.save((Object)pagamentoSalvo);
    }

    private Pagamento createPagamento(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe) {
        PagamentoLote pagamentoLote = baixaAutomaticaDetalhe.getPagamentoLote();
        PagamentoId pagamentoId = new PagamentoId();
        pagamentoId.setEntidade(baixaAutomaticaDetalhe.getId().getEntidade());
        pagamentoId.setExercicioPagamento(baixaAutomaticaDetalhe.getId().getExercicio());
        Pagamento pagamento = new Pagamento();
        pagamento.setId(pagamentoId);
        pagamento.setLote(pagamentoLote);
        pagamento.setSequenciaLote(baixaAutomaticaDetalhe.getId().getSequenciaArquivo());
        pagamento.setContaBancaria(pagamentoLote.getContaBancaria());
        pagamento.setBanco(pagamentoLote.getBanco());
        pagamento.setDataMovimento(pagamentoLote.getDataMovimento());
        pagamento.setDataPagamento(baixaAutomaticaDetalhe.getDataPagamento());
        pagamento.setDataCredito(baixaAutomaticaDetalhe.getDataCredito());
        pagamento.setDataBaixa(LocalDate.now());
        pagamento.setValorPago(baixaAutomaticaDetalhe.getValorPago());
        pagamento.setUsuario(UsuarioUtils.getUsuarioAise());
        PagamentoBoleto pagamentoBoleto = new PagamentoBoleto();
        pagamentoBoleto.setBoleto(baixaAutomaticaDetalhe.getBoleto());
        pagamentoBoleto.setPagamento(pagamento);
        pagamento.setPagamentoBoleto(pagamentoBoleto);
        Pagamento pagamentoSalvo = (Pagamento)this.pagamentoRepository.save((Object)pagamento);
        PagamentoBoleto pagamentoBoletoSalvo = pagamentoSalvo.getPagamentoBoleto();
        pagamentoBoletoSalvo.getPagamentosDebito().addAll(baixaAutomaticaDetalhe.getBoleto().getDebitos().stream().map(boletoDebito -> PagamentoDebito.from((BoletoDebito)boletoDebito, (Long)pagamentoBoletoSalvo.getId())).collect(Collectors.toList()));
        return pagamentoSalvo;
    }

    private Pagamento createPagamentoBaixaManual(PagamentoLote pagamentoLote, Bloqueto boleto) {
        PagamentoId pagamentoId = new PagamentoId();
        pagamentoId.setEntidade(boleto.getEntidade());
        pagamentoId.setExercicioPagamento(boleto.getExercicioBloqueto());
        Pagamento pagamento = new Pagamento();
        pagamento.setId(pagamentoId);
        pagamento.setLote(pagamentoLote);
        pagamento.setContaBancaria(pagamentoLote.getContaBancaria());
        pagamento.setBanco(pagamentoLote.getBanco());
        pagamento.setDataMovimento(pagamentoLote.getDataMovimento());
        pagamento.setDataPagamento(pagamentoLote.getDataMovimento());
        pagamento.setDataCredito(pagamentoLote.getDataCredito());
        pagamento.setDataBaixa(LocalDate.now());
        pagamento.setValorPago(boleto.getValorBloqueto());
        pagamento.setUsuario(UsuarioUtils.getUsuarioAise());
        PagamentoBoleto pagamentoBoleto = new PagamentoBoleto();
        pagamentoBoleto.setBoleto(boleto);
        pagamentoBoleto.setPagamento(pagamento);
        pagamento.setPagamentoBoleto(pagamentoBoleto);
        Pagamento pagamentoSalvo = (Pagamento)this.pagamentoRepository.save((Object)pagamento);
        PagamentoBoleto pagamentoBoletoSalvo = pagamentoSalvo.getPagamentoBoleto();
        pagamentoBoletoSalvo.getPagamentosDebito().addAll(boleto.getDebitos().stream().map(boletoDebito -> PagamentoDebito.from((BoletoDebito)boletoDebito, (Long)pagamentoBoletoSalvo.getId())).collect(Collectors.toList()));
        return pagamentoSalvo;
    }

    private void pagarParcelas(List<PagamentoDebito> pagamentoDebitos) {
        pagamentoDebitos.stream().map(pagamentoDebito -> pagamentoDebito.getId().getDebitoParcelaTributo().getDebitoParcela()).distinct().forEach(arg_0 -> ((DebitoParcelaService)this.debitoParcelaService).pagarParcela(arg_0));
    }

    private BaixaAutomaticaDetalhe geraPagamentoComDesconto(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe) {
        Pagamento pagamento = this.geraPagamento(baixaAutomaticaDetalhe);
        PagamentoBoleto pagamentoBoleto = pagamento.getPagamentoBoleto();
        this.pagamentoDebitoService.aplicaDescontosNaBaixa(pagamentoBoleto.getPagamentosDebito(), baixaAutomaticaDetalhe.getValorDesconto());
        pagamentoBoleto.setMotivoDeducao(baixaAutomaticaDetalhe.getMotivoDeducao());
        baixaAutomaticaDetalhe.setPagamento((Pagamento)this.pagamentoRepository.save((Object)pagamento));
        TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.PAGO_COM_DESCONTO_CONCEDIDO);
        baixaAutomaticaDetalhe.setSituacao(tipoMensagem.getClassificacao());
        baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
        baixaAutomaticaDetalhe.setMensagemPagoComDesconto(baixaAutomaticaDetalhe.getBoleto(), baixaAutomaticaDetalhe.getPagamento());
        return (BaixaAutomaticaDetalhe)this.baixaAutomaticaDetalheService.save((EloEntity)baixaAutomaticaDetalhe, null);
    }

    private BaixaAutomaticaDetalhe geraPagamentoAMaior(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe) {
        Pagamento pagamento = this.geraPagamento(baixaAutomaticaDetalhe);
        PagamentoBoleto pagamentoBoleto = pagamento.getPagamentoBoleto();
        BigDecimal valorPagoAMaior = baixaAutomaticaDetalhe.getValorPagoAMaior();
        this.pagamentoDebitoService.atualizaValorAMaior(pagamentoBoleto.getPagamentosDebito(), valorPagoAMaior);
        pagamento.setValorPagoAMaior(valorPagoAMaior);
        baixaAutomaticaDetalhe.setPagamento((Pagamento)this.pagamentoRepository.save((Object)pagamento));
        TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.PAGO_COM_SUCESSO);
        baixaAutomaticaDetalhe.setSituacao(tipoMensagem.getClassificacao());
        baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
        baixaAutomaticaDetalhe.setMensagemPagoComSucesso(baixaAutomaticaDetalhe.getBoleto(), baixaAutomaticaDetalhe.getPagamento());
        return (BaixaAutomaticaDetalhe)this.baixaAutomaticaDetalheService.save((EloEntity)baixaAutomaticaDetalhe, null);
    }

    private BaixaAutomaticaDetalhe geraPagamentoAMenor(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe) {
        Pagamento pagamento = this.createPagamento(baixaAutomaticaDetalhe);
        PagamentoBoleto pagamentoBoleto = pagamento.getPagamentoBoleto();
        this.pagamentoDebitoService.atualizaValorAMenor(pagamentoBoleto.getPagamentosDebito(), baixaAutomaticaDetalhe.getValorPago());
        pagamento.setPagoAMenor(Boolean.TRUE);
        baixaAutomaticaDetalhe.setPagamento((Pagamento)this.pagamentoRepository.save((Object)pagamento));
        TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.PAGO_COM_SUCESSO);
        baixaAutomaticaDetalhe.setSituacao(tipoMensagem.getClassificacao());
        baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
        baixaAutomaticaDetalhe.setMensagemPagoAMenor(baixaAutomaticaDetalhe.getBoleto(), baixaAutomaticaDetalhe.getPagamento());
        return (BaixaAutomaticaDetalhe)this.baixaAutomaticaDetalheService.save((EloEntity)baixaAutomaticaDetalhe, null);
    }

    public Boolean existePagamentoNaoEstornadoByIdBoleto(Long idBoleto) {
        return this.pagamentoRepository.existePagamentoNaoEstornadoByIdBoleto(idBoleto);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public BaixaAutomaticaDetalhe geraPagamentoBaixaAutomatica(BaixaAutomaticaDetalheId id) {
        BaixaAutomaticaDetalhe baixaAutomaticaDetalhe = (BaixaAutomaticaDetalhe)this.baixaAutomaticaDetalheService.findOne((Serializable)id);
        if (TipoArquivoRetornoPagamento.SUPER_SIMPLES.equals((Object)baixaAutomaticaDetalhe.getPagamentoLote().getTipoArquivo()) && Objects.isNull(baixaAutomaticaDetalhe.getBoleto())) {
            this.processaPagamentoLoteSuperSimplesService.gerarDebitoEBoleto(baixaAutomaticaDetalhe);
            baixaAutomaticaDetalhe = (BaixaAutomaticaDetalhe)this.baixaAutomaticaDetalheService.save((EloEntity)baixaAutomaticaDetalhe, null);
        }
        if (TipoArquivoRetornoPagamento.SIAFI.equals((Object)baixaAutomaticaDetalhe.getPagamentoLote().getTipoArquivo())) {
            this.processaPagamentoLoteSiafiService.gerarDebitoEBoleto(baixaAutomaticaDetalhe);
            baixaAutomaticaDetalhe = (BaixaAutomaticaDetalhe)this.baixaAutomaticaDetalheService.save((EloEntity)baixaAutomaticaDetalhe, null);
        }
        this.bloquetoService.calcularAcrescimos(baixaAutomaticaDetalhe.getBoleto(), baixaAutomaticaDetalhe.getDataPagamento());
        Long idTipoMensagem = baixaAutomaticaDetalhe.getTipoMensagem().getId();
        switch (1.$SwitchMap$br$com$elotech$tributos$domain$tipomensagem$TipoMensagemEnum[TipoMensagemEnum.fromValue((Long)idTipoMensagem).ordinal()]) {
            case 1: 
            case 2: {
                return this.geraPagamentoComDesconto(baixaAutomaticaDetalhe);
            }
            case 3: {
                return this.geraPagamentoAMaior(baixaAutomaticaDetalhe);
            }
            case 4: {
                return this.geraPagamentoAMenor(baixaAutomaticaDetalhe);
            }
            case 5: 
            case 6: {
                return this.geraPagamentoNormal(baixaAutomaticaDetalhe);
            }
        }
        throw new EloValidationException("Situa\u00e7\u00e3o inv\u00e1lida para baixa.");
    }

    public List<DebitoIdDTO> findIdDebitoItbiListByPagamento(Pagamento pagamento) {
        return this.pagamentoRepository.findIdDebitoItbiListByPagamento(pagamento.getId().getEntidade(), pagamento.getId().getExercicioPagamento(), pagamento.getId().getPagamento());
    }

    public List<DebitoIdDTO> findIdDebitoQuitadoListByPagamento(Pagamento pagamento) {
        return this.pagamentoRepository.findIdDebitoQuitadoListByPagamento(pagamento.getId().getEntidade(), pagamento.getId().getExercicioPagamento(), pagamento.getId().getPagamento());
    }
}

