/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.LivroEstorno;
import br.com.elotech.tributos.domain.LivroEstornoParcelaTributo;
import br.com.elotech.tributos.domain.LivroParcelaTributo;
import br.com.elotech.tributos.domain.MotivoDeducao;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.LivroParcelaEstornoDTO;
import br.com.elotech.tributos.repository.LivroEstornoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.DebitoObservacaoService;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.LivroParcelaTributoService;
import br.com.elotech.tributos.service.cancelamento.CancelamentoDebitoService;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LivroEstornoService
extends CrudService<LivroEstorno, Long> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LivroEstornoService.class);
    private final LivroEstornoRepository livroEstornoRepository;
    private final LivroParcelaTributoService livroParcelaTributoService;
    private final CancelamentoDebitoService cancelamentoDebitoService;
    private final DebitoObservacaoService debitoObservacaoService;
    private final DebitoParcelaService debitoParcelaService;
    private final DebitoService debitoService;

    public LivroEstornoService(LivroEstornoRepository livroEstornoRepository, LivroParcelaTributoService livroParcelaTributoService, CancelamentoDebitoService cancelamentoDebitoService, DebitoObservacaoService debitoObservacaoService, DebitoParcelaService debitoParcelaService, DebitoService debitoService) {
        this.livroEstornoRepository = livroEstornoRepository;
        this.livroParcelaTributoService = livroParcelaTributoService;
        this.cancelamentoDebitoService = cancelamentoDebitoService;
        this.debitoObservacaoService = debitoObservacaoService;
        this.debitoParcelaService = debitoParcelaService;
        this.debitoService = debitoService;
    }

    public void estornarPorLivro(LivroParcelaEstornoDTO livroParcelaEstornoDTO) {
        List livroParcelasTributos = this.livroParcelaTributoService.findByLivro(livroParcelaEstornoDTO.getEntidade(), livroParcelaEstornoDTO.getExercicio(), livroParcelaEstornoDTO.getLivro());
        this.saveLivroEstornoAndUpdateParcelas(livroParcelaEstornoDTO, livroParcelasTributos);
    }

    public void estornarPorRegistros(List<LivroParcelaEstornoDTO> livroParcelaEstornoDTO) {
        livroParcelaEstornoDTO.forEach(estorno -> {
            List livroParcelaTributo = this.livroParcelaTributoService.findByLivroRegistro(estorno.getEntidade(), estorno.getExercicio(), estorno.getLivro(), estorno.getSequencia());
            this.saveLivroEstornoAndUpdateParcelas(estorno, livroParcelaTributo);
        });
    }

    private void saveLivroEstornoAndUpdateParcelas(LivroParcelaEstornoDTO livroEstornoDTO, List<LivroParcelaTributo> livroParcelasTributos) {
        HashMap debitosEnglobados = new HashMap();
        HashMap parcelas = new HashMap();
        List<LivroParcelaTributo> livroParcelasTributosNaoEstornado = livroParcelasTributos.stream().filter(estorno -> Boolean.FALSE.equals(estorno.getEstornado())).collect(Collectors.toList());
        if (livroParcelasTributosNaoEstornado.isEmpty()) {
            throw new EloValidationException(String.format("N\u00e3o h\u00e1 d\u00e9bitos para estornar no livro %d/%d", livroEstornoDTO.getLivro(), livroEstornoDTO.getExercicio()));
        }
        LivroEstorno livroEstorno = new LivroEstorno();
        livroEstorno.setDataEstorno(LocalDate.now());
        livroEstorno.setUsuario(SecurityUtils.getUserAise());
        this.livroEstornoRepository.save((Object)livroEstorno);
        LOGGER.debug("Iniciando o estorno dos registros do livro {}/{}", (Object)livroEstornoDTO.getLivro(), (Object)livroEstornoDTO.getExercicio());
        livroParcelasTributosNaoEstornado.forEach(livroParcelaTributo -> {
            DebitoIdDTO idDebitoEnglobado;
            LOGGER.debug("Estornando livroParcelaTributo com id {}", (Object)livroParcelaTributo.getId());
            this.updateSituacaoLivroParcela(livroParcelaTributo);
            LivroEstornoParcelaTributo livroEstornoParcelaTributo = new LivroEstornoParcelaTributo();
            livroEstornoParcelaTributo.setLivroParcelaTributo(livroParcelaTributo);
            livroEstorno.getLivroEstornoParcelaTributos().add(livroEstornoParcelaTributo);
            DebitoIdDTO idDebito = DebitoIdDTO.of((Long)livroParcelaTributo.getId().getDebitoParcelaTributo().getIdDebito(), (Long)livroParcelaTributo.getId().getDebitoParcelaTributo().getEntidade(), (Long)livroParcelaTributo.getId().getDebitoParcelaTributo().getExercicio(), (Long)livroParcelaTributo.getId().getDebitoParcelaTributo().getTipoCadastro(), (Long)livroParcelaTributo.getId().getDebitoParcelaTributo().getCadastroGeral(), (Long)livroParcelaTributo.getId().getDebitoParcelaTributo().getDivida(), (Long)livroParcelaTributo.getId().getDebitoParcelaTributo().getSubDivida());
            if (Objects.nonNull(livroParcelaTributo.getNovaSubDivida()) && !debitosEnglobados.containsKey(idDebitoEnglobado = this.debitoService.findByCompositeKey(livroParcelaTributo.getId().getDebitoParcelaTributo().getEntidade(), livroParcelaTributo.getId().getDebitoParcelaTributo().getExercicio(), livroParcelaTributo.getId().getDebitoParcelaTributo().getTipoCadastro(), livroParcelaTributo.getId().getDebitoParcelaTributo().getCadastroGeral(), livroParcelaTributo.getId().getDebitoParcelaTributo().getDivida(), livroParcelaTributo.getNovaSubDivida()).map(debito -> DebitoIdDTO.of((Long)debito.getId(), (Long)debito.getEntidade(), (Long)debito.getExercicio(), (Long)debito.getTipoCadastro(), (Long)debito.getCadastroGeralId(), (Long)debito.getDivida().getDivida(), (Long)debito.getSubDivida())).orElseThrow(() -> new EloValidationException("N\u00e3o foi poss\u00edvel encontrar o d\u00e9bito")))) {
                debitosEnglobados.put(idDebitoEnglobado, livroParcelaTributo.getId().getDebitoParcelaTributo().getDebitoParcela().getDebito());
                this.debitoParcelaService.estornoParcelaLivroDividaAtivaEnglobado(idDebitoEnglobado);
                this.cancelarDebitosEnglobados(livroParcelaTributo, idDebitoEnglobado, livroEstornoDTO.getMotivoDeducao());
            }
            if (!parcelas.containsKey(livroParcelaTributo.getId().getDebitoParcelaTributo().getDebitoParcela().getId())) {
                parcelas.put(livroParcelaTributo.getId().getDebitoParcelaTributo().getDebitoParcela().getId(), livroParcelaTributo.getId().getDebitoParcelaTributo().getDebitoParcela());
                this.debitoParcelaService.estornoParcelaLivroDividaAtiva(livroParcelaTributo, idDebito);
            }
        });
        LOGGER.debug("Gerando as observa\u00e7\u00f5es para os d\u00e9bitos estornados");
        this.geraDebitoObservacao(livroEstornoDTO, livroParcelasTributosNaoEstornado);
        this.livroEstornoRepository.save((Object)livroEstorno);
    }

    private void geraDebitoObservacao(LivroParcelaEstornoDTO livroEstornoDTO, List<LivroParcelaTributo> livroParcelasTributosNaoEstornado) {
        livroParcelasTributosNaoEstornado.stream().collect(Collectors.groupingBy(g -> g.getId().getDebitoParcelaTributo().getDebitoParcela().getDebito())).forEach((debito, livroParcelaTributos) -> {
            String parcelasString = livroParcelaTributos.stream().map(livroParcelaTributo -> livroParcelaTributo.getId().getDebitoParcelaTributo().getParcela()).sorted().distinct().map(Objects::toString).collect(Collectors.joining(", "));
            String observacao = String.format("Estorno D\u00edvida Ativa, do livro N\u00ba %d/%d Parcelas: %s", livroEstornoDTO.getLivro(), livroEstornoDTO.getExercicio(), parcelasString);
            DebitoIdDTO idDebitoDTO = DebitoIdDTO.of((Long)debito.getId(), (Long)debito.getEntidade(), (Long)debito.getExercicio(), (Long)debito.getTipoCadastro(), (Long)debito.getCadastroGeralId(), (Long)debito.getGuiaRecolhimento(), (Long)debito.getSubDivida());
            this.debitoObservacaoService.save(idDebitoDTO, observacao);
        });
    }

    private void updateSituacaoLivroParcela(LivroParcelaTributo livroParcelasTributos) {
        this.livroParcelaTributoService.updateSituacaoEstornado(livroParcelasTributos);
    }

    private void cancelarDebitosEnglobados(LivroParcelaTributo livroParcelaTributo, DebitoIdDTO idDebito, MotivoDeducao motivoDeducao) {
        this.cancelamentoDebitoService.cancelamentoDebitoEnglobado(livroParcelaTributo, idDebito, motivoDeducao);
    }
}

