/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.DocumentoFinalidade;
import br.com.elotech.tributos.domain.DocumentoTipo;
import br.com.elotech.tributos.domain.SituacaoDocumento;
import br.com.elotech.tributos.dto.GeracaoDocumentoDTO;
import br.com.elotech.tributos.service.CalculaValidadeDocumentoService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DocumentoFinalidadeService;
import br.com.elotech.tributos.service.DocumentoTipoService;
import br.com.elotech.tributos.service.EntidadeTributacaoService;
import br.com.elotech.tributos.util.UsuarioUtils;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@Transactional
public class GeraDocumentoService {
    private final EntidadeTributacaoService entidadeTributacaoService;
    private final DocumentoTipoService documentoTipoService;
    private final ContextService contextService;
    private final CalculaValidadeDocumentoService calculaValidadeDocumentoService;
    private final DocumentoFinalidadeService documentoFinalidadeService;

    public GeraDocumentoService(EntidadeTributacaoService entidadeTributacaoService, DocumentoTipoService documentoTipoService, ContextService contextService, CalculaValidadeDocumentoService calculaValidadeDocumentoService, DocumentoFinalidadeService documentoFinalidadeService) {
        this.entidadeTributacaoService = entidadeTributacaoService;
        this.documentoTipoService = documentoTipoService;
        this.contextService = contextService;
        this.calculaValidadeDocumentoService = calculaValidadeDocumentoService;
        this.documentoFinalidadeService = documentoFinalidadeService;
    }

    public Documento getDocumentoAndValida(GeracaoDocumentoDTO geracaoDocumentoDto) {
        DocumentoTipo tipoDocumento = this.documentoTipoService.findOne(geracaoDocumentoDto.getIdTipoDocumento());
        String usuarioAise = UsuarioUtils.getUsuarioAise();
        Assert.notNull((Object)tipoDocumento, (String)"Necess\u00e1rio informar o tipo documento.");
        if (tipoDocumento.getExigeProcesso().booleanValue() && Objects.isNull(geracaoDocumentoDto.getIdProcesso())) {
            throw new EloValidationException("Necess\u00e1rio informar o processo.");
        }
        if (Objects.isNull(geracaoDocumentoDto.getPessoa()) && Objects.isNull(geracaoDocumentoDto.getCadastroGeral())) {
            throw new EloValidationException("Necess\u00e1rio informar contribuinte ou cadastro geral.");
        }
        Long entidade = this.contextService.getEntidadePrincipal();
        Long exercicio = this.contextService.getExercicioAtual();
        Documento documento = new Documento();
        documento.setEntidade(entidade);
        documento.setExercicio(exercicio);
        documento.setTipoDocumento(tipoDocumento.getId());
        documento.setDocumentoTipo(tipoDocumento);
        documento.setDataEmissao(LocalDate.now());
        documento.setDataSolicitacao(documento.getDataEmissao());
        documento.setUsuario(usuarioAise);
        documento.setRequerente(geracaoDocumentoDto.getRequerenteNome());
        documento.setCpfRequerente(geracaoDocumentoDto.getRequerenteCpfCnpj());
        documento.setTipoPessoaRequerente(geracaoDocumentoDto.getTipoPessoaRequerente());
        documento.setIdProcesso(geracaoDocumentoDto.getIdProcesso());
        documento.setExercicioProcesso(geracaoDocumentoDto.getExercicioProcesso());
        documento.setObservacao(geracaoDocumentoDto.getObservacao());
        Optional.ofNullable(geracaoDocumentoDto.getPessoa()).ifPresent(pessoa -> {
            documento.setPessoa(pessoa);
            documento.setCnpjCpf(pessoa.getCnpjCpf());
        });
        Optional.ofNullable(geracaoDocumentoDto.getCadastroGeral()).ifPresent(cadastro -> {
            documento.setCadastroGeral(cadastro);
            documento.setTipoCadastro(cadastro.getTipoCadastro());
            documento.setCodigoCadastroGeral(cadastro.getCadastroGeral());
            documento.setPessoa(cadastro.getPessoa());
            documento.setCnpjCpf(cadastro.getPessoa().getCnpjCpf());
        });
        documento.setSituacao(SituacaoDocumento.aberto());
        documento.setEntidadeTributacao(this.entidadeTributacaoService.findByEntidadeIdAndExercicio(entidade, exercicio));
        if (Objects.nonNull(geracaoDocumentoDto.getIdFinalidade())) {
            DocumentoFinalidade documentoFinalidade = this.documentoFinalidadeService.findByIdAndTipoDocumento(geracaoDocumentoDto.getIdFinalidade(), tipoDocumento);
            documento.setDocumentoFinalidade(documentoFinalidade);
            documento.setSequenciaFinalidade(documentoFinalidade.getSequencia());
        }
        documento.setDataValidade(this.calculaValidadeDocumentoService.calculaDataValidade(tipoDocumento, documento.getDocumentoFinalidade()));
        return documento;
    }
}

