/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicio;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicioEnum;
import br.com.elotech.tributos.exception.ParametroEntidadeExercicioNotFoundException;
import br.com.elotech.tributos.repository.EntidadeRepository;
import br.com.elotech.tributos.repository.FormaPagamentoRepository;
import br.com.elotech.tributos.service.ExercicioService;
import br.com.elotech.tributos.service.ParametroEntidadeExercicioService;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
@CacheConfig(cacheNames={"formaPagamento"})
public class FormaPagamentoService
extends CrudService<FormaPagamento, Long> {
    private final FormaPagamentoRepository formaPagamentoRepository;
    private final ParametroEntidadeExercicioService parametroentidadeExerciciService;
    private final ExercicioService exercicioService;
    private final EntidadeRepository entidadeRepository;

    public FormaPagamentoService(FormaPagamentoRepository formaPagamentoRepository, ParametroEntidadeExercicioService parametroentidadeExerciciService, ExercicioService exercicioService, EntidadeRepository entidadeRepository) {
        this.formaPagamentoRepository = formaPagamentoRepository;
        this.parametroentidadeExerciciService = parametroentidadeExerciciService;
        this.exercicioService = exercicioService;
        this.entidadeRepository = entidadeRepository;
    }

    @Cacheable
    public FormaPagamento findOne(Long id) {
        return (FormaPagamento)this.formaPagamentoRepository.findOne((Object)id);
    }

    public List<FormaPagamento> findFormaPagamentoParcelamento(List<Long> parcelamentos) {
        return this.formaPagamentoRepository.findFormaPagamentoParametroParcelamento(parcelamentos);
    }

    public FormaPagamento findFormaPagamentoPadrao(Optional<Long> exercicio) {
        Long exercicioLong;
        Long entidade = Optional.of(this.entidadeRepository.findByEntidadeprincipal()).map(Entidade::getId).orElse(null);
        ParametroEntidadeExercicio parametroEntidadeExercicio = this.parametroentidadeExerciciService.findByKey(entidade, exercicioLong = exercicio.orElse(this.exercicioService.getExercicio()), ModuloEnum.MODULO_TRIBUTARIO.getValue(), ParametroEntidadeExercicioEnum.FORMA_PAGAMENTO_PADRAO.getValue());
        if (Objects.isNull(parametroEntidadeExercicio) || parametroEntidadeExercicio.getValor().isEmpty()) {
            throw new ParametroEntidadeExercicioNotFoundException(String.format("Par\u00e2metro %s n\u00e3o encontrado para o exerc\u00edcio %d", ParametroEntidadeExercicioEnum.FORMA_PAGAMENTO_PADRAO.getValue(), exercicioLong));
        }
        return (FormaPagamento)this.formaPagamentoRepository.findOne((Object)Long.valueOf(parametroEntidadeExercicio.getValor()));
    }
}

