/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.EntidadeCorrecao;
import br.com.elotech.tributos.domain.FormaCorrecao;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicio;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicioEnum;
import br.com.elotech.tributos.domain.acrescimo.IndiceComposto;
import br.com.elotech.tributos.exception.FormaCorrecaoException;
import br.com.elotech.tributos.repository.FormaCorrecaoRepository;
import br.com.elotech.tributos.service.DividaService;
import br.com.elotech.tributos.service.EntidadeCorrecaoService;
import br.com.elotech.tributos.service.ParametroEntidadeExercicioService;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.EntityManager;
import org.hibernate.Hibernate;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
@CacheConfig(cacheNames={"formaCorrecao"})
public class FormaCorrecaoService
extends CrudService<FormaCorrecao, Long> {
    private final FormaCorrecaoRepository formaCorrecaoRepository;
    private final EntityManager em;
    private final DividaService dividaService;
    private final EntidadeCorrecaoService entidadeCorrecaoService;
    private final ParametroEntidadeExercicioService parametroEntidadeExercicioService;

    public FormaCorrecaoService(FormaCorrecaoRepository formaCorrecaoRepository, EntityManager em, DividaService dividaService, EntidadeCorrecaoService entidadeCorrecaoService, ParametroEntidadeExercicioService parametroEntidadeExercicioService) {
        this.formaCorrecaoRepository = formaCorrecaoRepository;
        this.em = em;
        this.dividaService = dividaService;
        this.entidadeCorrecaoService = entidadeCorrecaoService;
        this.parametroEntidadeExercicioService = parametroEntidadeExercicioService;
    }

    @Cacheable
    public FormaCorrecao findOne(Long id) {
        FormaCorrecao entity = (FormaCorrecao)this.formaCorrecaoRepository.findOne((Object)id);
        if (Objects.nonNull(entity)) {
            entity.getIndices().forEach(indiceComposto -> {
                Hibernate.initialize((Object)indiceComposto.getIndiceCorrecao().getValores());
                indiceComposto = (IndiceComposto)Hibernate.unproxy((Object)indiceComposto);
                indiceComposto.setFormaCorrecao(entity);
            });
        }
        return entity;
    }

    public List<FormaCorrecao> findByRsql(Optional<String> search) {
        if (search.isPresent()) {
            Specification specification = Specification.where((Specification)RsqlUtils.createSpecFrom((EntityManager)this.em, FormaCorrecao.class, (String)search.get(), Optional.empty()));
            return this.formaCorrecaoRepository.findAll(specification);
        }
        return this.formaCorrecaoRepository.findAll();
    }

    protected void beforeSave(FormaCorrecao entity, Authentication authentication) {
        entity.setVinculoIndice();
    }

    private Optional<FormaCorrecao> getFormaCorrecaoParametroGeral() {
        return this.parametroEntidadeExercicioService.findByModuloAndParametro(ModuloEnum.MODULO_TRIBUTARIO, ParametroEntidadeExercicioEnum.FORMA_CORRECAO_PADRAO).map(ParametroEntidadeExercicio::getValor).map(Long::valueOf).map(arg_0 -> ((FormaCorrecaoRepository)this.formaCorrecaoRepository).findOne(arg_0));
    }

    private Optional<FormaCorrecao> getFormaCorrecaoFromEntidadeCorrecao(Long entidade, Long exercicio) {
        return this.entidadeCorrecaoService.getEntidadeCorrecaoPrincipal(entidade, exercicio).map(EntidadeCorrecao::getFormaCorrecao);
    }

    private Optional<FormaCorrecao> getFormaCorrecaoFromDivida(Long idDivida) {
        return Optional.ofNullable(this.dividaService.findOne((Serializable)idDivida)).map(Divida::getFormaCorrecao);
    }

    public FormaCorrecao getFormaCorrecaoPadrao(Long idDivida, Long entidade, Long exercicio) {
        return this.getFormaCorrecaoFromDivida(idDivida).orElseGet(() -> this.getFormaCorrecaoFromEntidadeCorrecao(entidade, exercicio).orElseGet(() -> (FormaCorrecao)this.getFormaCorrecaoParametroGeral().orElseThrow(() -> FormaCorrecaoException.notFound((Long)idDivida, (Long)entidade, (Long)exercicio))));
    }
}

