/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.common.service.EntidadeService;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.tributos.domain.DocumentoTipo;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoDocumentoEnum;
import br.com.elotech.tributos.dto.DocumentoTipoDTO;
import br.com.elotech.tributos.repository.DocumentoTipoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class DocumentoTipoService {
    private final DocumentoTipoRepository documentoTipoRepository;
    private final EntityManager em;
    private final EntidadeService entidadeService;

    public DocumentoTipoService(DocumentoTipoRepository documentoTipoRepository, EntityManager em, EntidadeService entidadeService) {
        this.documentoTipoRepository = documentoTipoRepository;
        this.em = em;
        this.entidadeService = entidadeService;
    }

    public List<DocumentoTipo> findByRsql(Optional<String> search) {
        if (search.isPresent()) {
            Specification specification = Specification.where((Specification)RsqlUtils.createSpecFrom((EntityManager)this.em, DocumentoTipo.class, (String)search.get(), Optional.empty()));
            return this.documentoTipoRepository.findAll(specification);
        }
        return this.documentoTipoRepository.findAll();
    }

    public Page<DocumentoTipo> findByRsqlPaged(String search, Pageable pageable) {
        if (StringUtils.isBlank((CharSequence)search)) {
            return this.documentoTipoRepository.findAll(pageable);
        }
        Specification specification = Specification.where((Specification)RsqlUtils.createSpecFrom((EntityManager)this.em, DocumentoTipo.class, (String)search, Optional.empty()));
        return this.documentoTipoRepository.findAll(specification, pageable);
    }

    public DocumentoTipo findOne(Long id) {
        return (DocumentoTipo)this.documentoTipoRepository.findOne((Object)id);
    }

    public List<DocumentoTipoDTO> findPermitidos(Long tipoCadastro) {
        String usuario = Optional.ofNullable(SecurityUtils.getUserAise()).orElseThrow(() -> new RestException(HttpStatus.FORBIDDEN, "Necess\u00e1rio vincular um usu\u00e1rio aise ao usu\u00e1rio logado."));
        List tiposDocumento = this.getTiposPermitidos(tipoCadastro);
        return this.documentoTipoRepository.findPermitidos(this.entidadeService.findEntidadePrincipal().getId(), usuario, TipoCadastro.fromValue((Long)tipoCadastro)).stream().filter(documentoTipo -> tiposDocumento.stream().anyMatch(tipo -> tipo.equals((Object)TipoDocumentoEnum.fromValue((Long)documentoTipo.getId())))).map(DocumentoTipoDTO::of).collect(Collectors.toList());
    }

    public List<TipoDocumentoEnum> getTiposPermitidos(Long tipoCadastro) {
        ArrayList<TipoDocumentoEnum> tiposDocumento = new ArrayList<TipoDocumentoEnum>();
        tiposDocumento.add(TipoDocumentoEnum.CERTIDAO_CONTRIBUINTE);
        tiposDocumento.add(TipoDocumentoEnum.CERTIDAO_CADASTRO_MUNICIPAL);
        if (TipoCadastro.MOBILIARIO.getValue().equals(tipoCadastro)) {
            tiposDocumento.add(TipoDocumentoEnum.CERTIDAO_INSCRICAO);
            tiposDocumento.add(TipoDocumentoEnum.ALVARA_LOCALIZACAO);
            tiposDocumento.add(TipoDocumentoEnum.CERTIDAO_ENCERRAMENTO);
            tiposDocumento.add(TipoDocumentoEnum.ALVARA_LICENCA_SANITARIA);
            tiposDocumento.add(TipoDocumentoEnum.CERTIDAO_CADASTRO_DESATUALIZADO);
            tiposDocumento.add(TipoDocumentoEnum.ALVARA_TAXI);
        }
        return tiposDocumento;
    }
}

