/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.service.support.ReadOnlyService;
import br.com.elotech.tributos.domain.DocumentoFinalidade;
import br.com.elotech.tributos.domain.DocumentoTipo;
import br.com.elotech.tributos.exception.DocumentoFinalidadeException;
import br.com.elotech.tributos.repository.DocumentoFinalidadeRepository;
import br.com.elotech.tributos.repository.projections.DocumentoFinalidadeProjection;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DocumentoFinalidadeService
extends ReadOnlyService<DocumentoFinalidade, Long> {
    private final DocumentoFinalidadeRepository documentoFinalidadeRepository;

    @Autowired
    public DocumentoFinalidadeService(DocumentoFinalidadeRepository repository) {
        this.documentoFinalidadeRepository = repository;
    }

    public List<DocumentoFinalidadeProjection> getListDTO(Long exercicio, Long entidade) {
        return this.documentoFinalidadeRepository.getFinalidade(entidade, exercicio);
    }

    public List<DocumentoFinalidadeProjection> getListDTO(Long entidade, Long exercicio, Long tipoDocumento) {
        return this.documentoFinalidadeRepository.getFinalidadeByTipoDocumento(entidade, exercicio, tipoDocumento);
    }

    public DocumentoFinalidade findByIdAndTipoDocumento(Long idFinalidade, DocumentoTipo tipoDocumento) {
        DocumentoFinalidade documentoFinalidade = (DocumentoFinalidade)this.documentoFinalidadeRepository.findOne((Object)idFinalidade);
        if (Objects.isNull(documentoFinalidade) || !documentoFinalidade.getAtivo().booleanValue()) {
            throw new DocumentoFinalidadeException(HttpStatus.NOT_FOUND, String.format("Documento finalidade %d n\u00e3o encontrado", idFinalidade));
        }
        if (!tipoDocumento.equals((Object)documentoFinalidade.getTipoDocumento())) {
            throw new DocumentoFinalidadeException(HttpStatus.BAD_REQUEST, String.format("Documento finalidade %s n\u00e3o pertence ao tipo documento %s", documentoFinalidade.getDescricao(), tipoDocumento.getDescricao()));
        }
        return documentoFinalidade;
    }
}

