/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.tributos.domain.MultaDiasCorrecao;
import br.com.elotech.tributos.repository.FeriadoRepository;
import br.com.elotech.tributos.util.DateUtils;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.EnumSet;
import java.util.Set;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
@CacheConfig(cacheNames={"diaUtil"})
public class DiaUtilService {
    private static final Set<DayOfWeek> weekend = EnumSet.of(DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    private final FeriadoRepository feriadoRepository;

    DiaUtilService(FeriadoRepository feriadoRepository) {
        this.feriadoRepository = feriadoRepository;
    }

    @Cacheable
    public Boolean diaUtil(LocalDate data) {
        return !weekend.contains(data.getDayOfWeek()) && !this.feriadoRepository.existsByData(data);
    }

    public LocalDate diaUtilProximo(LocalDate data) {
        return this.incrementaDiasUteis(data, Long.valueOf(1L));
    }

    public LocalDate diaUtilAnterior(LocalDate data) {
        return this.incrementaDiasUteis(data, Long.valueOf(-1L));
    }

    public LocalDate incrementaDiasUteis(LocalDate data, Long dias) {
        Long totalDias = dias;
        while (totalDias != 0L) {
            data = totalDias >= 0L ? data.plusDays(1L) : data.minusDays(1L);
            if (!this.diaUtil(data).booleanValue()) continue;
            totalDias = totalDias >= 0L ? totalDias - 1L : totalDias + 1L;
        }
        return data;
    }

    public Long countDiasUteis(LocalDate dataInicial, LocalDate dataFinal) {
        Long totalDias = 0L;
        LocalDate data = dataInicial;
        while (data.compareTo(dataFinal) <= 0) {
            if (this.diaUtil(data).booleanValue()) {
                Long l = totalDias;
                Long l2 = totalDias = Long.valueOf(totalDias + 1L);
            }
            data = data.plusDays(1L);
        }
        return totalDias;
    }

    public Long countDiasAtraso(LocalDate dataInicial, LocalDate dataFinal, MultaDiasCorrecao tipoMulta) {
        Assert.notNull((Object)tipoMulta, (String)"O tipo de multa n\u00e3o pode ser nulo.");
        if (!dataInicial.isBefore(dataFinal)) {
            return 0L;
        }
        return MultaDiasCorrecao.CORRIDO.equals((Object)tipoMulta) ? DateUtils.daysBetween((LocalDate)dataInicial, (LocalDate)dataFinal) : this.countDiasUteis(dataInicial, dataFinal);
    }
}

