/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.fluent.ReportDatasource;
import br.com.elotech.fluent.dataset.DatasetRecord;
import br.com.elotech.fluent.dataset.SimpleDataset;
import br.com.elotech.fluent.param.ParamLoader;
import br.com.elotech.report.EloReportFactory;
import br.com.elotech.report.file.ReportFileResolverFactory;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.dto.DebitoAutomaticoDTO;
import br.com.elotech.tributos.report.RelatorioTributos;
import br.com.elotech.tributos.report.datasetrecord.DebitoAutomaticoDatasetRecord;
import br.com.elotech.tributos.report.function.DebitoAutomaticoDTOToRecord;
import br.com.elotech.tributos.report.loader.DebitoAutomaticoParamLoader;
import br.com.elotech.tributos.repository.EntidadeRepository;
import br.com.elotech.tributos.repository.RelatorioCustomRepository;
import org.springframework.stereotype.Service;

@Service
public class DebitoAutomaticoRelatorioService {
    public static final String DATASET_CABECALHO = "Cabecalho";
    public static final String DATASET_DEBITO_AUTOMATICO = "DebitoAutomatico";
    private final RelatorioCustomRepository relatorioRepository;
    private final EntidadeRepository entidadeRepository;
    private final ReportFileResolverFactory reportFileResolverFactory;

    public DebitoAutomaticoRelatorioService(RelatorioCustomRepository relatorioRepository, EntidadeRepository entidadeRepository, ReportFileResolverFactory reportFileResolverFactory) {
        this.relatorioRepository = relatorioRepository;
        this.entidadeRepository = entidadeRepository;
        this.reportFileResolverFactory = reportFileResolverFactory;
    }

    public byte[] createDebitoAutomaticoPdfReport(DebitoAutomaticoDTO debitoAutomaticoDTO) {
        Entidade entidade = this.entidadeRepository.findByEntidadeprincipal();
        DebitoAutomaticoDatasetRecord record = new DebitoAutomaticoDTOToRecord(entidade.getId()).apply(debitoAutomaticoDTO);
        ReportDatasource datasource = ReportDatasource.builder().add(DATASET_CABECALHO, () -> ((RelatorioCustomRepository)this.relatorioRepository).getCabecalho()).add(DATASET_DEBITO_AUTOMATICO, () -> SimpleDataset.single((DatasetRecord)record, DebitoAutomaticoDatasetRecord.class)).params((ParamLoader)new DebitoAutomaticoParamLoader(record)).build();
        return EloReportFactory.crystal().reportFile(this.reportFileResolverFactory.fromFile(RelatorioTributos.DEBITO_AUTOMATICO.getDefaultRpt())).setReportDatasource(datasource).build().exportToPdf();
    }
}

