/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.service.support.ReadOnlyService;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Carne;
import br.com.elotech.tributos.domain.CarneBoleto;
import br.com.elotech.tributos.domain.CarneBoletoId;
import br.com.elotech.tributos.domain.CarneId;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.OrigemEmissao;
import br.com.elotech.tributos.domain.TipoBloqueto;
import br.com.elotech.tributos.domain.TipoFormaPagamento;
import br.com.elotech.tributos.dto.CarneDTO;
import br.com.elotech.tributos.dto.DebitoAgrupadoPorFormaPagamentoDTO;
import br.com.elotech.tributos.dto.DebitoCarneDTO;
import br.com.elotech.tributos.dto.DebitoParcelaDTO;
import br.com.elotech.tributos.dto.GeraBoletoDTO;
import br.com.elotech.tributos.repository.CarneRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.GeraBoletoService;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.junit.Assert;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CarneService
extends ReadOnlyService<Carne, CarneId> {
    private final CarneRepository carneRepository;
    private final DebitoParcelaService debitoParcelaService;
    private final GeraBoletoService geraBoletoService;

    public CarneService(CarneRepository carneRepository, GeraBoletoService geraBoletoService, DebitoParcelaService debitoParcelaService) {
        this.carneRepository = carneRepository;
        this.geraBoletoService = geraBoletoService;
        this.debitoParcelaService = debitoParcelaService;
    }

    @Transactional
    public CarneDTO geraCarne(DebitoCarneDTO debitoCarne) {
        List parcelas = this.debitoParcelaService.findByDebitoAndAberto(debitoCarne.getEntidade(), debitoCarne.getExercicio(), debitoCarne.getTipoCadastro(), debitoCarne.getCadastroGeral(), debitoCarne.getDivida(), debitoCarne.getSubDivida());
        Assert.assertFalse((String)"N\u00e3o foram encontrados os d\u00e9bitos para a gera\u00e7\u00e3o do carn\u00ea", (boolean)parcelas.isEmpty());
        Carne carneSavedSemNumero = this.save(debitoCarne.toEntity());
        debitoCarne.getFormasPagamento().forEach(formaPagamento -> {
            ArrayList<DebitoParcelaDTO> debitosBoletoFormaPagamento = new ArrayList<DebitoParcelaDTO>();
            for (DebitoParcela debitoParcela : parcelas) {
                if (formaPagamento.getTipoFormaPagamento().equals(TipoFormaPagamento.PARCELADO.getValue()) && !this.isFormaPagamentoParceladoAndNaoVencido(formaPagamento.getTipoFormaPagamento(), debitoParcela)) continue;
                DebitoParcelaDTO debitoParcelaDTO = DebitoParcelaDTO.convertBoleto((DebitoParcela)debitoParcela, (Long)debitoCarne.getIdDebito());
                debitosBoletoFormaPagamento.add(debitoParcelaDTO);
            }
            this.geraBoletoEAdicionaNoCarne(carneSavedSemNumero, debitosBoletoFormaPagamento, formaPagamento);
        });
        return CarneDTO.from((Carne)this.save(carneSavedSemNumero));
    }

    private boolean isFormaPagamentoParceladoAndNaoVencido(String tipoFormaPagamento, DebitoParcela debitoParcela) {
        return TipoFormaPagamento.PARCELADO.getValue().equals(tipoFormaPagamento) && LocalDate.now().compareTo(debitoParcela.getDataVencimento()) <= 0;
    }

    private void geraBoletoEAdicionaNoCarne(Carne carne, List<DebitoParcelaDTO> debitosBoleto, DebitoAgrupadoPorFormaPagamentoDTO formaPagamento) {
        GeraBoletoDTO geraBoletoDTO = new GeraBoletoDTO();
        geraBoletoDTO.setOrigemEmissao(OrigemEmissao.AISE);
        geraBoletoDTO.setTipoBoleto(TipoBloqueto.fromValue((String)formaPagamento.getTipoFormaPagamento()));
        geraBoletoDTO.setDebitos(debitosBoleto);
        List boletos = this.geraBoletoService.geraBoleto(geraBoletoDTO, formaPagamento.getFormaPagamento(), Boolean.TRUE);
        boletos.forEach(boletoGerado -> this.createCarneBoleto(carne, boletoGerado));
    }

    private void createCarneBoleto(Carne carne, Bloqueto boletoGerado) {
        CarneBoletoId carneBoletoId = CarneBoletoId.builder().entidade(carne.getId().getEntidade()).exercicio(carne.getId().getExercicio()).carne(carne.getId().getCarne()).boleto(boletoGerado.getBloqueto()).build();
        carne.getBoletos().add(new CarneBoleto(carneBoletoId));
    }

    private Carne save(Carne carne) {
        if (Objects.isNull(carne.getData())) {
            carne.setData(LocalDate.now());
        }
        if (Objects.isNull(carne.getUsuario())) {
            carne.setUsuario(SecurityUtils.getUserAise());
        }
        if (Objects.isNull(carne.getNumero()) && Objects.nonNull(carne.getId().getCarne())) {
            carne.setNumero(carne.getId().getCarne());
        }
        if (Objects.isNull(carne.getCodigoBarras()) && Objects.nonNull(carne.getId().getCarne())) {
            carne.setCodigoBarras(String.format("%02d%04d%08d", carne.getId().getEntidade(), carne.getId().getExercicio(), carne.getId().getCarne()));
        }
        return (Carne)this.carneRepository.save((Object)carne);
    }

    @Transactional
    public CarneDTO geraCarnePorFormaPagamento(DebitoAgrupadoPorFormaPagamentoDTO params) {
        DebitoCarneDTO debitoCarneDTO = new DebitoCarneDTO();
        debitoCarneDTO.setIdDebito(params.getIdDebito());
        debitoCarneDTO.setEntidade(params.getEntidade());
        debitoCarneDTO.setExercicio(params.getExercicio());
        debitoCarneDTO.setTipoCadastro(params.getTipoCadastro());
        debitoCarneDTO.setCadastroGeral(params.getCadastroGeral());
        debitoCarneDTO.setDivida(params.getDivida());
        debitoCarneDTO.setSubDivida(params.getSubDivida());
        debitoCarneDTO.setFormasPagamento(Collections.singletonList(params));
        return this.geraCarne(debitoCarneDTO);
    }
}

