/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.EnderecoPessoa;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.Proprietario;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.Vinculo;
import br.com.elotech.tributos.repository.CadastroGeralRepository;
import br.com.elotech.tributos.service.PessoaService;
import br.com.elotech.tributos.ws.rest.dto.pessoa.IncluirPessoaAndCadastroAvulsoResponseDTO;
import br.com.elotech.tributos.ws.rest.dto.pessoa.IncluirPessoaRequestDTO;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class CadastroAvulsoService {
    public static final long VINCULO_PRINCIPAL = 1L;
    private final CadastroGeralRepository cadastroGeralRepository;
    private final PessoaService pessoaService;

    public CadastroAvulsoService(CadastroGeralRepository cadastroGeralRepository, PessoaService pessoaService) {
        this.cadastroGeralRepository = cadastroGeralRepository;
        this.pessoaService = pessoaService;
    }

    private static CadastroGeral from(Pessoa pessoa) {
        CadastroGeral cadastroGeral = new CadastroGeral();
        cadastroGeral.setTipoCadastro(TipoCadastro.AVULSO);
        cadastroGeral.setPessoa(pessoa);
        EnderecoPessoa enderecoPrincipal = pessoa.getEnderecoPrincipal();
        if (Objects.nonNull(enderecoPrincipal)) {
            cadastroGeral.setBairro(enderecoPrincipal.getBairro());
            cadastroGeral.setLogradouro(enderecoPrincipal.getLogradouro());
            cadastroGeral.setComplemento(enderecoPrincipal.getComplemento());
            cadastroGeral.setCidade(enderecoPrincipal.getCidade());
            cadastroGeral.setNumero(enderecoPrincipal.getNumero());
            cadastroGeral.setCep(enderecoPrincipal.getCep());
        }
        return cadastroGeral;
    }

    public IncluirPessoaAndCadastroAvulsoResponseDTO incluirCadastroAvulsoEPessoa(IncluirPessoaRequestDTO incluirPessoaRequestDTO) {
        Pessoa pessoa = this.pessoaService.incluirPessoa(incluirPessoaRequestDTO);
        CadastroGeral cadastroAvulso = this.findByPessoaId(pessoa.getId()).stream().findFirst().orElseGet(() -> this.gerarParaPessoa(pessoa));
        return IncluirPessoaAndCadastroAvulsoResponseDTO.of((CadastroGeral)cadastroAvulso);
    }

    private CadastroGeral gerarParaPessoa(Pessoa pessoa) {
        Vinculo vinculoPrincipal = new Vinculo();
        vinculoPrincipal.setId(Long.valueOf(1L));
        CadastroGeral cadastroAvulso = CadastroAvulsoService.from((Pessoa)pessoa);
        Proprietario proprietario = new Proprietario();
        proprietario.setPessoa(pessoa);
        proprietario.setPrincipal(Boolean.TRUE);
        proprietario.setPercentual(new BigDecimal("100"));
        proprietario.setVinculo(vinculoPrincipal);
        cadastroAvulso.getProprietarios().add(proprietario);
        return (CadastroGeral)this.cadastroGeralRepository.save((Object)cadastroAvulso);
    }

    private List<CadastroGeral> findByPessoaId(Long pessoa) {
        return this.cadastroGeralRepository.findByPessoaIdAndTipoCadastro(pessoa, TipoCadastro.AVULSO);
    }
}

