/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.tributos.dto.BatchInstanceDTO;
import br.com.elotech.tributos.dto.HistoricoBatchDTO;
import br.com.elotech.tributos.exception.JobRetryException;
import br.com.elotech.tributos.repository.BatchRepository;
import java.util.List;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.launch.JobOperator;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.launch.NoSuchJobExecutionException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class BatchService {
    private final JobOperator jobOperator;
    private final BatchRepository batchRepository;

    public BatchService(JobOperator jobOperator, BatchRepository batchRepository) {
        this.jobOperator = jobOperator;
        this.batchRepository = batchRepository;
    }

    public void retryJob(Long jobExecutionId) throws JobParametersInvalidException, JobRestartException, NoSuchJobException {
        try {
            this.jobOperator.restart(jobExecutionId.longValue());
        }
        catch (JobInstanceAlreadyCompleteException e) {
            throw new JobRetryException("Essa tarefa j\u00e1 foi finalizada com sucesso em outra tentativa.", (Throwable)e);
        }
        catch (NoSuchJobExecutionException e) {
            throw new JobRetryException(String.format("N\u00e3o foi poss\u00edvel encontrar tarefa com o id %d.", jobExecutionId));
        }
    }

    public Page<BatchInstanceDTO> getTarefas(String search, Pageable pageable) {
        return this.batchRepository.getTarefas(search, pageable);
    }

    public List<HistoricoBatchDTO> findHistoricoExecutionByInstanceId(Long instanceId) {
        return this.batchRepository.findHistoricoExecutionByInstanceId(instanceId);
    }

    public Boolean hasRunningJob() {
        return this.batchRepository.hasRunningJob();
    }
}

