/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.pagamento.PagamentoLoteId;
import br.com.elotech.tributos.dto.pagamento.AiseImportacaoArquivoRetornoPagamentoResultDTO;
import br.com.elotech.tributos.dto.pagamento.ImportacaoArquivoRetornoPagamentoDTO;
import br.com.elotech.tributos.dto.pagamento.PagamentoLoteDTO;
import br.com.elotech.tributos.dto.pagamento.QuantidadeInconsistenciaLoteDTO;
import br.com.elotech.tributos.service.BaixaAutomaticaDetalheService;
import br.com.elotech.tributos.service.PagamentoLoteService;
import br.com.elotech.tributos.service.ProcessaPagamentoLoteService;
import br.com.elotech.tributos.service.batch.BaixaAutomaticaJobStarter;
import java.io.IOException;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.SortedMap;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/pagamento-lotes"})
public class PagamentoLoteResource
extends CrudResource<PagamentoLote, PagamentoLoteId> {
    private final ProcessaPagamentoLoteService processaPagamentoLoteService;
    private final PagamentoLoteService pagamentoLoteService;
    private final BaixaAutomaticaDetalheService baixaAutomaticaDetalheService;
    private final BaixaAutomaticaJobStarter baixaAutomaticaJobStarter;

    public PagamentoLoteResource(ProcessaPagamentoLoteService processaPagamentoLoteService, PagamentoLoteService pagamentoLoteService, BaixaAutomaticaDetalheService baixaAutomaticaDetalheService, BaixaAutomaticaJobStarter baixaAutomaticaJobStarter) {
        this.processaPagamentoLoteService = processaPagamentoLoteService;
        this.pagamentoLoteService = pagamentoLoteService;
        this.baixaAutomaticaDetalheService = baixaAutomaticaDetalheService;
        this.baixaAutomaticaJobStarter = baixaAutomaticaJobStarter;
    }

    @GetMapping(value={"/search"})
    public ResponseEntity<Page<PagamentoLoteDTO>> searchPagamentos(@RequestParam Optional<String> search, Pageable page) {
        return ResponseEntity.ok((Object)this.getService().findByRsql((String)search.orElse(null), page).map(PagamentoLoteDTO::of));
    }

    @GetMapping(value={"/baixa-automatica-lote/{entidade}/{exercicio}/{lote}"})
    public ResponseEntity<QuantidadeInconsistenciaLoteDTO> countBaixaAutomaticaByLote(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long lote) {
        return ResponseEntity.ok((Object)this.baixaAutomaticaDetalheService.countInconsistenciasLote(entidade, exercicio, lote));
    }

    @PutMapping(value={"/reabrir-lote/{entidade}/{exercicio}/{lote}"})
    public ResponseEntity<Void> reabrirLote(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long lote) {
        this.pagamentoLoteService.reabrirLote(entidade, exercicio, lote);
        return ResponseEntity.ok().build();
    }

    @PutMapping(value={"/fechar-lote/{entidade}/{exercicio}/{lote}"})
    public ResponseEntity<Void> fecharLote(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long lote) {
        this.pagamentoLoteService.fecharLote(entidade, exercicio, lote);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/importar-arquivo-retorno"})
    public ResponseEntity<AiseImportacaoArquivoRetornoPagamentoResultDTO> importarArquivoRetorno(ImportacaoArquivoRetornoPagamentoDTO arquivoRetorno, @RequestParam MultipartFile file) throws IOException {
        return ResponseEntity.ok((Object)this.pagamentoLoteService.importarArquivoRetorno(arquivoRetorno, file.getBytes()));
    }

    @GetMapping(value={"arquivo-pagamento-retorno/{entidade}/{exercicio}/{lote}"})
    public ResponseEntity<PagamentoLoteDTO> findPagamentoLote(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long lote) {
        return ResponseEntity.ok((Object)this.pagamentoLoteService.findPagamentoLoteDTO(entidade, exercicio, lote));
    }

    @PostMapping(value={"/{entidade}/{exercicio}/{lote}/verificar"})
    public ResponseEntity<Void> verificarLote(@PathVariable(value="entidade") Long entidade, @PathVariable(value="exercicio") Long exercicio, @PathVariable(value="lote") Long lote) {
        this.processaPagamentoLoteService.verificarLote(entidade, exercicio, lote);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/por-data"})
    public ResponseEntity<SortedMap<LocalDate, List<PagamentoLoteDTO>>> findPagamentoLotePorDia(@RequestBody List<LocalDate> diasSelecionados) {
        return ResponseEntity.ok((Object)this.pagamentoLoteService.findPagamentoLotePorDia(diasSelecionados));
    }

    @PostMapping(value={"/{entidade}/{exercicio}/{lote}/baixar"})
    public ResponseEntity<Void> baixarLote(@PathVariable(value="entidade") Long entidade, @PathVariable(value="exercicio") Long exercicio, @PathVariable(value="lote") Long lote) throws JobParametersInvalidException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException {
        this.baixaAutomaticaJobStarter.startJob(entidade, exercicio, lote);
        return ResponseEntity.ok().build();
    }
}

