/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.DocumentoPessoa;
import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.documento.cda.AdicionaCDAProprietarioDTO;
import br.com.elotech.tributos.dto.documento.cda.DeleteCDAProprietarioDTO;
import br.com.elotech.tributos.service.DocumentoPessoaService;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/documentos-pessoas"})
public class DocumentoPessoaResource
extends CrudResource<DocumentoPessoa, Long> {
    private final DocumentoPessoaService documentoPessoaService;

    public DocumentoPessoaResource(DocumentoPessoaService documentoPessoaService) {
        this.documentoPessoaService = documentoPessoaService;
    }

    @Transactional
    @DeleteMapping(params={"idDocumento", "idDocumentoPessoa"})
    public ResponseEntity<Void> removerPessoa(DeleteCDAProprietarioDTO deleteCDAProprietarioDTO) {
        this.documentoPessoaService.removePessoa(deleteCDAProprietarioDTO.getIdDocumento(), deleteCDAProprietarioDTO.getIdDocumentoPessoa());
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/add"})
    public ResponseEntity<DocumentoDTO> adicionarPessoa(@Valid @RequestBody AdicionaCDAProprietarioDTO adicionaCDAProprietarioDTO) {
        Documento documento = this.documentoPessoaService.adicionarPessoaAoDocumento(adicionaCDAProprietarioDTO.getIdDocumento(), adicionaCDAProprietarioDTO.getIdPessoa());
        return ResponseEntity.ok((Object)DocumentoDTO.from((Documento)documento));
    }
}

