/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.dto.DebitoConsultaCancelamentoPorParcelaDTO;
import br.com.elotech.tributos.dto.DebitoConsultaCreditoPorParcelaDTO;
import br.com.elotech.tributos.dto.DebitoConsultaDTO;
import br.com.elotech.tributos.dto.DebitoConsultaTributoPorParcelaDTO;
import br.com.elotech.tributos.dto.DebitoDTO;
import br.com.elotech.tributos.dto.DebitoDetalheParcelasDTO;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.DebitoManualDTO;
import br.com.elotech.tributos.dto.DebitoManualIssDTO;
import br.com.elotech.tributos.dto.DebitoManualParcelaDTO;
import br.com.elotech.tributos.dto.DebitoParcelaPagamentoDTO;
import br.com.elotech.tributos.dto.DebitoPesquisaDTO;
import br.com.elotech.tributos.dto.GerarParcelasDebitoDTO;
import br.com.elotech.tributos.dto.IdDebitoDTO;
import br.com.elotech.tributos.dto.ImprimirRelatorioDTO;
import br.com.elotech.tributos.dto.PessoaDebitoDTO;
import br.com.elotech.tributos.dto.mobile.DebitoMobileDTO;
import br.com.elotech.tributos.dto.mobile.DebitoParcelaMobileDTO;
import br.com.elotech.tributos.params.CadastroGeralParams;
import br.com.elotech.tributos.params.DebitoParams;
import br.com.elotech.tributos.params.ExtratoParams;
import br.com.elotech.tributos.params.NextSubdividaValueParams;
import br.com.elotech.tributos.resource.RelatorioResource;
import br.com.elotech.tributos.service.AiseDebitoService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.GeraDebitoService;
import br.com.elotech.tributos.service.PagamentoService;
import br.com.elotech.tributos.ws.rest.dto.DebitoExtratoDTO;
import br.com.elotech.tributos.ws.rest.dto.GerarDebitoRequestDTO;
import br.com.elotech.tributos.ws.rest.dto.GerarDebitoResponseDTO;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/debitos"})
@CrossOrigin
public class DebitosResource {
    private final AiseDebitoService aiseDebitoService;
    private final DebitoService debitoService;
    private final PagamentoService pagamentoService;
    private final RelatorioResource relatorioResource;
    private final GeraDebitoService geraDebitoService;

    public DebitosResource(AiseDebitoService aiseDebitoService, DebitoService debitoService, PagamentoService pagamentoService, RelatorioResource relatorioResource, GeraDebitoService geraDebitoService) {
        this.aiseDebitoService = aiseDebitoService;
        this.debitoService = debitoService;
        this.pagamentoService = pagamentoService;
        this.relatorioResource = relatorioResource;
        this.geraDebitoService = geraDebitoService;
    }

    @GetMapping(path={"/by-id/{id}"})
    public ResponseEntity<Debito> getDebitosAgrupados(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok().body((Object)this.debitoService.findOne((Serializable)id));
    }

    @GetMapping(path={"/agrupados"}, params={"tipoCadastro", "cadastroGeral"})
    public ResponseEntity<List<DebitoDTO>> getDebitosAgrupados(CadastroGeralParams params) {
        return ResponseEntity.ok().body((Object)this.aiseDebitoService.getDebitosAgrupados(params));
    }

    @GetMapping(params={"tipoCadastro", "cadastroGeral"})
    public ResponseEntity<List<DebitoDTO>> getDebitos(CadastroGeralParams params) {
        return ResponseEntity.ok().body((Object)this.aiseDebitoService.getDebitos(params));
    }

    @GetMapping(path={"/agrupados-mobile"}, params={"tipoCadastro", "cadastroGeral"})
    public ResponseEntity<List<DebitoMobileDTO>> getDebitosResumo(CadastroGeralParams params) {
        return ResponseEntity.ok().body((Object)this.aiseDebitoService.getDebitosMobile(params));
    }

    @GetMapping(path={"/{id}/parcelas"})
    public ResponseEntity<List<DebitoParcelaMobileDTO>> getParcelas(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok().body((Object)this.aiseDebitoService.getParcelas(id));
    }

    @GetMapping(path={"/{id}/consulta"})
    public ResponseEntity<DebitoConsultaDTO> getDebitosConsulta(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.debitoService.getDebitosConsulta(id));
    }

    @GetMapping(path={"/{id}/parcelas-parcelamento"})
    public ResponseEntity<List<DebitoParcelaMobileDTO>> getParcelasParcelamento(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok().body((Object)this.aiseDebitoService.getParcelasParcelamento(id));
    }

    @PostMapping
    public ResponseEntity<GerarDebitoResponseDTO> gerarDebito(@RequestBody GerarDebitoRequestDTO debito) {
        return ResponseEntity.ok().body((Object)this.aiseDebitoService.geraDebito(debito));
    }

    @PostMapping(value={"/verificar-pagos"})
    public ResponseEntity<List<IdDebitoDTO>> verificarPagos(@RequestBody List<IdDebitoDTO> listIdDebito) {
        return ResponseEntity.ok((Object)this.aiseDebitoService.verificarPagos(listIdDebito));
    }

    @GetMapping(value={"/documento/{documento}"})
    public ResponseEntity<PessoaDebitoDTO> possuiDebitoEmAberto(@PathVariable(value="documento") String cnpjCpf) {
        return ResponseEntity.ok((Object)new PessoaDebitoDTO(cnpjCpf, this.aiseDebitoService.possuiDebitos(cnpjCpf)));
    }

    @GetMapping(value={"/extrato"}, params={"tipoCadastro", "cadastroGeral"})
    public ResponseEntity<Page<DebitoExtratoDTO>> getExtratoDebitos(ExtratoParams params, Pageable pageable) {
        List allRecords = this.aiseDebitoService.getExtratoDebitos(params);
        List lista = allRecords.stream().skip(pageable.getOffset()).limit(pageable.getPageSize()).collect(Collectors.toList());
        return ResponseEntity.ok().body((Object)new PageImpl(lista, pageable, (long)allRecords.size()));
    }

    @GetMapping(value={"/search"})
    public ResponseEntity<Page<DebitoPesquisaDTO>> findAllDebito(@RequestParam String search, Pageable page) {
        Page result = this.debitoService.findByRsql(search, page);
        Page resultDto = result.map(DebitoPesquisaDTO::from);
        return ResponseEntity.ok((Object)resultDto);
    }

    @GetMapping(value={"/{id}/parcelas/{parcela}"})
    public ResponseEntity<DebitoDetalheParcelasDTO> getDetalhamentoParcela(@PathVariable(value="id") Long id, @PathVariable(value="parcela") Long parcela) {
        return ResponseEntity.ok().body((Object)this.debitoService.findDebitosParcelasByIdAndParcela(id, parcela));
    }

    @GetMapping(path={"/{id}/pagamentos/{parcela}"})
    public ResponseEntity<List<DebitoParcelaPagamentoDTO>> getPagamentoParcelas(@PathVariable(value="id") Long id, @PathVariable(value="parcela") Long parcela) {
        Debito debito = (Debito)this.debitoService.findOne((Serializable)id);
        return Objects.nonNull(debito) ? ResponseEntity.ok().body((Object)this.pagamentoService.loadDebitoParcelaPagamento(debito, parcela)) : ResponseEntity.ok().body(new ArrayList());
    }

    @GetMapping(path={"/{id}/cancelamentos/{parcela}"})
    public ResponseEntity<List<DebitoConsultaCancelamentoPorParcelaDTO>> getCancelamentosPorParcelas(@PathVariable(value="id") Long id, @PathVariable(value="parcela") Long parcela) {
        Debito debito = (Debito)this.debitoService.findOne((Serializable)id);
        if (Objects.nonNull(debito)) {
            return ResponseEntity.ok().body((Object)this.debitoService.findCancelamentosPorParcela(debito, parcela));
        }
        return ResponseEntity.ok().body(new ArrayList());
    }

    @GetMapping(value={"/{id}/creditos/{parcela}"})
    public ResponseEntity<List<DebitoConsultaCreditoPorParcelaDTO>> getCreditosByIdAndParcela(@PathVariable(value="id") Long id, @PathVariable(value="parcela") Long parcela) {
        Debito debito = (Debito)this.debitoService.findOne((Serializable)id);
        if (Objects.nonNull(debito)) {
            return ResponseEntity.ok().body((Object)this.debitoService.findCreditosPorParcela(debito, parcela));
        }
        return ResponseEntity.ok().body(new ArrayList());
    }

    @GetMapping(value={"/{id}/tributos/{parcela}"})
    public ResponseEntity<List<DebitoConsultaTributoPorParcelaDTO>> getTributosByIdAnParcela(@PathVariable(value="id") Long id, @PathVariable(value="parcela") Long parcela) {
        Debito debito = (Debito)this.debitoService.findOne((Serializable)id);
        if (Objects.nonNull(debito)) {
            return ResponseEntity.ok().body((Object)this.debitoService.findTributosPorParcela(debito, parcela));
        }
        return ResponseEntity.ok().body(new ArrayList());
    }

    @GetMapping(value={"/imprimir-historico-debito"}, params={"entidade", "exercicio", "tipoCadastro", "cadastroGeral", "divida", "subDivida"})
    public void imprimirHistoricoDebito(DebitoParams params, HttpServletResponse response) throws IOException {
        ImprimirRelatorioDTO imprimirRelatorioDTO = this.debitoService.getImprimirHitoricoDebito(params);
        this.relatorioResource.imprimirRelatorioGenerico(imprimirRelatorioDTO, response);
    }

    @GetMapping(value={"/next-subdivida"})
    public ResponseEntity<Long> getNextValueSubdivida(NextSubdividaValueParams params) {
        return ResponseEntity.ok((Object)this.debitoService.getNextValueSubdivida(params));
    }

    @PostMapping(value={"/manual"})
    public ResponseEntity<DebitoIdDTO> createDebitoManual(@RequestBody @Valid DebitoManualDTO debitoManualDTO) {
        return ResponseEntity.ok((Object)this.geraDebitoService.geraDebitoManual(debitoManualDTO));
    }

    @PostMapping(value={"/manual-iss"})
    public ResponseEntity<Void> createDebitoManualIss(@RequestBody @Valid DebitoManualIssDTO debitoManualDTO) {
        this.geraDebitoService.geraDebitoManualIss(debitoManualDTO);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/gerar-parcelas"})
    public ResponseEntity<List<DebitoManualParcelaDTO>> gerarParcelas(@RequestBody @Valid GerarParcelasDebitoDTO gerarParcelasDebitoDTO) {
        return ResponseEntity.ok((Object)this.geraDebitoService.gerarParcelas(gerarParcelasDebitoDTO));
    }

    @GetMapping(value={"/by-composite-key"})
    public ResponseEntity<Debito> getDebitoByPk(DebitoParams debitoParams) {
        return this.debitoService.findByCompositeKey(debitoParams.getEntidade(), debitoParams.getExercicio(), debitoParams.getTipoCadastro(), debitoParams.getCadastroGeral(), debitoParams.getDivida(), debitoParams.getSubDivida()).map(ResponseEntity::ok).orElseThrow(() -> new RestException(HttpStatus.NOT_FOUND, String.format("N\u00e3o foi poss\u00edvel encontrar d\u00e9bito com a seguinte chave: [Entidade %d, Exerc\u00edcio %d, TipoCadastro %d, CadastroGeral %d, Divida %d, Subd\u00edvida %d]", debitoParams.getEntidade(), debitoParams.getExercicio(), debitoParams.getTipoCadastro(), debitoParams.getCadastroGeral(), debitoParams.getDivida(), debitoParams.getSubDivida())));
    }
}

