/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.dto.ImpressaoDTO;
import br.com.elotech.tributos.dto.mobile.DocumentoMobileDTO;
import br.com.elotech.tributos.params.CertidaoParams;
import br.com.elotech.tributos.service.CertidaoService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.exception.CadastroNaoEncontradoException;
import br.com.elotech.tributos.service.ws.AisePdfService;
import br.com.elotech.tributos.ws.domain.GeraCertidaoResposta;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/certidao"})
public class CertidaoResource {
    private final CertidaoService certidaoService;
    private final AisePdfService aisePdfService;
    private final DocumentoService documentoService;
    private final ContextService contextService;

    public CertidaoResource(CertidaoService certidaoService, AisePdfService aisePdfService, DocumentoService documentoService, ContextService contextService) {
        this.certidaoService = certidaoService;
        this.aisePdfService = aisePdfService;
        this.documentoService = documentoService;
        this.contextService = contextService;
    }

    @PostMapping
    public ImpressaoDTO imprimirCertidao(@RequestBody CertidaoParams params) {
        try {
            GeraCertidaoResposta resposta = this.certidaoService.geraCertidao(params);
            return ImpressaoDTO.from((String)this.aisePdfService.fetchDocumento(resposta.getDocumento(), resposta.getTipoDocumento(), resposta.getExercicio()));
        }
        catch (CadastroNaoEncontradoException e) {
            throw RestException.notFound((String)e.getMessage(), (Throwable)e);
        }
    }

    @PostMapping(path={"/gera"})
    public DocumentoMobileDTO gerarCertidao(@RequestBody CertidaoParams params) {
        try {
            GeraCertidaoResposta resposta = this.certidaoService.geraCertidao(params);
            return this.documentoService.getDocumentoMobileDTO(this.contextService.getEntidadePrincipal(), resposta.getExercicio(), resposta.getTipoDocumento(), resposta.getDocumento());
        }
        catch (CadastroNaoEncontradoException e) {
            throw RestException.notFound((String)e.getMessage(), (Throwable)e);
        }
    }
}

